#!/usr/bin/env kjscmd

function newArticles( articles )
{

	var box = new QVBox(main);
	var count = articles.call("count()");
	var label = new QLabel(box);
	var list = new KListBox(box);


	label.text = count + " articles for " + articles.call("title()");
	for( var idx = 0; idx < count; ++idx)
	{
		var article = articles.call("article(int)", idx);
		list.insertItem( article.call( "title()" ));
	}
	box.show();
	return true;
}

var main = new QHBox(this)
var dcop = new DCOPInterface(this, "news");
dcop.publish("void newArticles(DCOPRef)");

var client = new DCOPClient(this);
var feeds = client.call( "rssservice", "RSSService", "list()" );

for( var idx = 0; idx < feeds.length; ++idx)
{
	var doc = client.call( "rssservice", "RSSService", "add(QString)", feeds[idx] );
	client.connectDCOPSignal("rssservice", doc.obj(), "documentUpdated(DCOPRef)",
			"news","newArticles(DCOPRef)");
	doc.call("refresh()");
}
main.show();

application.exec();

