"""
Copyright 2003 Jim Bublitz

Terms and Conditions

Permission is hereby granted, free of charge, to any person obtaining a copy
of this software and associated documentation files (the "Software"), to
deal in the Software without restriction, including without limitation the
rights to use, copy, modify, merge, publish, distribute, sublicense, and/or
sell copies of the Software, and to permit persons to whom the Software is
furnished to do so, subject to the following conditions:

The above copyright notice and this permission notice shall be included in
all copies or substantial portions of the Software.

THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL THE
COPYRIGHT HOLDER BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY,
WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR
IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
SOFTWARE.

Except as contained in this notice, the name of the copyright holder shall
not be used in advertising or otherwise to promote the sale, use or other
dealings in this Software without prior written authorization from the
copyright holder.
"""

import sys, time
import dcop
import dcopext
from kdecore import KApplication, KCmdLineArgs, KAboutData
from qt import QString, QCString



def getAnyApplication (client, appName):
    for qcstring_app in client.registeredApplications ():
        app = str (qcstring_app)
        if app == appName or app.startswith (appName + "-"):
            print app
            print
            objList, ok = client.remoteObjects (app)
            for obj in objList:
                print " ", obj
                funcs, ok = client.remoteFunctions (app, obj)
                for f in funcs:
                    print " ", " ", f
            break


#-------------------- main ------------------------------------------------

description = "A basic application template"
version     = "1.0"
aboutData   = KAboutData ("testdcopext", "testdcopext",\
    version, description, KAboutData.License_GPL,\
    "(C) 2003 whoever the author is")

aboutData.addAuthor ("author1", "whatever they did", "email@somedomain")
aboutData.addAuthor ("author2", "they did something else", "another@email.address")

KCmdLineArgs.init (sys.argv, aboutData)

KCmdLineArgs.addCmdLineOptions ([("+files", "File to open")])

app  = KApplication ()
dcop = app.dcopClient ()

#getAnyApplication (dcop, "konqueror")
print "--------------------------"
print "The DCOPObjects for kicker:"
d = dcopext.DCOPApp ("kicker", dcop)
objs = d.objects
if objs:
    for obj in objs:
        print obj
o = d.object ("Panel")
methods = o.methods
for method in methods:
    print method
m = o.method ("addNonKDEAppButton")

print "--------------------------"
print "The method"
print m.method
print "--------------------------"
print "Find the method:"
print m.findMethod ()
print "--------------------------"
print "The return type:"
print m.rtype
print "--------------------------"
print "The argument types:"
print m.argtypes
print "--------------------------"
print "The argument names:"
print m.argnames
print "--------------------------"

print
print "get kicker panel size via DCOP"
res = d.Panel.panelSize()
print res, d.Panel.panelSize.valid
print "--------------------------"

print "Call a method that doesn't exist"
res = d.Panel.junk ()
print res
print "--------------------------"

print "See if a non-existent method is valid"
print d.Panel.junk.valid
print
print "--------------------------"

print
print
print "Start a kwrite instance"
errcode, error, dcopService, pid = KApplication.startServiceByDesktopName ("kwrite", "")
dcopService = "kwrite-" + str (pid)
print "errcode: %i   error: %s   dcopService: %s  pid: %i" % (errcode, error, dcopService, pid)
print "--------------------------"
time.sleep (2)

o1 = dcopext.DCOPObj (dcopService, dcop, "EditInterface#1")
print "Check if insertLine is a valid function"
print "valid", o1.insertLine.valid
print "--------------------------"
print "insertLine's arg types and names"
print o1.insertLine.argtypes,  o1.insertLine.argnames
print "--------------------------"
print "Insert a line into the kwrite instance we launched"
print "call returns:", o1.insertLine (0, "Now is the time for all good men to come to the aid of their party")
