
/*
 * 
 * copywrite 2003-4 under GNU/GPL which means what it means.
 * Edscott Wilson Garcia 
 *
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/wait.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <limits.h>
#include <signal.h>

#include <gtk/gtk.h>


#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "rcp.h"

#include "cpy.h"
#include "remove.h"
#include "misc.h"
#include "monitor.h"
#include "password_dialog.h"
#include "tubo.h"

/*#define DEBUG*/

static int childFD;
extern gboolean force_override;
static pid_t Gpid;
static gboolean exit_status;

G_MODULE_EXPORT
char *src_host = NULL;


static gint watch_stop(gpointer data)
{

    if(!tree_details->tubo_object) return FALSE;
    if(tree_details->stop)
    {
	gchar *m=g_strdup_printf("%d", Gpid);
	print_diagnostics("xfce/warning", strerror(ECANCELLED), " pid=", m, NULL);
	g_free(m);
	/*cancelled = TRUE;*/
	TuboCancel(tree_details->tubo_object, NULL);
	tree_details->stop = FALSE;
	tree_details->tubo_object = NULL;
	hide_stop();
	Gpid = 0;
	cursor_reset();
	return FALSE;
    }
    set_progress(-1, -1);
    return TRUE;
}

static int operate_stderr(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    if (!line) return TRUE;
    D(printf("stderr:%s",line);)
    if (strncmp(line,"debug1:",strlen("debug1:"))==0){
#ifdef DEBUG
	    printf("%s",line);
#endif
    }
    if (line[0] != '\n'){
	   if (strncmp(line,"debug1:",strlen("debug1:"))!=0 ||
		strstr(line,"uthentication"))  {
	      print_diagnostics( "xfce/error", line, NULL);
	   }
    }
    if (strstr(line,"debug1: Exit status 1")) exit_status=TRUE;
    
    if (strstr(line,"Next authentication method: password") || strstr(line,"assword:")){
	const char *p;
    	print_diagnostics( "xfce/warning",_("Query password has been requested"),"\n", NULL);
	p=get_password(tree_details->window,_("Query password has been requested"));
	if (p && strlen(p)) write(childFD,p,strlen(p));
	write(childFD,"\n",strlen("\n"));
	return TRUE;
    }
    return TRUE;
}

static int operate_stdout(int n, void *data)
{
    char *line;
    if(n)
	return TRUE;		/* this would mean binary data */
    line = (char *)data;
    D(printf("stdout:%s",line);)
    print_diagnostics(NULL, line, NULL);
    return TRUE;
}


static void fork_finished_function(pid_t pid)
{
    char m[32];
    /*tree_entry_t *en;*/
    int status;
    /*GtkTreeIter iter;*/
    sprintf(m, "%d\n", pid);

    tree_details->tubo_object = NULL;
    hide_stop();
    cursor_reset();
    /* another wait just in case the one in tubo misses 
     * (shouldn't happen, but it does)*/
    
    waitpid(pid, &status, WNOHANG);
    if (exit_status)
	    print_diagnostics("xfce/error", _("Command done"), "\n",NULL);
    else
	    print_diagnostics("xfce/info",  _("Command done"), "\n",NULL);
    local_monitor(TRUE);
}

static int _scp(char **srcs, char *tgt){
    static char *argument[1024];
    gchar *arg1=NULL;
    int i=0,j,k;
    gchar *g_tgt;
    struct stat st;

    exit_status=FALSE;
    if (!src_host) return FALSE;
    if (!tgt) return FALSE;

    if (stat(tgt,&st) < 0){
	    printf("invalid target!\n");
	    return FALSE;
    }
    if (S_ISDIR(st.st_mode)) g_tgt = g_strdup(tgt);
    else g_tgt=g_path_get_dirname(tgt);
    if (!g_tgt) return FALSE;

    if (!srcs[0]) return FALSE;
    if (tree_details->tubo_object){
	print_diagnostics("xfce/warning","wait....\n",NULL);
	    return FALSE;
    }
    

    if(tree_details->preferences & RSH_X_SSH) {
	argument[i++]="rcp";
    	argument[i++]="-r";
    	argument[i++]="-p";
	print_diagnostics(NULL,"rcp -r -p ",srcs[0],"....\n",NULL);
    } else {
    	argument[i++]="scp";
    	argument[i++]="-v";
    	argument[i++]="-r";
    	argument[i++]="-p";
    	argument[i++]="-C";
    	argument[i++]="-B";
    }
    k=i;
    force_override=FALSE;

    for (j=0;srcs[j] && j < 1023;j++){
	    if (strchr(srcs[j],' ')!=NULL){
		    print_diagnostics("xfce/error",_("Cannot rcp/scp files with embedded spaces"),":\n",srcs[j],"\n",NULL);
		    continue;
	    }
	    if (!arg1){
		    argument[i++] = arg1 = g_strconcat(src_host,":",srcs[j],NULL);
	    } else {
		    argument[i++] = g_strconcat(src_host,":",srcs[j],NULL);
	    }
	    argument[i]=NULL;
	    {
		gchar *b=g_path_get_basename(srcs[j]);
		gchar *f=g_strconcat(g_tgt,"/",b);
		g_free(b);
		if (access(f,F_OK)==0){
		   /* externs from cpy.c: */	
		   int r= warn_target_exists(f, NULL);
		   if(r == DLG_WASTE)
		   {
			if(!wasteit(f))
			{
w_cancel:
				g_free(f);f=NULL;
				goto cancel_it;
			}
		   }
		   else if (r==DLG_CANCEL) goto w_cancel;
		   g_free(f);f=NULL;
		}
	    }
    }
    argument[i++]=g_tgt;
    
    argument[i++]=NULL;

#ifdef DEBUG
    printf("Tubo: ");
    for (j=0;argument[j];j++){
	    printf("%s ",argument[j]);
    }
    printf("\n");
#endif
	
    show_stop();
	

    tree_details->tubo_object = 
		Tubo(fork_function, 
				(void *)argument, 
				fork_finished_function, 
				&childFD, 
				operate_stdout, 
				operate_stderr,0,TRUE);
    	
    g_timeout_add_full(0,260, (GtkFunction) watch_stop,NULL, NULL);
    	
    Gpid = TuboPID(tree_details->tubo_object);
cancel_it:
    chdir(GETWD);
    for (j=k;argument[j];j++) g_free(argument[j]);
    return(1);
}



G_MODULE_EXPORT
int rsync(char **srcs, char *tgt){
/*   if (tree_details->preferences & RSYNC_X_SCP) */
	   return _scp(srcs,tgt);
   /*else 
	   return _rsync(treeview,srcs,tgt);*/
	
}



#if 0
int rsync(GtkTreeView * treeview, char **srcs, char *tgt)
{
    char *argv[1024 + 50], *c, *cmd;
    int length, j, argc = 0;
    char *term="xterm", *all_srcs;
    int status;
    tree_details_t *tree_details = get_tree_details(treeview);
    pid_t pid;


    if ( getenv("TERMCMD") && strlen( getenv("TERMCMD"))){
	    gchar *c=g_find_program_in_path(getenv("TERMCMD"));
	    if (c && access(c,X_OK)==0){
	      term = getenv("TERMCMD");
	    }
	    g_free(c);
	    c=NULL;
    }
	      
    if(!term || strlen(term) == 0)
	term = "xterm";
    argv[argc++] = term;
    if(strcmp(term, "xterm") == 0)
    {
	argv[argc++] = "+mesg";
	argv[argc++] = "-aw";
	argv[argc++] = "+cm";
	argv[argc++] = "+dc";
	if (getenv("XFFM_HOLD_XTERM") && strlen( getenv("XFFM_HOLD_XTERM")))
	       	argv[argc++] = "-hold";
	argv[argc++] = "-j";
	argv[argc++] = "-rightbar";
	argv[argc++] = "-s";
	argv[argc++] = "-sb";
	argv[argc++] = "-u8";
	argv[argc++] = "-wf";
	argv[argc++] = "-sl";
	argv[argc++] = "1024";
    }
    argv[argc++] = "-e";
    argv[argc++] = "/bin/sh";
    argv[argc++] = "-c";

    /* checks */
    {
       gchar *test,*prog1,*prog2;
       if(tree_details->preferences & RSH_X_SSH) prog1="rsh";
       else prog1="ssh";
       if(!(tree_details->preferences & RSYNC_X_SCP))prog2="rsync";
       else {
	       if(tree_details->preferences & RSH_X_SSH) prog2="rcp";
	       else prog2="scp";
       }
       test=g_find_program_in_path(prog1);
       if (!test) {
           print_diagnostics("xfce/error",
			  strerror(ENOENT),":", prog1,"\n", NULL);
	   return FALSE;
       } else {
	       g_free(test);
	       test=NULL;
       }
       test=g_find_program_in_path(prog2);
       if (!test) {
           print_diagnostics("xfce/error",
			  strerror(ENOENT),":", prog2,"\n", NULL);
	   return FALSE;
       } else {
	      g_free(test);
	      test=NULL;
       }
    }
       
	       
    if(!(tree_details->preferences & RSYNC_X_SCP))
    {
	if(tree_details->preferences & RSH_X_SSH)
	{
	    c = "rsync -av --rsh=rsh";
	}
	else
	{
	    c = "rsync -av --rsh=ssh";
	}
    }
    else
    {
	if(tree_details->preferences & RSH_X_SSH)
	{
	    c = "rcp -pr";
	}
	else
	    c = "scp -pr";
    }

    cursor_wait();
    pid = fork();
    if(pid)
    {
	do
	{
	    while(gtk_events_pending())
		gtk_main_iteration();
	}
	while(!waitpid(pid, &status, WNOHANG));
	cursor_reset();
	return TRUE;
    }
    
    /* child process continues here... */
    for(j = 0, length = 0; srcs[j]; j++)
    {
	/*printf("DBG:src=%s\n",srcs[j]); */
	length += (strlen(src_host) + 1 + strlen(srcs[j]) + 1);
    }
    all_srcs = (char *)malloc(length + 1);
    if(!all_srcs)
	assert_not_reached();
    all_srcs[0] = 0;
    for(j = 0; srcs[j]; j++)
    {
	strcat(all_srcs, src_host);
	strcat(all_srcs, ":");
	strcat(all_srcs, srcs[j]);
	strcat(all_srcs, " ");
    }

    cmd = (char *)malloc(strlen("echo ;") + 1 + 2 * strlen(c) + 2 + 2 * strlen(tgt) + 2 + 2 * length + 2);

    if(!cmd)
	assert_not_reached();
    sprintf(cmd, "echo %s %s %s;%s %s %s", c, all_srcs, tgt, c, all_srcs, tgt);
    /*printf("DBG:cmd=%s\n",cmd);*/
    argv[argc++] = cmd;

    argv[argc++] = 0;

    /*{int i;printf("DBG:");for(i=0;argv[i];i++)printf("%s ",argv[i]);printf("\n");} */


    execvp(argv[0], argv);
    _exit(123);
}
#endif


