/* (c) 2001-2004 Edscott Wilson Garcia GNU/GPL
 */

/*  functions to use tubo.c for listing contents of SMB shares 
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 *  
 ****** SMBlist */
#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif
#ifdef USE_SMB_BRANCH
#include <unistd.h>
#include <stdarg.h>
#include <signal.h>
#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include <time.h>
#include <sys/stat.h>
#include <sys/types.h>
#include <errno.h>
#include <gdk/gdkkeysyms.h>
#include <gtk/gtk.h>

#include "glade_support.h"

#include "constants.h"
#include "types.h"

#include "basic_row.h"

#include "smb_list.h"

#include "entry.h"
#include "icons.h"
#include "smblookup.h"
#include "smb_open.h"
#include "smb_misc.h"
#include "misc.h"
#include "tubo.h"
#include "password_dialog.h"

int query_result;
extern unsigned net_root_type;
extern GtkTreeView *smb_treeview;
extern char *challenges[];
extern char *smb_errors[];
extern void *smb_object;

static GList *listing=NULL;
static int input_over;
/* These variables *must* be thread safe (hence, use of _POSIX_PATH_MAX): */
static  char smb_server[_POSIX_PATH_MAX];
static  char smb_share[_POSIX_PATH_MAX];
static  char smb_dir[_POSIX_PATH_MAX];
static xfdir_t smb_xfdir;
static int smb_count;
static gboolean samba_server;
static gboolean showing_hidden;
enum {
	SHARE_NAME_COLUMN,
	SHARE_SIZE_COLUMN,
	SHARE_DATE_COLUMN,
	SHARE_COLUMNS
};
	

int SMBListStdout (int n, void *data) {
  char *line;
  static char *textos[SHARE_COLUMNS];
  int i, filenamelen;
  char *pw;
  tree_entry_t *en;
  struct tm t;
  mode_t unix_mode=0;
  gboolean netdir=FALSE,nethidden=FALSE,netreadonly=FALSE;
  

  if (n) return TRUE;  /* this would mean binary data */
  line = (char *) data;
  /*printf("DBG1:%s",line);*/
#if 0
/* 
 * NOTICE: output of smbclient ls is already ascii readable
 *         this does not apply to the comment field, though
 *         (now why would they do a
 *         thing like that?) in samba 2.2.x. */
  {
    char *l=g_strdup(line);
    ascii_readable(l);
    print_diagnostics (NULL,l,NULL);
    g_free(l);
  }
#else
    print_diagnostics (NULL,line,NULL);
#endif
  
    
  for (i=0;challenges[i]!=NULL;i++){
      if (strstr (line, challenges[i]))  {
        query_result = CHALLENGED;
      }	
  }
  for (i=0;smb_errors[i]!=NULL;i++){
      if (strstr (line, smb_errors[i]))  {
	  print_diagnostics("xfce/error", strerror(EPERM),NULL);
      }	
  }
  if (strstr (line, "Connection") && strstr (line, "failed"))  {
        query_result = FAILED;	  
  	  return TRUE;
  }
  if (input_over){
  	/*printf("DBG   input is over\n");*/
	return TRUE;
  }
  if (strstr(line,"Server=") && strstr(line,"Samba")) samba_server=TRUE;
  if (strlen (line) <= 2){
	input_over=1;
	/*printf("DBG   input now over\n");*/
  	return TRUE;
  }
  if (strstr (line, "  .   "))	return TRUE;
  if (strstr (line, "  ..   "))	return TRUE;
  if (strlen(line) < 1+25+2+8) return TRUE;
  if (strncmp (line, "  ", 2) != 0)  return TRUE;
  
  /* ok. Now we have a line to process
   * This is a line to watch, if smbclient changes the format
   * for output in file client.c, this must be taken into account */
  /* client.c: "  %-30s%7.7s %8.0f  %s",filename,attr,size,asctime */
  /* asctime=25 */
  /* if (strlen(line) > 25+2+8+1+7) */

  /*printf("DBG2:%s",line);*/

 
  pw = line + (strlen (line) - 1 - 25 - 2 - 8);
  while (pw[0] != ' ') {
    if (pw == line) break;
    pw--;
  }

  filenamelen = strlen (line) - strlen (pw) - 7;

  while (pw[0] == ' ') {
    if (pw[0] == 0) break;
    pw++;
  }


  /*filenamelen = strlen (line) - 25 - 2 - 8 - 1 - 7; */
  for (i = 0; i < SHARE_COLUMNS; i++) textos[i] = "";
  textos[SHARE_NAME_COLUMN] = line + 2;
  
/*  Why would this be set to filenamelen + 1? It seems a mistake,
 *  and rafael.tinoco@sun.com found that it did not work.
 *  So after cutting out the 1, it all seems to work fine.
 *  for (i = filenamelen + 1; i < filenamelen + 8; i++)  {*/
  for (i = filenamelen; i < filenamelen + 8; i++)  {
    if (line[i] == 'D') netdir=TRUE;
    if (line[i] == 'H') nethidden=TRUE;
    if (line[i] == 'R') netreadonly=TRUE;
    line[i] = 0;
  }
  /* mode for windows files: */
  unix_mode = S_IRUSR;
  /* this is the archive bit (set almost everywhere) */
  unix_mode |= S_IXUSR;
  if (netdir) unix_mode |= S_IFDIR;
  else  unix_mode |= S_IFREG;
  if (!netreadonly) unix_mode |= S_IWUSR;
  if(!showing_hidden && nethidden) return TRUE;
  if(samba_server && !showing_hidden && textos[SHARE_NAME_COLUMN][0]=='.')
	  return TRUE;
  
  en=mk_entry(net_root_type);
  if (samba_server) SET_SAMBA_SERVER(en->subtype);
  if (netdir) SET_NETDIR(en->subtype); 
  if (!IS_NETDIR(en->subtype)) SET_NETFILE(en->subtype);
  if (nethidden) SET_NETHIDDEN(en->subtype);
  if (netreadonly) SET_NETREADONLY(en->subtype);

#if 0
  if (strstr (pw, "\n"))  strtok (pw, "\n"); /* chop */
#endif
  
  if (strstr (pw, " ")) {
    textos[SHARE_SIZE_COLUMN] = strtok (pw, " ");
    textos[SHARE_DATE_COLUMN] = pw + strlen (pw) + 1;
  }
  {
    gchar *g,*tt=g_strdup(textos[SHARE_DATE_COLUMN]);
    /*printf("DBG:%s\n",tt);*/
    g=strtok(tt," "); /* day of week */
    g=strtok(NULL," "); /* month */
    if (strcmp(g,"Jan")==0) t.tm_mon=0;
    else if (strcmp(g,"Feb")==0) t.tm_mon=1;
    else if (strcmp(g,"Mar")==0) t.tm_mon=2;
    else if (strcmp(g,"Apr")==0) t.tm_mon=3;
    else if (strcmp(g,"May")==0) t.tm_mon=4;
    else if (strcmp(g,"Jun")==0) t.tm_mon=5;
    else if (strcmp(g,"Jul")==0) t.tm_mon=6;
    else if (strcmp(g,"Aug")==0) t.tm_mon=7;
    else if (strcmp(g,"Sep")==0) t.tm_mon=8;
    else if (strcmp(g,"Oct")==0) t.tm_mon=9;
    else if (strcmp(g,"Nov")==0) t.tm_mon=10;
    else if (strcmp(g,"Dec")==0) t.tm_mon=11;
    g=strtok(NULL," "); /* day of month */
    t.tm_mday=atoi(g);
    g=strtok(NULL,":"); /* hour */
    t.tm_hour=atoi(g);
    g=strtok(NULL,":"); /* minute */
    t.tm_min=atoi(g);
    g=strtok(NULL," "); /* second */
    t.tm_sec=atoi(g);
    g=strtok(NULL,"\n"); /* year */
    t.tm_year=atoi(g)-1900;
    g_free(tt);tt=NULL;
  }
  
  {
     char *t;
     t=textos[SHARE_NAME_COLUMN];
     while (strlen(t) && (t[strlen(t)-1]==' '||t[strlen(t)-1]=='\t'))
	     t[strlen(t)-1]=0;
  }
  

  
  en->path=(char *)malloc(strlen(smb_server)+1+
		  strlen(smb_share)+1+
		  strlen(smb_dir)+1+
		  strlen(textos[SHARE_NAME_COLUMN])+1);
  
  if (!strlen(smb_dir))  sprintf(en->path,"%s/%s/%s",
		  smb_server,smb_share,textos[SHARE_NAME_COLUMN]);
  else sprintf(en->path,"%s/%s/%s/%s",
		  smb_server,smb_share,smb_dir,textos[SHARE_NAME_COLUMN]);
  /* path should always be in ascii unreadable format for windows servers 
   * this is definitely screwy, but it's windows...*/
  if (!samba_server) ascii_unreadable (en->path);
  
  en->st=(struct stat *)malloc(sizeof(struct stat));
  en->st->st_size=atoi(textos[SHARE_SIZE_COLUMN]);

  en->st->st_mtime=mktime(&t);
  en->st->st_gid = (gid_t)-1;
  en->st->st_uid = (uid_t)-1;
  en->st->st_mode=unix_mode;

  
  /*printf("DBG:adding %s \n",en->path);*/
  listing = g_list_append (listing,(gpointer)en);
  
  return TRUE;
}

/* function to be run by parent after child has exited
*  and all data in pipe has been read : */
static void SMBListForkOver (pid_t pid){
  switch (query_result)
  {
  case CHALLENGED:
    print_status ("xfce/warning",
		    _("Query password has been requested"),
		    NULL);
    break;
  case FAILED:
    print_status ("xfce/error",
		    _("SMB query failed"),
		    NULL);
  default:

    print_status ("xfce/info",
		    _("Retrieve done"),
		    NULL);
    break;

  }
  smb_object=NULL;
}

static void
printout_listing(gpointer data,gpointer user_data){
  char *pass=(char *)user_data;
  tree_entry_t *en=(tree_entry_t *)data;
  
  if (!strrchr(en->path,'/')) assert_not_reached();
  smb_xfdir.gl[smb_count].pathv=g_strdup(strrchr(en->path,'/')+1);
  if (!samba_server) ascii_readable(smb_xfdir.gl[smb_count].pathv);
  en->tag=g_strdup(pass);
  smb_xfdir.gl[smb_count].en=en;
  smb_count++;
}

void add_smb_stuff(GtkTreeView *treeview,GtkTreeIter *iter,char *pass){
	
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  if (query_result==SUCCESS && listing){
        smb_xfdir.pathc = g_list_length(listing);
        smb_xfdir.gl = (dir_t *) malloc(smb_xfdir.pathc * sizeof(dir_t));
	smb_count=0;
	g_list_foreach(listing,printout_listing,(gpointer)pass);
	add_contents_row(treemodel, iter, &smb_xfdir);
	erase_dummy_row(treemodel, iter,NULL);
        hide_stop();
	xfdirfree(&smb_xfdir);
  } else if (query_result==SUCCESS && !listing){
    	tree_entry_t *en;
    	gtk_tree_model_get(GTK_TREE_MODEL(treemodel), iter, ENTRY_COLUMN, &en, -1);
	SET_EXPANDED(en->type);
	set_icon(treemodel, iter);
	reset_dummy_row(treemodel, iter,NULL,en,NULL,NULL);
  } else {
	reset_dummy_row(treemodel, iter,NULL,NULL,NULL,NULL);
  }
}

void init_smb_list(GtkTreeView *treeview,char *path,gboolean show_hidden){
  char *s,*t;
  smb_treeview=treeview;
  samba_server=FALSE;
  s=g_strdup(path);
  strtok(s+2,"/");
  snprintf(smb_server,_POSIX_PATH_MAX-1, "%s",s);
  smb_server[_POSIX_PATH_MAX-1]=0;
  t=s+strlen(s)+1;
  showing_hidden=show_hidden;
  if (strchr(t,'/')){
	t=strtok(NULL,"/");
	snprintf(smb_dir,_POSIX_PATH_MAX-1,"%s",t+strlen(t)+1);
	smb_dir[_POSIX_PATH_MAX-1]=0;
  } else {
	smb_dir[0]=0;
  }
  snprintf(smb_share,_POSIX_PATH_MAX-1, "%s",t);
  smb_share[_POSIX_PATH_MAX-1]=0;
  g_free(s);s=NULL;
  input_over=0;
  query_result=SUCCESS; 
  if (listing){
      	g_list_free(listing);
	listing=NULL;
  }
}

int
SMBList (GtkTreeView *treeview,char *path,GtkTreeIter *iter,
		char *pass,gboolean show_hidden)
{
  char *argument[7];
  char NMBcommand[_POSIX_PATH_MAX];
  char NMBshare[_POSIX_PATH_MAX];
  int i;
  GtkTreeModel *treemodel = gtk_tree_view_get_model(treeview);
  if (!path || !strchr(path,'/')) return FALSE;
  init_smb_list(treeview,path,show_hidden);
  
  if (pass) g_strstrip(pass);
  
 
  snprintf(NMBshare,_POSIX_PATH_MAX-1, "%s/%s",smb_server,smb_share);
  NMBshare[_POSIX_PATH_MAX-1]=0;
 
  if (strlen(smb_dir)){
     snprintf (NMBcommand,_POSIX_PATH_MAX-1, "ls \\\"%s\\\"/*", smb_dir);
     NMBcommand[_POSIX_PATH_MAX-1]=0;
  } else sprintf (NMBcommand, "ls /*");



  i=0;
  argument[i++]="smbclient";
  argument[i++]=NMBshare;
  argument[i++]="-U";
  if (pass && strlen(pass)) {
    argument[i++]=pass;
  }
  else {
    argument[i++]="GUEST%%";
  }
  argument[i++]="-c";
  argument[i++]=NMBcommand;
  argument[i++]=0;
  
  print_status (NULL,_("Retrieving..."),NULL);
  print_diagnostics ("nonverbose","XFSAMBA> ",
		  "smbclient"," ",NMBshare," ",
#ifdef DEBUG
		  "-U"," ",pass," ",
#endif
		  "-c", " ",NMBcommand,"\n",
		  NULL);

  reset_dummy_row(treemodel,iter,NULL,NULL,"xfce/warning",_("Loading..."));
  smb_object = Tubo (fork_function,
	(void *)argument, 
	SMBListForkOver, 
	NULL, 
	SMBListStdout, 
	smb_stderr,0,FALSE);
  
  smb_wait(TRUE);

  add_smb_stuff(treeview,iter,pass);
  
 	  
  return query_result;
}

#endif

