/*
 * Decompiled with CFR 0.152.
 */
package gnu.javax.rmi;

import java.rmi.NoSuchObjectException;
import java.rmi.Remote;
import java.rmi.RemoteException;
import java.rmi.server.RemoteStub;
import java.rmi.server.UnicastRemoteObject;
import java.util.Hashtable;
import javax.rmi.CORBA.ObjectImpl;
import javax.rmi.CORBA.Stub;
import javax.rmi.CORBA.Tie;
import javax.rmi.CORBA.Util;

public class PortableServer {
    private static Hashtable tieCache = new Hashtable();
    private static Object NO_TIE = new Object();

    public static final synchronized void exportObject(Remote obj) throws RemoteException {
        if (Util.getTie(obj) != null) {
            return;
        }
        Tie tie = PortableServer.getTieFromRemote(obj);
        if (tie != null) {
            Util.registerTarget(tie, obj);
        } else {
            UnicastRemoteObject.exportObject(obj);
        }
    }

    public static final void unexportObject(Remote obj) {
        if (Util.getTie(obj) != null) {
            Util.unexportObject(obj);
        }
        if (tieCache.get(obj) != null) {
            tieCache.remove(obj);
        }
    }

    public static final Remote toStub(Remote obj) throws NoSuchObjectException {
        if (obj instanceof Stub || obj instanceof RemoteStub) {
            return obj;
        }
        Tie tie = Util.getTie(obj);
        if (tie == null) {
            throw new NoSuchObjectException("Can't toStub an unexported object");
        }
        Remote stub = PortableServer.getStubFromTie(tie);
        return stub;
    }

    static synchronized Tie getTieFromRemote(Remote obj) {
        Object tie = tieCache.get(obj);
        if (tie == null) {
            tie = PortableServer.getTieFromClass(obj.getClass());
            if (tie == null) {
                tieCache.put(obj, NO_TIE);
            } else {
                tieCache.put(obj, tie);
            }
        } else if (tie != NO_TIE) {
            try {
                tie = obj.getClass().newInstance();
            }
            catch (Exception _) {
                tie = null;
            }
        } else {
            tie = null;
        }
        return (Tie)tie;
    }

    static synchronized Tie getTieFromClass(Class clz) {
        return null;
    }

    public static Remote getStubFromTie(Tie tie) {
        return null;
    }

    public static Remote getStubFromObjectImpl(ObjectImpl objimpl, Class toClass) {
        return null;
    }
}

