/*
 * Decompiled with CFR 0.152.
 */
package java.io;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class LineNumberReader
extends BufferedReader {
    private int lineNumber;
    private boolean matchedNewLine;
    private int savedLineNumber;

    public LineNumberReader(Reader in) {
        super(in, 8192);
    }

    public LineNumberReader(Reader in, int size) {
        super(in, size);
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        this.lineNumber = lineNumber;
    }

    public void mark(int readLimit) throws IOException {
        if (readLimit < 0) {
            throw new IllegalArgumentException("Read-ahead limit is negative");
        }
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.pos + readLimit > this.limit) {
                    int saveCR = this.matchedNewLine ? 1 : 0;
                    char[] old_buffer = this.buffer;
                    if (readLimit > this.limit) {
                        this.buffer = new char[saveCR + readLimit];
                    }
                    int copy_start = this.pos - saveCR;
                    this.savedLineNumber = this.lineNumber;
                    this.limit -= copy_start;
                    System.arraycopy(old_buffer, copy_start, this.buffer, 0, this.limit);
                    this.pos = saveCR;
                }
                this.markPos = this.pos;
            }
            finally {
                Object var3_4 = null;
            }
            return;
        }
    }

    public void reset() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                if (this.markPos < 0) {
                    throw new IOException("mark never set or invalidated");
                }
                this.lineNumber = this.savedLineNumber;
                this.pos = this.markPos;
                this.matchedNewLine = this.markPos > 0 && this.buffer[this.markPos - 1] == '\r';
            }
            finally {
                Object var2_2 = null;
            }
            return;
        }
    }

    private int fill() throws IOException {
        int count;
        if (this.markPos >= 0 && this.limit == this.buffer.length) {
            this.markPos = -1;
        }
        if (this.markPos < 0) {
            this.limit = 0;
            this.pos = 0;
        }
        if ((count = this.in.read(this.buffer, this.limit, this.buffer.length - this.limit)) <= 0) {
            return -1;
        }
        this.limit += count;
        return count;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int read() throws IOException {
        Object object = this.lock;
        synchronized (object) {
            try {
                char ch;
                this.skipRedundantLF();
                if (this.pos >= this.limit && this.fill() < 0) {
                    return -1;
                }
                if ((this.matchedNewLine = (ch = this.buffer[this.pos++]) == '\r') || ch == '\n') {
                    ++this.lineNumber;
                    return 10;
                }
                this.matchedNewLine = false;
                return ch;
            }
            catch (Throwable throwable) {
                Object var4_8 = null;
                throw throwable;
            }
        }
    }

    public int read(char[] buf, int offset, int count) throws IOException {
        if (buf == null) {
            throw new NullPointerException();
        }
        if (offset + count > buf.length || offset < 0) {
            throw new IndexOutOfBoundsException();
        }
        if (count <= 0) {
            if (count < 0) {
                throw new IndexOutOfBoundsException();
            }
            return 0;
        }
        Object object = this.lock;
        synchronized (object) {
            int n;
            try {
                if (this.pos >= this.limit && this.fill() < 0) {
                    int n2 = -1;
                    Object var8_7 = null;
                    return n2;
                }
                int start_offset = offset;
                boolean matched = this.matchedNewLine;
                while (count-- > 0 && this.pos < this.limit) {
                    char ch;
                    if ((ch = this.buffer[this.pos++]) == '\r') {
                        ++this.lineNumber;
                        matched = true;
                    } else if (ch == '\n' && !matched) {
                        ++this.lineNumber;
                    } else {
                        matched = false;
                    }
                    buf[offset++] = ch;
                }
                this.matchedNewLine = matched;
                n = offset - start_offset;
            }
            catch (Throwable throwable) {
                Object var8_10 = null;
                throw throwable;
            }
            Object var8_9 = null;
            return n;
        }
    }

    private void skipRedundantLF() throws IOException {
        if (this.pos > 0 && this.matchedNewLine) {
            if (this.pos < this.limit) {
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            } else {
                if (this.fill() <= 0) {
                    return;
                }
                if (this.buffer[this.pos] == '\n') {
                    ++this.pos;
                }
            }
            this.matchedNewLine = true;
        }
    }

    public String readLine() throws IOException {
        int tmpLineNumber = this.lineNumber;
        this.skipRedundantLF();
        String str = super.readLine();
        if (this.pos > this.limit) {
            --this.pos;
        }
        if (str != null) {
            this.lineNumber = tmpLineNumber + 1;
        }
        return str;
    }

    public long skip(long count) throws IOException {
        int ch;
        if (count < 0L) {
            throw new IllegalArgumentException("skip() value is negative");
        }
        if (count == 0L) {
            return 0L;
        }
        char[] buf = new char[1];
        int skipped = 0;
        while ((long)skipped < count && (ch = this.read(buf, 0, 1)) >= 0) {
            ++skipped;
        }
        return skipped;
    }
}

