/*
 * Decompiled with CFR 0.152.
 */
package java.nio;

import java.nio.ByteOrder;
import java.nio.FloatBuffer;
import java.nio.ReadOnlyBufferException;

final class FloatBufferImpl
extends FloatBuffer {
    private boolean readOnly;

    FloatBufferImpl(int capacity) {
        this(new float[capacity], 0, capacity, capacity, 0, -1, false);
    }

    FloatBufferImpl(float[] buffer, int offset, int capacity, int limit, int position, int mark, boolean readOnly) {
        super(buffer, offset, capacity, limit, position, mark);
        this.readOnly = readOnly;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public FloatBuffer slice() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset + this.position(), this.remaining(), this.remaining(), 0, -1, this.isReadOnly());
    }

    public FloatBuffer duplicate() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, this.isReadOnly());
    }

    public FloatBuffer asReadOnlyBuffer() {
        return new FloatBufferImpl(this.backing_buffer, this.array_offset, this.capacity(), this.limit(), this.position(), this.mark, true);
    }

    public FloatBuffer compact() {
        int copied = 0;
        while (this.remaining() > 0) {
            this.put(copied, this.get());
            ++copied;
        }
        this.position(copied);
        return this;
    }

    public boolean isDirect() {
        return false;
    }

    public final float get() {
        float result = this.backing_buffer[this.position()];
        this.position(this.position() + 1);
        return result;
    }

    public final FloatBuffer put(float value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[this.position()] = value;
        this.position(this.position() + 1);
        return this;
    }

    public final float get(int index) {
        return this.backing_buffer[index];
    }

    public final FloatBuffer put(int index, float value) {
        if (this.readOnly) {
            throw new ReadOnlyBufferException();
        }
        this.backing_buffer[index] = value;
        return this;
    }

    public final ByteOrder order() {
        return ByteOrder.nativeOrder();
    }
}

