/*
 * Decompiled with CFR 0.152.
 */
package java.security;

import java.security.BasicPermission;
import java.security.Permission;
import java.security.PermissionCollection;
import java.util.Enumeration;
import java.util.Hashtable;

final class BasicPermissionCollection
extends PermissionCollection {
    private static final long serialVersionUID = 739301742472979399L;
    private final Hashtable permissions;
    private boolean all_allowed;
    private final Class permClass;

    private /* synthetic */ void finit$() {
        this.permissions = new Hashtable();
    }

    BasicPermissionCollection(Class c) {
        this.finit$();
        this.permClass = c;
    }

    public void add(Permission perm) {
        if (this.isReadOnly()) {
            throw new SecurityException("readonly");
        }
        if (!this.permClass.isInstance(perm)) {
            throw new IllegalArgumentException("Expecting instance of " + this.permClass);
        }
        BasicPermission bp = (BasicPermission)perm;
        String name = bp.getName();
        if (name.equals("*")) {
            this.all_allowed = true;
        }
        this.permissions.put(name, bp);
    }

    public boolean implies(Permission permission) {
        if (!this.permClass.isInstance(permission)) {
            return false;
        }
        if (this.all_allowed) {
            return true;
        }
        BasicPermission toImply = (BasicPermission)permission;
        String name = toImply.getName();
        if (name.equals("*")) {
            return false;
        }
        int prefixLength = name.length();
        if (name.endsWith("*")) {
            prefixLength -= 2;
        }
        while (this.permissions.get(name) == null) {
            if ((prefixLength = name.lastIndexOf(46, prefixLength)) < 0) {
                return false;
            }
            name = name.substring(0, prefixLength + 1) + '*';
        }
        return true;
    }

    public Enumeration elements() {
        return this.permissions.elements();
    }
}

