/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Random;
import java.util.RandomAccess;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;

public class Collections {
    private static final int LARGE_LIST_SIZE = 16;
    public static final Set EMPTY_SET = new EmptySet();
    public static final List EMPTY_LIST = new EmptyList();
    public static final Map EMPTY_MAP = new EmptyMap();
    private static final ReverseComparator rcInstance = new ReverseComparator();
    private static Random defaultRandom = null;

    private static boolean isSequential(List l) {
        return l instanceof RandomAccess ^ true && l.size() > 16;
    }

    private Collections() {
    }

    static final int compare(Object o1, Object o2, Comparator c) {
        if (c == null) {
            return ((Comparable)o1).compareTo(o2);
        }
        return c.compare(o1, o2);
    }

    public static int binarySearch(List l, Object key) {
        return Collections.binarySearch(l, key, null);
    }

    public static int binarySearch(List l, Object key, Comparator c) {
        int pos = 0;
        int low = 0;
        int hi = l.size() - 1;
        if (Collections.isSequential(l)) {
            ListIterator itr = l.listIterator();
            int i = 0;
            while (low <= hi) {
                int d;
                pos = low + hi >> 1;
                if (i < pos) {
                    while (i != pos) {
                        ++i;
                        itr.next();
                    }
                } else {
                    while (i != pos) {
                        --i;
                        itr.previous();
                    }
                }
                if ((d = Collections.compare(key, itr.next(), c)) == 0) {
                    return pos;
                }
                if (d < 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
            }
        } else {
            while (low <= hi) {
                pos = low + hi >> 1;
                int d = Collections.compare(key, l.get(pos), c);
                if (d == 0) {
                    return pos;
                }
                if (d < 0) {
                    hi = pos - 1;
                    continue;
                }
                low = ++pos;
            }
        }
        return -pos - 1;
    }

    public static void copy(List dest, List source) {
        int pos = source.size();
        if (dest.size() < pos) {
            throw new IndexOutOfBoundsException("Source does not fit in dest");
        }
        Iterator i1 = source.iterator();
        ListIterator i2 = dest.listIterator();
        while (--pos >= 0) {
            i2.next();
            i2.set(i1.next());
        }
    }

    public static Enumeration enumeration(Collection c) {
        Iterator i = c.iterator();
        return new Enumeration(null, i){
            private /* synthetic */ Collections this$0;
            private /* synthetic */ Iterator val$i;
            {
                this.this$0 = this$0;
                this.finit$(parm$i);
            }

            private /* synthetic */ void finit$(Iterator parm$i) {
                this.val$i = parm$i;
            }

            public final boolean hasMoreElements() {
                return this.val$i.hasNext();
            }

            public final Object nextElement() {
                return this.val$i.next();
            }
        };
    }

    public static void fill(List l, Object val) {
        ListIterator itr = l.listIterator();
        for (int i = l.size() - 1; i >= 0; --i) {
            itr.next();
            itr.set(val);
        }
    }

    public static int indexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = 0;
        for (int j = target.size(); j <= ssize; ++j) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static int lastIndexOfSubList(List source, List target) {
        int ssize = source.size();
        int i = ssize - target.size();
        int j = ssize;
        while (i >= 0) {
            if (source.subList(i, j).equals(target)) {
                return i;
            }
            --i;
            --j;
        }
        return -1;
    }

    public static ArrayList list(Enumeration e) {
        ArrayList l = new ArrayList();
        while (e.hasMoreElements()) {
            l.add(e.nextElement());
        }
        return l;
    }

    public static Object max(Collection c) {
        return Collections.max(c, null);
    }

    public static Object max(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object max = itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (Collections.compare(max, o, order) >= 0) continue;
            max = o;
        }
        return max;
    }

    public static Object min(Collection c) {
        return Collections.min(c, null);
    }

    public static Object min(Collection c, Comparator order) {
        Iterator itr = c.iterator();
        Object min = itr.next();
        int csize = c.size();
        for (int i = 1; i < csize; ++i) {
            Object o = itr.next();
            if (Collections.compare(min, o, order) <= 0) continue;
            min = o;
        }
        return min;
    }

    public static List nCopies(int n, Object o) {
        return new CopiesList(n, o);
    }

    public static boolean replaceAll(List list, Object oldval, Object newval) {
        ListIterator itr = list.listIterator();
        boolean replace_occured = false;
        int i = list.size();
        while (--i >= 0) {
            if (!AbstractCollection.equals(oldval, itr.next())) continue;
            itr.set(newval);
            replace_occured = true;
        }
        return replace_occured;
    }

    public static void reverse(List l) {
        int pos2;
        ListIterator i1 = l.listIterator();
        int pos1 = 1;
        ListIterator i2 = l.listIterator(pos2);
        for (pos2 = l.size(); pos1 < pos2; ++pos1, --pos2) {
            Object o = i1.next();
            i1.set(i2.previous());
            i2.set(o);
        }
    }

    public static Comparator reverseOrder() {
        return rcInstance;
    }

    public static void rotate(List list, int distance) {
        int size = list.size();
        if ((distance %= size) == 0) {
            return;
        }
        if (distance < 0) {
            distance += size;
        }
        if (Collections.isSequential(list)) {
            Collections.reverse(list);
            Collections.reverse(list.subList(0, distance));
            Collections.reverse(list.subList(distance, size));
        } else {
            int a = size;
            int lcm = distance;
            int b = a % lcm;
            while (b != 0) {
                a = lcm;
                lcm = b;
                b = a % lcm;
            }
            while (--lcm >= 0) {
                Object o = list.get(lcm);
                int i = lcm + distance;
                while (i != lcm) {
                    o = list.set(i, o);
                    i = (i + distance) % size;
                }
                list.set(lcm, o);
            }
        }
    }

    public static void shuffle(List l) {
        if (defaultRandom == null) {
            Class clazz = Collections.class$("java.util.Collections");
            synchronized (clazz) {
                block4: {
                    try {
                        if (defaultRandom != null) break block4;
                        defaultRandom = new Random();
                    }
                    catch (Throwable throwable) {
                        Object var2_3 = null;
                        throw throwable;
                    }
                }
                Object var2_2 = null;
            }
        }
        Collections.shuffle(l, defaultRandom);
    }

    static /* synthetic */ Class class$(String type$) throws NoClassDefFoundError {
        try {
            return Class.forName(type$);
        }
        catch (ClassNotFoundException write_parm_value$) {
            throw new NoClassDefFoundError(write_parm_value$.getMessage());
        }
    }

    public static void shuffle(List l, Random r) {
        int lsize = l.size();
        ListIterator i = l.listIterator(lsize);
        boolean sequential = Collections.isSequential(l);
        Object[] a = null;
        if (sequential) {
            a = l.toArray();
        }
        for (int pos = lsize - 1; pos > 0; --pos) {
            Object o;
            int swap = r.nextInt(pos + 1);
            if (sequential) {
                o = a[swap];
                a[swap] = i.previous();
            } else {
                o = l.set(swap, i.previous());
            }
            i.set(o);
        }
    }

    public static Set singleton(Object o) {
        return new SingletonSet(o);
    }

    public static List singletonList(Object o) {
        return new SingletonList(o);
    }

    public static Map singletonMap(Object key, Object value) {
        return new SingletonMap(key, value);
    }

    public static void sort(List l) {
        Collections.sort(l, null);
    }

    public static void sort(List l, Comparator c) {
        Object[] a = l.toArray();
        Arrays.sort(a, c);
        ListIterator i = l.listIterator(a.length);
        int pos = a.length;
        while (--pos >= 0) {
            i.previous();
            i.set(a[pos]);
        }
    }

    public static void swap(List l, int i, int j) {
        l.set(i, l.set(j, l.get(i)));
    }

    public static Collection synchronizedCollection(Collection c) {
        return new SynchronizedCollection(c);
    }

    public static List synchronizedList(List l) {
        if (l instanceof RandomAccess) {
            return new SynchronizedRandomAccessList(l);
        }
        return new SynchronizedList(l);
    }

    public static Map synchronizedMap(Map m) {
        return new SynchronizedMap(m);
    }

    public static Set synchronizedSet(Set s) {
        return new SynchronizedSet(s);
    }

    public static SortedMap synchronizedSortedMap(SortedMap m) {
        return new SynchronizedSortedMap(m);
    }

    public static SortedSet synchronizedSortedSet(SortedSet s) {
        return new SynchronizedSortedSet(s);
    }

    public static Collection unmodifiableCollection(Collection c) {
        return new UnmodifiableCollection(c);
    }

    public static List unmodifiableList(List l) {
        if (l instanceof RandomAccess) {
            return new UnmodifiableRandomAccessList(l);
        }
        return new UnmodifiableList(l);
    }

    public static Map unmodifiableMap(Map m) {
        return new UnmodifiableMap(m);
    }

    public static Set unmodifiableSet(Set s) {
        return new UnmodifiableSet(s);
    }

    public static SortedMap unmodifiableSortedMap(SortedMap m) {
        return new UnmodifiableSortedMap(m);
    }

    public static SortedSet unmodifiableSortedSet(SortedSet s) {
        return new UnmodifiableSortedSet(s);
    }

    private static class UnmodifiableSortedSet
    extends UnmodifiableSet
    implements SortedSet {
        private static final long serialVersionUID = -4929149591599911165L;
        private SortedSet ss;

        UnmodifiableSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        public Comparator comparator() {
            return this.ss.comparator();
        }

        public Object first() {
            return this.ss.first();
        }

        public SortedSet headSet(Object toElement) {
            return new UnmodifiableSortedSet(this.ss.headSet(toElement));
        }

        public Object last() {
            return this.ss.last();
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            return new UnmodifiableSortedSet(this.ss.subSet(fromElement, toElement));
        }

        public SortedSet tailSet(Object fromElement) {
            return new UnmodifiableSortedSet(this.ss.tailSet(fromElement));
        }
    }

    private static class UnmodifiableSortedMap
    extends UnmodifiableMap
    implements SortedMap {
        private static final long serialVersionUID = -8806743815996713206L;
        private final SortedMap sm;

        UnmodifiableSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        public Comparator comparator() {
            return this.sm.comparator();
        }

        public Object firstKey() {
            return this.sm.firstKey();
        }

        public SortedMap headMap(Object toKey) {
            return new UnmodifiableSortedMap(this.sm.headMap(toKey));
        }

        public Object lastKey() {
            return this.sm.lastKey();
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            return new UnmodifiableSortedMap(this.sm.subMap(fromKey, toKey));
        }

        public SortedMap tailMap(Object fromKey) {
            return new UnmodifiableSortedMap(this.sm.tailMap(fromKey));
        }
    }

    private static class UnmodifiableSet
    extends UnmodifiableCollection
    implements Set {
        private static final long serialVersionUID = -9215047833775013803L;

        UnmodifiableSet(Set s) {
            super(s);
        }

        public boolean equals(Object o) {
            return this.c.equals(o);
        }

        public int hashCode() {
            return this.c.hashCode();
        }
    }

    private static class UnmodifiableMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = -1034234728574286014L;
        private final Map m;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        UnmodifiableMap(Map m) {
            this.m = m;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean containsKey(Object key) {
            return this.m.containsKey(key);
        }

        public boolean containsValue(Object value) {
            return this.m.containsValue(value);
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = new UnmodifiableEntrySet(this.m.entrySet());
            }
            return this.entries;
        }

        public boolean equals(Object o) {
            return this.m.equals(o);
        }

        public Object get(Object key) {
            return this.m.get(key);
        }

        public Object put(Object key, Object value) {
            throw new UnsupportedOperationException();
        }

        public int hashCode() {
            return this.m.hashCode();
        }

        public boolean isEmpty() {
            return this.m.isEmpty();
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = new UnmodifiableSet(this.m.keySet());
            }
            return this.keys;
        }

        public void putAll(Map m) {
            throw new UnsupportedOperationException();
        }

        public Object remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.m.size();
        }

        public String toString() {
            return this.m.toString();
        }

        public Collection values() {
            if (this.values == null) {
                this.values = new UnmodifiableCollection(this.m.values());
            }
            return this.values;
        }

        private static final class UnmodifiableEntrySet
        extends UnmodifiableSet
        implements Serializable {
            private static final long serialVersionUID = 7854390611657943733L;

            UnmodifiableEntrySet(Set s) {
                super(s);
            }

            public Iterator iterator() {
                return new UnmodifiableIterator(this, this.c.iterator()){
                    private /* synthetic */ UnmodifiableEntrySet this$2;
                    {
                        this.this$2 = this$2;
                        super(parm0);
                    }

                    public Object next() {
                        Map.Entry e = (Map.Entry)super.next();
                        return new Map.Entry(this, e){
                            private /* synthetic */ 7 this$3;
                            private /* synthetic */ Map.Entry val$e;
                            {
                                this.this$3 = this$3;
                                this.finit$(parm$e);
                            }

                            private /* synthetic */ void finit$(Map.Entry parm$e) {
                                this.val$e = parm$e;
                            }

                            public boolean equals(Object o) {
                                return this.val$e.equals(o);
                            }

                            public Object getKey() {
                                return this.val$e.getKey();
                            }

                            public Object getValue() {
                                return this.val$e.getValue();
                            }

                            public int hashCode() {
                                return this.val$e.hashCode();
                            }

                            public Object setValue(Object value) {
                                throw new UnsupportedOperationException();
                            }

                            public String toString() {
                                return this.val$e.toString();
                            }
                        };
                    }
                };
            }
        }
    }

    private static final class UnmodifiableListIterator
    extends UnmodifiableIterator
    implements ListIterator {
        private final ListIterator li;

        UnmodifiableListIterator(ListIterator li) {
            super(li);
            this.li = li;
        }

        public void add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean hasPrevious() {
            return this.li.hasPrevious();
        }

        public int nextIndex() {
            return this.li.nextIndex();
        }

        public Object previous() {
            return this.li.previous();
        }

        public int previousIndex() {
            return this.li.previousIndex();
        }

        public void set(Object o) {
            throw new UnsupportedOperationException();
        }
    }

    private static final class UnmodifiableRandomAccessList
    extends UnmodifiableList
    implements RandomAccess {
        private static final long serialVersionUID = -2542308836966382001L;

        UnmodifiableRandomAccessList(List l) {
            super(l);
        }
    }

    private static class UnmodifiableList
    extends UnmodifiableCollection
    implements List {
        private static final long serialVersionUID = -283967356065247728L;
        final List list;

        UnmodifiableList(List l) {
            super(l);
            this.list = l;
        }

        public void add(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean equals(Object o) {
            return this.list.equals(o);
        }

        public Object get(int index) {
            return this.list.get(index);
        }

        public int hashCode() {
            return this.list.hashCode();
        }

        public int indexOf(Object o) {
            return this.list.indexOf(o);
        }

        public int lastIndexOf(Object o) {
            return this.list.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return new UnmodifiableListIterator(this.list.listIterator());
        }

        public ListIterator listIterator(int index) {
            return new UnmodifiableListIterator(this.list.listIterator(index));
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        public Object set(int index, Object o) {
            throw new UnsupportedOperationException();
        }

        public List subList(int fromIndex, int toIndex) {
            return Collections.unmodifiableList(this.list.subList(fromIndex, toIndex));
        }
    }

    private static class UnmodifiableIterator
    implements Iterator {
        private final Iterator i;

        UnmodifiableIterator(Iterator i) {
            this.i = i;
        }

        public Object next() {
            return this.i.next();
        }

        public boolean hasNext() {
            return this.i.hasNext();
        }

        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private static class UnmodifiableCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 1820017752578914078L;
        final Collection c;

        UnmodifiableCollection(Collection c) {
            this.c = c;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean contains(Object o) {
            return this.c.contains(o);
        }

        public boolean containsAll(Collection c1) {
            return this.c.containsAll(c1);
        }

        public boolean isEmpty() {
            return this.c.isEmpty();
        }

        public Iterator iterator() {
            return new UnmodifiableIterator(this.c.iterator());
        }

        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        public boolean removeAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public boolean retainAll(Collection c) {
            throw new UnsupportedOperationException();
        }

        public int size() {
            return this.c.size();
        }

        public Object[] toArray() {
            return this.c.toArray();
        }

        public Object[] toArray(Object[] a) {
            return this.c.toArray(a);
        }

        public String toString() {
            return this.c.toString();
        }
    }

    private static final class SynchronizedSortedSet
    extends SynchronizedSet
    implements SortedSet {
        private static final long serialVersionUID = 8695801310862127406L;
        private final SortedSet ss;

        SynchronizedSortedSet(SortedSet ss) {
            super(ss);
            this.ss = ss;
        }

        SynchronizedSortedSet(Object sync, SortedSet ss) {
            super(sync, ss);
            this.ss = ss;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Comparator comparator = this.ss.comparator();
                    Object var3_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object first() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.ss.first();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet headSet(Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.headSet(toElement));
                    Object var4_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object last() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.ss.last();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet subSet(Object fromElement, Object toElement) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.subSet(fromElement, toElement));
                    Object var5_5 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public SortedSet tailSet(Object fromElement) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedSet synchronizedSortedSet = new SynchronizedSortedSet(this.mutex, this.ss.tailSet(fromElement));
                    Object var4_4 = null;
                    return synchronizedSortedSet;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
    }

    private static final class SynchronizedSortedMap
    extends SynchronizedMap
    implements SortedMap {
        private static final long serialVersionUID = -8798146769416483793L;
        private final SortedMap sm;

        SynchronizedSortedMap(SortedMap sm) {
            super(sm);
            this.sm = sm;
        }

        SynchronizedSortedMap(Object sync, SortedMap sm) {
            super(sync, sm);
            this.sm = sm;
        }

        public Comparator comparator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Comparator comparator = this.sm.comparator();
                    Object var3_3 = null;
                    return comparator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object firstKey() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.sm.firstKey();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap headMap(Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.headMap(toKey));
                    Object var4_4 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object lastKey() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.sm.lastKey();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap subMap(Object fromKey, Object toKey) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.subMap(fromKey, toKey));
                    Object var5_5 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public SortedMap tailMap(Object fromKey) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedSortedMap synchronizedSortedMap = new SynchronizedSortedMap(this.mutex, this.sm.tailMap(fromKey));
                    Object var4_4 = null;
                    return synchronizedSortedMap;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedSet
    extends SynchronizedCollection
    implements Set {
        private static final long serialVersionUID = 487447009682186044L;

        SynchronizedSet(Set s) {
            super(s);
        }

        SynchronizedSet(Object sync, Set s) {
            super(sync, s);
        }

        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.equals(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.c.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }
    }

    private static class SynchronizedMap
    implements Map,
    Serializable {
        private static final long serialVersionUID = 1978198479659022715L;
        private final Map m;
        final Object mutex;
        private transient Set entries;
        private transient Set keys;
        private transient Collection values;

        SynchronizedMap(Map m) {
            this.m = m;
            this.mutex = this;
            if (m == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedMap(Object sync, Map m) {
            this.m = m;
            this.mutex = sync;
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.m.clear();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }

        public boolean containsKey(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.m.containsKey(key);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsValue(Object value) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.m.containsValue(value);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set entrySet() {
            if (this.entries != null) return this.entries;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.entries = new SynchronizedSet(this, this.mutex, this.m.entrySet()){
                        private /* synthetic */ SynchronizedMap this$1;
                        {
                            this.this$1 = this$1;
                            super(parm0, parm1);
                        }

                        static SynchronizedMap access$0(5 inst$) {
                            return inst$.this$1;
                        }

                        public Iterator iterator() {
                            Object object = this.mutex;
                            synchronized (object) {
                                try {
                                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this, this.mutex, this.c.iterator()){
                                        private /* synthetic */ 5 this$2;
                                        {
                                            this.this$2 = this$2;
                                            super(parm0, parm1);
                                        }

                                        public Object next() {
                                            Object object = this.mutex;
                                            synchronized (object) {
                                                try {
                                                    4.SynchronizedMapEntry synchronizedMapEntry = new 4.SynchronizedMapEntry(5.access$0(this.this$2), super.next());
                                                    Object var3_3 = null;
                                                    return synchronizedMapEntry;
                                                }
                                                catch (Throwable throwable) {
                                                    Object var3_4 = null;
                                                    throw throwable;
                                                }
                                            }
                                        }
                                    };
                                    Object var3_3 = null;
                                    return synchronizedIterator;
                                }
                                catch (Throwable throwable) {
                                    Object var3_4 = null;
                                    throw throwable;
                                }
                            }
                        }
                    };
                    return this.entries;
                }
                finally {
                    Set set = null;
                }
            }
        }

        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.m.equals(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(Object key) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.m.get(key);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.m.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.m.isEmpty();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Set keySet() {
            if (this.keys != null) return this.keys;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.keys = new SynchronizedSet(this.mutex, this.m.keySet());
                    return this.keys;
                }
                finally {
                    Set set = null;
                }
            }
        }

        public Object put(Object key, Object value) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.m.put(key, value);
                    Object var5_5 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public void putAll(Map map) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.m.putAll(map);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public Object remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.m.remove(o);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.m.size();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    String string = this.m.toString();
                    Object var3_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public Collection values() {
            if (this.values != null) return this.values;
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.values = new SynchronizedCollection(this.mutex, this.m.values());
                    return this.values;
                }
                finally {
                    Collection collection = null;
                }
            }
        }
    }

    private static final class SynchronizedListIterator
    extends SynchronizedIterator
    implements ListIterator {
        private final ListIterator li;

        SynchronizedListIterator(Object sync, ListIterator li) {
            super(sync, li);
            this.li = li;
        }

        public void add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.li.add(o);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }

        public boolean hasPrevious() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.li.hasPrevious();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int nextIndex() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.li.nextIndex();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object previous() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.li.previous();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int previousIndex() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.li.previousIndex();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public void set(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.li.set(o);
                }
                finally {
                    Object var3_3 = null;
                }
                return;
            }
        }
    }

    private static final class SynchronizedRandomAccessList
    extends SynchronizedList
    implements RandomAccess {
        private static final long serialVersionUID = 1530674583602358482L;

        SynchronizedRandomAccessList(List l) {
            super(l);
        }

        SynchronizedRandomAccessList(Object sync, List l) {
            super(sync, l);
        }

        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedRandomAccessList synchronizedRandomAccessList = new SynchronizedRandomAccessList(this.mutex, this.list.subList(fromIndex, toIndex));
                    Object var5_5 = null;
                    return synchronizedRandomAccessList;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
    }

    static class SynchronizedList
    extends SynchronizedCollection
    implements List {
        private static final long serialVersionUID = -7754090372962971524L;
        final List list;

        SynchronizedList(List l) {
            super(l);
            this.list = l;
        }

        SynchronizedList(Object sync, List l) {
            super(sync, l);
            this.list = l;
        }

        public void add(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.list.add(index, o);
                }
                finally {
                    Object var4_4 = null;
                }
                return;
            }
        }

        public boolean addAll(int index, Collection c) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.list.addAll(index, c);
                    Object var5_5 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public boolean equals(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.list.equals(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object get(int index) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.list.get(index);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int hashCode() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.list.hashCode();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public int indexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.list.indexOf(o);
                    Object var4_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int lastIndexOf(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.list.lastIndexOf(o);
                    Object var4_4 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.mutex, this.list.listIterator());
                    Object var3_3 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public ListIterator listIterator(int index) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedListIterator synchronizedListIterator = new SynchronizedListIterator(this.mutex, this.list.listIterator(index));
                    Object var4_4 = null;
                    return synchronizedListIterator;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object remove(int index) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.list.remove(index);
                    Object var4_4 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public Object set(int index, Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.list.set(index, o);
                    Object var5_5 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }

        public List subList(int fromIndex, int toIndex) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedList synchronizedList = new SynchronizedList(this.mutex, this.list.subList(fromIndex, toIndex));
                    Object var5_5 = null;
                    return synchronizedList;
                }
                catch (Throwable throwable) {
                    Object var5_6 = null;
                    throw throwable;
                }
            }
        }
    }

    private static class SynchronizedIterator
    implements Iterator {
        final Object mutex;
        private final Iterator i;

        SynchronizedIterator(Object sync, Iterator i) {
            this.i = i;
            this.mutex = sync;
        }

        public Object next() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object object2 = this.i.next();
                    Object var3_3 = null;
                    return object2;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean hasNext() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.i.hasNext();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public void remove() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.i.remove();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }
    }

    static class SynchronizedCollection
    implements Collection,
    Serializable {
        private static final long serialVersionUID = 3053995032091335093L;
        final Collection c;
        final Object mutex;

        SynchronizedCollection(Collection c) {
            this.c = c;
            this.mutex = this;
            if (c == null) {
                throw new NullPointerException();
            }
        }

        SynchronizedCollection(Object sync, Collection c) {
            this.c = c;
            this.mutex = sync;
        }

        public boolean add(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.add(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean addAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.addAll(col);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public void clear() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    this.c.clear();
                }
                finally {
                    Object var2_2 = null;
                }
                return;
            }
        }

        public boolean contains(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.contains(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean containsAll(Collection c1) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.containsAll(c1);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean isEmpty() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.isEmpty();
                    Object var3_3 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Iterator iterator() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    SynchronizedIterator synchronizedIterator = new SynchronizedIterator(this.mutex, this.c.iterator());
                    Object var3_3 = null;
                    return synchronizedIterator;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public boolean remove(Object o) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.remove(o);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean removeAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.removeAll(col);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public boolean retainAll(Collection col) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    boolean bl = this.c.retainAll(col);
                    Object var4_4 = null;
                    return bl;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public int size() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    int n = this.c.size();
                    Object var3_3 = null;
                    return n;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray();
                    Object var3_3 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }

        public Object[] toArray(Object[] a) {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    Object[] objectArray = this.c.toArray(a);
                    Object var4_4 = null;
                    return objectArray;
                }
                catch (Throwable throwable) {
                    Object var4_5 = null;
                    throw throwable;
                }
            }
        }

        public String toString() {
            Object object = this.mutex;
            synchronized (object) {
                try {
                    String string = this.c.toString();
                    Object var3_3 = null;
                    return string;
                }
                catch (Throwable throwable) {
                    Object var3_4 = null;
                    throw throwable;
                }
            }
        }
    }

    private static final class SingletonMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = -6979724477215052911L;
        private final Object k;
        private final Object v;
        private transient Set entries;

        SingletonMap(Object key, Object value) {
            this.k = key;
            this.v = value;
        }

        public Set entrySet() {
            if (this.entries == null) {
                this.entries = Collections.singleton(new AbstractMap.BasicMapEntry(this, this.k, this.v){
                    private /* synthetic */ SingletonMap this$1;
                    {
                        this.this$1 = this$1;
                        super(parm0, parm1);
                    }

                    public Object setValue(Object o) {
                        throw new UnsupportedOperationException();
                    }
                });
            }
            return this.entries;
        }

        public boolean containsKey(Object key) {
            return AbstractMap.equals(key, this.k);
        }

        public boolean containsValue(Object value) {
            return AbstractMap.equals(value, this.v);
        }

        public Object get(Object key) {
            if (AbstractMap.equals(key, this.k)) {
                return this.v;
            }
            return null;
        }

        public int hashCode() {
            return AbstractMap.hashCode(this.k) ^ AbstractMap.hashCode(this.v);
        }

        public Set keySet() {
            if (this.keys == null) {
                this.keys = Collections.singleton(this.k);
            }
            return this.keys;
        }

        public int size() {
            return 1;
        }

        public Collection values() {
            if (this.values == null) {
                this.values = Collections.singleton(this.v);
            }
            return this.values;
        }

        public String toString() {
            return "{" + this.k + "=" + this.v + "}";
        }
    }

    private static final class SingletonList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 3093736618740652951L;
        private final Object element;

        SingletonList(Object o) {
            this.element = o;
        }

        public int size() {
            return 1;
        }

        public Object get(int index) {
            if (index == 0) {
                return this.element;
            }
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object o) {
            return AbstractCollection.equals(o, this.element);
        }

        public boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (AbstractCollection.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return 31 + AbstractCollection.hashCode(this.element);
        }

        public int indexOf(Object o) {
            if (AbstractCollection.equals(o, this.element)) {
                return 0;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (AbstractCollection.equals(o, this.element)) {
                return 0;
            }
            return -1;
        }

        public List subList(int from, int to) {
            if (from == to && (to == 0 || to == 1)) {
                return EMPTY_LIST;
            }
            if (from == 0 && to == 1) {
                return this;
            }
            if (from > to) {
                throw new IllegalArgumentException();
            }
            throw new IndexOutOfBoundsException();
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class SingletonSet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 3193687207550431679L;
        final Object element;

        SingletonSet(Object o) {
            this.element = o;
        }

        public int size() {
            return 1;
        }

        public Iterator iterator() {
            return new Iterator(this){
                private /* synthetic */ SingletonSet this$1;
                private boolean hasNext;
                {
                    this.this$1 = this$1;
                    this.finit$();
                }

                private /* synthetic */ void finit$() {
                    this.hasNext = true;
                }

                public boolean hasNext() {
                    return this.hasNext;
                }

                public Object next() {
                    if (this.hasNext) {
                        this.hasNext = false;
                        return this.this$1.element;
                    }
                    throw new NoSuchElementException();
                }

                public void remove() {
                    throw new UnsupportedOperationException();
                }
            };
        }

        public boolean contains(Object o) {
            return AbstractCollection.equals(o, this.element);
        }

        public boolean containsAll(Collection c) {
            Iterator i = c.iterator();
            int pos = c.size();
            while (--pos >= 0) {
                if (AbstractCollection.equals(i.next(), this.element)) continue;
                return false;
            }
            return true;
        }

        public int hashCode() {
            return AbstractCollection.hashCode(this.element);
        }

        public Object[] toArray() {
            return new Object[]{this.element};
        }

        public String toString() {
            return "[" + this.element + "]";
        }
    }

    private static final class ReverseComparator
    implements Comparator,
    Serializable {
        private static final long serialVersionUID = 7207038068494060240L;

        ReverseComparator() {
        }

        public int compare(Object a, Object b) {
            return ((Comparable)b).compareTo(a);
        }
    }

    private static final class CopiesList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 2739099268398711800L;
        private final int n;
        private final Object element;

        CopiesList(int n, Object o) {
            if (n < 0) {
                throw new IllegalArgumentException();
            }
            this.n = n;
            this.element = o;
        }

        public int size() {
            return this.n;
        }

        public Object get(int index) {
            if (index < 0 || index >= this.n) {
                throw new IndexOutOfBoundsException();
            }
            return this.element;
        }

        public boolean contains(Object o) {
            return this.n > 0 && AbstractCollection.equals(o, this.element);
        }

        public int indexOf(Object o) {
            if (this.n > 0 && AbstractCollection.equals(o, this.element)) {
                return 0;
            }
            return -1;
        }

        public int lastIndexOf(Object o) {
            if (AbstractCollection.equals(o, this.element)) {
                return this.n - 1;
            }
            return -1;
        }

        public List subList(int from, int to) {
            if (from < 0 || to > this.n) {
                throw new IndexOutOfBoundsException();
            }
            return new CopiesList(to - from, this.element);
        }

        public Object[] toArray() {
            Object[] a = new Object[this.n];
            Arrays.fill(a, this.element);
            return a;
        }

        public String toString() {
            StringBuffer r = new StringBuffer("{");
            int i = this.n - 1;
            while (--i > 0) {
                r.append(this.element).append(", ");
            }
            r.append(this.element).append("}");
            return r.toString();
        }
    }

    private static final class EmptyMap
    extends AbstractMap
    implements Serializable {
        private static final long serialVersionUID = 6428348081105594320L;

        EmptyMap() {
        }

        public Set entrySet() {
            return EMPTY_SET;
        }

        public boolean containsKey(Object key) {
            return false;
        }

        public boolean containsValue(Object value) {
            return false;
        }

        public boolean equals(Object o) {
            return o instanceof Map && ((Map)o).isEmpty();
        }

        public Object get(Object o) {
            return null;
        }

        public int hashCode() {
            return 0;
        }

        public Set keySet() {
            return EMPTY_SET;
        }

        public Object remove(Object o) {
            return null;
        }

        public int size() {
            return 0;
        }

        public Collection values() {
            return EMPTY_SET;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptyList
    extends AbstractList
    implements Serializable,
    RandomAccess {
        private static final long serialVersionUID = 8842843931221139166L;

        EmptyList() {
        }

        public int size() {
            return 0;
        }

        public Object get(int index) {
            throw new IndexOutOfBoundsException();
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        public boolean equals(Object o) {
            return o instanceof List && ((List)o).isEmpty();
        }

        public int hashCode() {
            return 1;
        }

        public int indexOf(Object o) {
            return -1;
        }

        public int lastIndexOf(Object o) {
            return -1;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean removeAll(Collection c) {
            return false;
        }

        public boolean retainAll(Collection c) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        public String toString() {
            return "[]";
        }
    }

    private static final class EmptySet
    extends AbstractSet
    implements Serializable {
        private static final long serialVersionUID = 1582296315990362920L;

        EmptySet() {
        }

        public int size() {
            return 0;
        }

        public Iterator iterator() {
            return EMPTY_LIST.iterator();
        }

        public boolean contains(Object o) {
            return false;
        }

        public boolean containsAll(Collection c) {
            return c.isEmpty();
        }

        public boolean equals(Object o) {
            return o instanceof Set && ((Set)o).isEmpty();
        }

        public int hashCode() {
            return 0;
        }

        public boolean remove(Object o) {
            return false;
        }

        public boolean removeAll(Collection c) {
            return false;
        }

        public boolean retainAll(Collection c) {
            return false;
        }

        public Object[] toArray() {
            return new Object[0];
        }

        public Object[] toArray(Object[] a) {
            if (a.length > 0) {
                a[0] = null;
            }
            return a;
        }

        public String toString() {
            return "[]";
        }
    }
}

