/*
 * Decompiled with CFR 0.152.
 */
package java.util;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.ConcurrentModificationException;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;

public class Hashtable
extends Dictionary
implements Map,
Cloneable,
Serializable {
    private static final int DEFAULT_CAPACITY = 11;
    static final int KEYS = 0;
    static final int VALUES = 1;
    static final int ENTRIES = 2;
    private static final float DEFAULT_LOAD_FACTOR = 0.75f;
    private static final long serialVersionUID = 1421746759512286392L;
    private int threshold;
    private final float loadFactor;
    transient HashEntry[] buckets;
    transient int modCount;
    transient int size;
    private transient Set keys;
    private transient Collection values;
    private transient Set entries;

    public Hashtable() {
        this(11, 0.75f);
    }

    public Hashtable(Map m) {
        this(Math.max(m.size() * 2, 11), 0.75f);
        this.putAll(m);
    }

    public Hashtable(int initialCapacity) {
        this(initialCapacity, 0.75f);
    }

    public Hashtable(int initialCapacity, float loadFactor) {
        if (initialCapacity < 0) {
            throw new IllegalArgumentException("Illegal Capacity: " + initialCapacity);
        }
        if (!(loadFactor > 0.0f)) {
            throw new IllegalArgumentException("Illegal Load: " + loadFactor);
        }
        if (initialCapacity == 0) {
            initialCapacity = 1;
        }
        this.buckets = new HashEntry[initialCapacity];
        this.loadFactor = loadFactor;
        this.threshold = (int)((float)initialCapacity * loadFactor);
    }

    public synchronized int size() {
        return this.size;
    }

    public synchronized boolean isEmpty() {
        return this.size == 0;
    }

    public Enumeration keys() {
        return new Enumerator(this, 0);
    }

    public Enumeration elements() {
        return new Enumerator(this, 1);
    }

    public synchronized boolean contains(Object value) {
        for (int i = this.buckets.length - 1; i >= 0; --i) {
            HashEntry e = this.buckets[i];
            while (e != null) {
                if (value.equals(e.value)) {
                    return true;
                }
                e = e.next;
            }
        }
        if (value == null) {
            throw new NullPointerException();
        }
        return false;
    }

    public boolean containsValue(Object value) {
        return this.contains(value);
    }

    public synchronized boolean containsKey(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (key.equals(e.key)) {
                return true;
            }
            e = e.next;
        }
        return false;
    }

    public synchronized Object get(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (key.equals(e.key)) {
                return e.value;
            }
            e = e.next;
        }
        return null;
    }

    public synchronized Object put(Object key, Object value) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        if (value == null) {
            throw new NullPointerException();
        }
        while (e != null) {
            if (key.equals(e.key)) {
                Object r = e.value;
                e.value = value;
                return r;
            }
            e = e.next;
        }
        ++this.modCount;
        if (++this.size > this.threshold) {
            this.rehash();
            idx = this.hash(key);
        }
        e = new HashEntry(key, value);
        e.next = this.buckets[idx];
        this.buckets[idx] = e;
        return null;
    }

    public synchronized Object remove(Object key) {
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        HashEntry last = null;
        while (e != null) {
            if (key.equals(e.key)) {
                ++this.modCount;
                if (last == null) {
                    this.buckets[idx] = e.next;
                } else {
                    last.next = e.next;
                }
                --this.size;
                return e.value;
            }
            last = e;
            e = e.next;
        }
        return null;
    }

    public synchronized void putAll(Map m) {
        Iterator itr = m.entrySet().iterator();
        while (itr.hasNext()) {
            Map.Entry e = (Map.Entry)itr.next();
            if (e instanceof AbstractMap.BasicMapEntry) {
                AbstractMap.BasicMapEntry entry = (AbstractMap.BasicMapEntry)e;
                this.put(entry.key, entry.value);
                continue;
            }
            this.put(e.getKey(), e.getValue());
        }
    }

    public synchronized void clear() {
        if (this.size > 0) {
            ++this.modCount;
            Arrays.fill(this.buckets, null);
            this.size = 0;
        }
    }

    public synchronized Object clone() {
        Hashtable copy = null;
        try {
            copy = (Hashtable)super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        copy.buckets = new HashEntry[this.buckets.length];
        copy.putAllInternal(this);
        copy.keys = null;
        copy.values = null;
        copy.entries = null;
        return copy;
    }

    public synchronized String toString() {
        HashIterator entries = new HashIterator(this, 2);
        StringBuffer r = new StringBuffer("{");
        for (int pos = this.size; pos > 0; --pos) {
            r.append(entries.next());
            if (pos <= 1) continue;
            r.append(", ");
        }
        r.append("}");
        return r.toString();
    }

    public Set keySet() {
        if (this.keys == null) {
            AbstractSet r = new AbstractSet(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 0);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    if (o == null) {
                        return false;
                    }
                    return this.this$0.containsKey(o);
                }

                public boolean remove(Object o) {
                    return this.this$0.remove(o) != null;
                }
            };
            this.keys = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.keys;
    }

    public Collection values() {
        if (this.values == null) {
            AbstractCollection r = new AbstractCollection(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 1);
                }

                public void clear() {
                    this.this$0.clear();
                }
            };
            this.values = new Collections.SynchronizedCollection(this, r);
        }
        return this.values;
    }

    public Set entrySet() {
        if (this.entries == null) {
            AbstractSet r = new AbstractSet(this){
                private /* synthetic */ Hashtable this$0;
                {
                    this.this$0 = this$0;
                }

                public int size() {
                    return this.this$0.size;
                }

                public Iterator iterator() {
                    return new HashIterator(this.this$0, 2);
                }

                public void clear() {
                    this.this$0.clear();
                }

                public boolean contains(Object o) {
                    return this.this$0.getEntry(o) != null;
                }

                public boolean remove(Object o) {
                    HashEntry e = this.this$0.getEntry(o);
                    if (e != null) {
                        this.this$0.remove(e.key);
                        return true;
                    }
                    return false;
                }
            };
            this.entries = new Collections.SynchronizedSet((Object)this, r);
        }
        return this.entries;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        return this.entrySet().equals(((Map)o).entrySet());
    }

    public synchronized int hashCode() {
        HashIterator itr = new HashIterator(this, 2);
        int hashcode = 0;
        for (int pos = this.size; pos > 0; --pos) {
            hashcode += itr.next().hashCode();
        }
        return hashcode;
    }

    private int hash(Object key) {
        int hash = key.hashCode() % this.buckets.length;
        if (hash < 0) {
            return -hash;
        }
        return hash;
    }

    HashEntry getEntry(Object o) {
        if (!(o instanceof Map.Entry)) {
            return null;
        }
        Object key = ((Map.Entry)o).getKey();
        if (key == null) {
            return null;
        }
        int idx = this.hash(key);
        HashEntry e = this.buckets[idx];
        while (e != null) {
            if (o.equals(e)) {
                return e;
            }
            e = e.next;
        }
        return null;
    }

    void putAllInternal(Map m) {
        Iterator itr = m.entrySet().iterator();
        this.size = 0;
        while (itr.hasNext()) {
            ++this.size;
            Map.Entry e = (Map.Entry)itr.next();
            Object key = e.getKey();
            int idx = this.hash(key);
            HashEntry he = new HashEntry(key, e.getValue());
            he.next = this.buckets[idx];
            this.buckets[idx] = he;
        }
    }

    protected void rehash() {
        HashEntry[] oldBuckets = this.buckets;
        int newcapacity = this.buckets.length * 2 + 1;
        this.threshold = (int)((float)newcapacity * this.loadFactor);
        this.buckets = new HashEntry[newcapacity];
        for (int i = oldBuckets.length - 1; i >= 0; --i) {
            HashEntry e = oldBuckets[i];
            while (e != null) {
                int idx = this.hash(e.key);
                HashEntry dest = this.buckets[idx];
                if (dest != null) {
                    while (dest.next != null) {
                        dest = dest.next;
                    }
                    dest.next = e;
                } else {
                    this.buckets[idx] = e;
                }
                HashEntry next = e.next;
                e.next = null;
                e = next;
            }
        }
    }

    private synchronized void writeObject(ObjectOutputStream s) throws IOException {
        s.defaultWriteObject();
        s.writeInt(this.buckets.length);
        s.writeInt(this.size);
        HashIterator it = new HashIterator(this, 2);
        while (it.hasNext()) {
            HashEntry entry = (HashEntry)it.next();
            s.writeObject(entry.key);
            s.writeObject(entry.value);
        }
    }

    private void readObject(ObjectInputStream s) throws IOException, ClassNotFoundException {
        s.defaultReadObject();
        this.buckets = new HashEntry[s.readInt()];
        int len = s.readInt();
        while (--len >= 0) {
            this.put(s.readObject(), s.readObject());
        }
    }

    private final class Enumerator
    implements Enumeration {
        private /* synthetic */ Hashtable this$0;
        final int type;
        int count;
        int idx;
        HashEntry next;

        private /* synthetic */ void finit$() {
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        Enumerator(Hashtable this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
        }

        public boolean hasMoreElements() {
            return this.count > 0;
        }

        public Object nextElement() {
            if (this.count == 0) {
                throw new NoSuchElementException("Hashtable Enumerator");
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = this.this$0.buckets[--this.idx];
            }
            this.next = e.next;
            if (this.type == 1) {
                return e.value;
            }
            return e.key;
        }
    }

    private final class HashIterator
    implements Iterator {
        private /* synthetic */ Hashtable this$0;
        final int type;
        int knownMod;
        int count;
        int idx;
        HashEntry last;
        HashEntry next;

        private /* synthetic */ void finit$() {
            this.knownMod = this.this$0.modCount;
            this.count = this.this$0.size;
            this.idx = this.this$0.buckets.length;
        }

        HashIterator(Hashtable this$0, int type) {
            this.this$0 = this$0;
            this.finit$();
            this.type = type;
        }

        public boolean hasNext() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            return this.count > 0;
        }

        public Object next() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.count == 0) {
                throw new NoSuchElementException();
            }
            --this.count;
            HashEntry e = this.next;
            while (e == null) {
                e = this.this$0.buckets[--this.idx];
            }
            this.next = e.next;
            this.last = e;
            if (this.type == 1) {
                return e.value;
            }
            if (this.type == 0) {
                return e.key;
            }
            return e;
        }

        public void remove() {
            if (this.knownMod != this.this$0.modCount) {
                throw new ConcurrentModificationException();
            }
            if (this.last == null) {
                throw new IllegalStateException();
            }
            this.this$0.remove(this.last.key);
            this.last = null;
            ++this.knownMod;
        }
    }

    private static final class HashEntry
    extends AbstractMap.BasicMapEntry {
        HashEntry next;

        HashEntry(Object key, Object value) {
            super(key, value);
        }

        public Object setValue(Object newVal) {
            if (newVal == null) {
                throw new NullPointerException();
            }
            return super.setValue(newVal);
        }
    }
}

