Name: brltty
Version: 3.10
Release: 1

Group: System Environment/Daemons
License: GPL
Vendor: The BRLTTY Team
Packager: Dave Mielke <dave@mielke.cc>
URL: http://mielke.cc/brltty/
Source: http://mielke.cc/brltty/releases/%{name}-%{version}.tar.gz

BuildRequires: autoconf >= 2.53
BuildRequires: make
BuildRequires: gcc
BuildRequires: /bin/sh
BuildRequires: /bin/ln
BuildRequires: /usr/bin/ld
BuildRequires: /sbin/ldconfig
BuildRequires: /usr/bin/ranlib
BuildRequires: /usr/bin/ar
BuildRequires: /usr/bin/awk
BuildRequires: /usr/bin/bison
BuildRequires: /usr/bin/install
BuildRequires: glibc-devel
BuildRequires: Pyrex
BuildRequires: tcl
BuildRequires: gcc-java

BuildRoot: %{_tmppath}/%{name}-%{version}-InstallRoot
%define _bindir /bin
%define _sbindir /sbin
%define _libdir /lib
%define _sysconfdir /etc

AutoProv: 1

AutoReq: 1
Requires: /bin/sh

Summary: Braille display driver for Linux/Unix.
%description
BRLTTY is a background process (daemon) which provides access to
the console screen (when in text mode) for a blind person using a
refreshable braille display.  It drives the braille display, and
provides complete screen review functionality.  Some speech capability
has also been incorporated.

Install this package if you use a refreshable braille display.

%package -n brlapi
Version: 0.5.2
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Appliation Programming Interface for BRLTTY.
%description -n brlapi
This package provides the run-time support for the Application
Programming Interface to BRLTTY.

Install this package if you have an application
which directly accesses a refreshable braille display.

%package -n brlapi-caml
Version: 0.5.2
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Caml bindings for BrlAPI.
%description -n brlapi-caml
This package provides the Caml bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Caml application
which directly accesses a refreshable braille display.

%package -n brlapi-java
Version: 0.5.2
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Java bindings for BrlAPI.
%description -n brlapi-java
This package provides the Java bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Java application
which directly accesses a refreshable braille display.

%package -n brlapi-python
Version: 0.5.2
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Python bindings for BrlAPI.
%description -n brlapi-python
This package provides the Python bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Python application
which directly accesses a refreshable braille display.

%package -n brlapi-tcl
Version: 0.5.2
Group: Applications/System
License: LGPL

AutoProv: 1

AutoReq: 1

Summary: Tcl bindings for BrlAPI.
%description -n brlapi-tcl
This package provides the Tcl bindings for BrlAPI,
which is the Application Programming Interface to BRLTTY.

Install this package if you have a Tcl application
which directly accesses a refreshable braille display.

%package -n brlapi-devel
Version: 0.5.2
Group: Development/System
License: LGPL

AutoProv: 1

AutoReq: 1
Requires: brlapi = 0.5.2

Summary: Headers, static archive, and documentation for BrlAPI.
%description -n brlapi-devel
This package provides the header files, static archive, shared object
linker reference, and reference documentation for BrlAPI (the
Application Programming Interface to BRLTTY).  It enables the
implementation of applications which take direct advantage of a
refreshable braille display in order to present information in ways
which are more appropriate for blind users and/or to provide user
interfaces which are more specifically atuned to their needs.

Install this package if you're developing or maintaining an application
which directly accesses a refreshable braille display.

%prep
# %setup -n %{name}-%{version}
%setup -n brltty-3.10

%build
%configure --disable-relocatable-install --with-install-root="${RPM_BUILD_ROOT}" --disable-gpm --without-flite --without-mikropuhe --without-swift --without-theta --without-viavoice --without-libbraille --without-curses --without-x --with-braille-driver=-tt
make

directory="doc"
mkdir -p "${directory}"
for file in `find . \( -path "./${directory}" -o -path ./Documents \) -prune -o \( -name 'README*' -o -name '*.patch' -o -name '*.txt' -o -name '*.html' -o -name '*.sgml' -o \( -path "./Bootdisks/*" -type f -perm +ugo=x \) \) -print`
do
   mkdir -p "${directory}/${file%/*}"
   cp -rp "${file}" "${directory}/${file}"
done

%install
make install
install -m 644 Documents/brltty.conf "${RPM_BUILD_ROOT}%{_sysconfdir}"

%clean
rm -fr "${RPM_BUILD_ROOT}"

%files
%defattr(-,root,root)
%{_bindir}/brltty
%{_bindir}/brltty-*
%{_bindir}/vstp
%{_libdir}/brltty
%{_sysconfdir}/brltty
%doc %{_mandir}/man1/*
%doc Documents/Manual-BRLTTY/English/*.{sgml,txt,html}
%doc COPYING
%doc Documents/ChangeLog Documents/TODO
%doc doc/*
%config(noreplace) %verify(not size md5 mtime) %{_sysconfdir}/brltty.conf

%files -n brlapi
%defattr(-,root,root)
%{_libdir}/libbrlapi.so.*
%{_bindir}/xbrlapi
%doc Documents/Manual-BrlAPI/English/*.{sgml,txt,html}
%doc Documents/README.Gnopernicus

%files -n brlapi-caml
/usr/lib/ocaml/brlapi

%files -n brlapi-java
/usr/share/java/*
/usr/lib/java/*

%files -n brlapi-python
/usr/lib/python2.5/site-packages/brlapi.*

%files -n brlapi-tcl
/usr/lib/brlapi-0.5.2/libbrlapi_tcl.so
/usr/lib/brlapi-0.5.2/pkgIndex.tcl

%files -n brlapi-devel
%defattr(-,root,root)
%{_libdir}/libbrlapi.a
%{_libdir}/libbrlapi.so
%{_includedir}/brlapi.h
%{_includedir}/brlapi_*.h
%{_includedir}/brltty
%doc %{_mandir}/man3/*
%doc Documents/BrlAPIref

%changelog
* Wed Jul 16 2008 Dave Mielke <dave@mielke.cc> 3.10
+  The core and drivers (excluding text tables) are now Unicode-based.
+  The DESCCHAR function now shows (if possible) the character's name.
+  Linear cuts no longer include newline characters.
+  Specifying the braille device as "serial:" now defaults to the first serial device.
+  Add a driver for the Braille Sense.
+  Bring the French manual fully up-to-date (was at 3.6).
+  Linux-specific changes:
      Don't unnecessarily wake up USB devices when searching.
+  Albatross braille driver changes:
      Correctly handle keys which send their code on both press and release.
+  Baum braille driver changes:
      Bind TL1+TR3 to the BACK funct5ion.
+  EuroBraille braille driver changes:
      Rewritten.
      Add support for the Iris PC keyboard.
      Add key binding to do Shift+Tab directly (dots 235 + space).
      New EsysIris key bindings:
         VK_L34 -> FREEZE
         VK_L67 -> HOME
+  FreedomScientific braille driver changes:
      New PAC Mate key bindings:
         routing key + left wheel press -> SETLEFT
         routing key + right wheel press -> DESCCHAR
+  General speech support changes:
      Add a preference for setting the pitch.
      Add a preference for setting the punctuation level.
+  SpeechDispatcher speech driver changes:
      Change the connection name to "main" (from "driver").
      Single character entry/deletion now always speaks.
      Try to reopen the connection if an error occurs.
      Support setting pitch and punctuation level.
+  Theta speech driver changes:
      It wouldn't compile with newer gccs.
+  Linux screen driver changes:
      Now works on big endian architectures.
      Add support for multi-byte character sets.
      Add the Charset= parameter.
      Add support for the right Alt key (AltGr).
+  PcBios screen driver changes:
      Add AT/XT scancode support.
+  Windows screen driver changes:
      Add the FollowFocus= parameter.
      Add AT/XT scancode support.
+  Text table changes:
      Rename no-h to no-generic.
      Rename no-p to no-oub [Offentlig Utvalg for Blindeskrift].
+  Contraction table changes:
      Unicode characters can be specified by value [\uxxxx].
      Unicode characters can be specified by name [\<name>].
      When the cursor is:
      *  On a word - it is uncontracted (not rendered in computer braille).
      *  Between words - the space is expanded.
      Rename the opcode "repeated" to "repeatable".
      Fixes to the English Grade 2 [en-us-g2] table.
      Fix the UEB [Unified English Braille] percent sign.
      Fixes to the Chinese [zh-...] tables.
      Rename zh-tw-big5 to zh-tw.
      Remove zh-tw-gb2312.
      Remove zh-tw-utf8.
+  BrlAPI changes:
      Now at release 0.5.2.
      Present a blinking cursor if that's what the user has configured.
      Install/uninstall "/var/lib/BrlAPI/".
+  Caml bindings changes:
      Install and uninstall now work properly.
+  Java bindings changes:
      Package the classes into org.a11y.BrlAPI.
      Rename the classes to remove the (now redundant) Brlapi prefix.
+  Python bindings changes:
      Improved error handling facilities.
+  tbltest changes:
      Added the -e [--edit] option for editing a text table.

