/***************************************************************************
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 *   copyright (C) 2003      Brian Thomas <thomas@mail630.gsfc.nasa.gov>   *
 *   copyright (C) 2004-2008                                               *
 *   Umbrello UML Modeller Authors <uml-devel@uml.sf.net>                  *
 ***************************************************************************/

// own header
#include "ownedhierarchicalcodeblock.h"

// local includes
#include "association.h"
#include "umldoc.h"
#include "umlobject.h"
#include "umlrole.h"
#include "codedocument.h"
#include "codegenerator.h"

// kde includes
#include <kdebug.h>

OwnedHierarchicalCodeBlock::OwnedHierarchicalCodeBlock ( UMLObject *parent, CodeDocument * doc, const QString &start, const QString &end, const QString &comment)
        : OwnedCodeBlock(parent), HierarchicalCodeBlock ( doc, start, end, comment)
{
}

OwnedHierarchicalCodeBlock::~OwnedHierarchicalCodeBlock ( )
{
}

void OwnedHierarchicalCodeBlock::release ()
{
    OwnedCodeBlock::release();
    HierarchicalCodeBlock::release();
}

void OwnedHierarchicalCodeBlock::setAttributesFromObject (TextBlock * obj)
{
    HierarchicalCodeBlock::setAttributesFromObject(obj);
    OwnedCodeBlock::setAttributesFromObject(obj);
}

void OwnedHierarchicalCodeBlock::setAttributesOnNode (QDomDocument & doc, QDomElement & elem )
{
    // set super-class attributes
    HierarchicalCodeBlock::setAttributesOnNode(doc, elem);
    OwnedCodeBlock::setAttributesOnNode(doc, elem);

    // set local class attributes
    elem.setAttribute("parent_id",ID2STR(getParentObject()->getID()));

    // setting ID's takes special treatment
    // as UMLRoles arent properly stored in the XMI right now.
    // (change would break the XMI format..save for big version change )
    UMLRole * role = dynamic_cast<UMLRole*>(getParentObject());
    if(role) {
        // see comment on role_id at OwnedCodeBlock::setAttributesOnNode()
        elem.setAttribute("role_id", (role->getRole() == Uml::A));
    }
    /* else
            elem.setAttribute("role_id","-1");
    */
}

void OwnedHierarchicalCodeBlock::setAttributesFromNode ( QDomElement & root)
{
    // set attributes from the XMI
    HierarchicalCodeBlock::setAttributesFromNode(root); // superclass load
    OwnedCodeBlock::setAttributesFromNode(root); // superclass load
}

CodeDocument * OwnedHierarchicalCodeBlock::getParentDocument()
{
    return TextBlock::getParentDocument();
}

void OwnedHierarchicalCodeBlock::syncToParent ( )
{
    if(getContentType() != CodeBlock::AutoGenerated)
        return;

    updateContent();
}


#include "ownedhierarchicalcodeblock.moc"
