/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.http.webclient.server;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.openrdf.http.webclient.server.Server;
import org.openrdf.http.webclient.server.ServerSelection;
import org.openrdf.repository.Repository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.validation.BindException;
import org.springframework.web.servlet.ModelAndView;
import org.springframework.web.servlet.mvc.SimpleFormController;

public class ServerSelectionController
extends SimpleFormController {
    static final Logger logger = LoggerFactory.getLogger(ServerSelectionController.class);
    private String defaultServerContextName;

    public String getDefaultServerContextName() {
        return this.defaultServerContextName;
    }

    public void setDefaultServerContextName(String defaultWebapp) {
        this.defaultServerContextName = defaultWebapp;
    }

    protected ModelAndView onSubmit(HttpServletRequest request, HttpServletResponse response, Object command, BindException errors) throws Exception {
        ServerSelection serverSelection = (ServerSelection)command;
        String path = request.getContextPath();
        Cookie useAlwaysCookie = new Cookie("server.select.remember", String.valueOf(serverSelection.isRemember()));
        useAlwaysCookie.setPath(path);
        useAlwaysCookie.setMaxAge(31536000);
        response.addCookie(useAlwaysCookie);
        Cookie serverURLCookie = new Cookie("server.select.url", serverSelection.getLocation());
        serverURLCookie.setPath(path);
        if (serverSelection.isRemember()) {
            serverURLCookie.setMaxAge(31536000);
        }
        response.addCookie(serverURLCookie);
        Cookie serverTypeCookie = new Cookie("server.select.type", serverSelection.getType());
        serverTypeCookie.setPath(path);
        if (serverSelection.isRemember()) {
            serverTypeCookie.setMaxAge(31536000);
        }
        response.addCookie(serverTypeCookie);
        HttpSession session = request.getSession(true);
        Server server = (Server)session.getAttribute("openrdf-server");
        if (server == null || !server.getLocation().equals(serverSelection.getLocation())) {
            Repository repo = (Repository)session.getAttribute("openrdf-repository");
            if (repo != null) {
                repo.shutDown();
                session.removeAttribute("openrdf-repository");
                session.removeAttribute("openrdf-repository-info");
            }
            session.setAttribute("openrdf-server", (Object)new Server(serverSelection.getLocation()));
        }
        return super.onSubmit(request, response, null, errors);
    }

    protected Object formBackingObject(HttpServletRequest request) throws Exception {
        Object result = super.formBackingObject(request);
        ServerSelection serverSelection = (ServerSelection)result;
        serverSelection.setDefaultServerContextName(this.getDefaultServerContextName());
        serverSelection.setDefaultServerURL(request);
        serverSelection.setFromCookies(request);
        return result;
    }
}

