/*
 * Decompiled with CFR 0.152.
 */
package org.openrdf.repository.event.base;

import java.io.File;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArraySet;
import org.openrdf.repository.Repository;
import org.openrdf.repository.RepositoryException;
import org.openrdf.repository.base.RepositoryWrapper;
import org.openrdf.repository.event.InterceptingRepository;
import org.openrdf.repository.event.InterceptingRepositoryConnection;
import org.openrdf.repository.event.RepositoryConnectionInterceptor;
import org.openrdf.repository.event.RepositoryInterceptor;
import org.openrdf.repository.event.base.InterceptingRepositoryConnectionWrapper;

public class InterceptingRepositoryWrapper
extends RepositoryWrapper
implements InterceptingRepository {
    private boolean activated;
    private Set<RepositoryInterceptor> interceptors = new CopyOnWriteArraySet<RepositoryInterceptor>();
    private Set<RepositoryConnectionInterceptor> conInterceptors = new CopyOnWriteArraySet<RepositoryConnectionInterceptor>();

    public InterceptingRepositoryWrapper() {
    }

    public InterceptingRepositoryWrapper(Repository delegate) {
        super(delegate);
    }

    public void addRepositoryInterceptor(RepositoryInterceptor interceptor) {
        this.interceptors.add(interceptor);
        this.activated = true;
    }

    public void removeRepositoryInterceptor(RepositoryInterceptor interceptor) {
        this.interceptors.remove(interceptor);
        this.activated = !this.interceptors.isEmpty();
    }

    public void addRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.conInterceptors.add(interceptor);
    }

    public void removeRepositoryConnectionInterceptor(RepositoryConnectionInterceptor interceptor) {
        this.conInterceptors.remove(interceptor);
    }

    public InterceptingRepositoryConnection getConnection() throws RepositoryException {
        InterceptingRepositoryConnectionWrapper conn = new InterceptingRepositoryConnectionWrapper(this, super.getConnection());
        if (this.activated) {
            RepositoryInterceptor interceptor;
            boolean denied = false;
            Iterator<RepositoryInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).getConnection(this, conn))) {
            }
            if (denied) {
                conn = null;
            }
        }
        if (conn != null) {
            for (RepositoryConnectionInterceptor conInterceptor : this.conInterceptors) {
                conn.addRepositoryConnectionInterceptor(conInterceptor);
            }
        }
        return conn;
    }

    public void initialize() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).initialize(this))) {
            }
        }
        if (!denied) {
            super.initialize();
        }
    }

    public void setDataDir(File dataDir) {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).setDataDir(this, dataDir))) {
            }
        }
        if (!denied) {
            super.setDataDir(dataDir);
        }
    }

    public void shutDown() throws RepositoryException {
        boolean denied = false;
        if (this.activated) {
            RepositoryInterceptor interceptor;
            Iterator<RepositoryInterceptor> i$ = this.interceptors.iterator();
            while (i$.hasNext() && !(denied = (interceptor = i$.next()).shutDown(this))) {
            }
        }
        if (!denied) {
            super.shutDown();
        }
    }
}

