------------------------------------------------------------------------------
--                                                                          --
--                 GNU ADA RUNTIME LIBRARY (GNARL) COMPONENTS               --
--                                                                          --
--               S Y S T E M . T A S K I N G . A B O R T I O N              --
--                                                                          --
--                                  S p e c                                 --
--                                                                          --
--                             $Revision: 1.5 $                             --
--                                                                          --
--           Copyright (c) 1991,1992,1993, FSU, All Rights Reserved         --
--                                                                          --
--  GNARL is free software; you can redistribute it and/or modify it  under --
--  terms  of  the  GNU  Library General Public License as published by the --
--  Free Software Foundation; either version 2, or (at  your  option)  any  --
--  later  version.   GNARL is distributed in the hope that it will be use- --
--  ful, but but WITHOUT ANY WARRANTY; without even the implied warranty of --
--  MERCHANTABILITY  or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU Gen- --
--  eral Library Public License for more details.  You should have received --
--  a  copy of the GNU Library General Public License along with GNARL; see --
--  file COPYING. If not, write to the Free Software Foundation,  675  Mass --
--  Ave, Cambridge, MA 02139, USA.                                          --
--                                                                          --
------------------------------------------------------------------------------

with System.Task_Primitives;
--  Used for,  Task_Primitives.Pre_Call_State

package System.Tasking.Abortion is

   procedure Abort_Tasks (Tasks : Task_List);
   --  Abort_Tasks is called to initiate abortion, however, the actual
   --  abortion is done by abortee by means of Abort_Handler

   procedure Defer_Abortion;
--    pragma Inline (Defer_Abortion); -- why commented out ???

   procedure Undefer_Abortion;
--    pragma Inline (Undefer_Abortion); --  why commented out

   --   RTS Internal Declarations---Not part of the GNARLI.

   procedure Abort_To_Level (Target : Task_ID; L : ATC_Level);
   --  Abort a task to a specified ATC level.

   procedure Abort_Handler (Context : Task_Primitives.Pre_Call_State);
   --  Handler to be installed at initialization for special Abort_Signal.

   procedure Abort_Dependents (Abortee : Task_ID);
   --  Propagate abortion of parent into children.

end System.Tasking.Abortion;
