------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              E X P _ C H 4                               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.14 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  Expand routines for chapter 4 constructs

with Types; use Types;

package Exp_Ch4 is

   procedure Expand_N_Allocator                   (N : Node_Id);
   procedure Expand_N_Concat_Multiple             (N : Node_Id);
   procedure Expand_N_Op_And                      (N : Node_Id);
   procedure Expand_N_Op_Concat                   (N : Node_Id);
   procedure Expand_N_Op_Expon                    (N : Node_Id);
   procedure Expand_N_Op_Eq                       (N : Node_Id);
   procedure Expand_N_Op_Ge                       (N : Node_Id);
   procedure Expand_N_Op_Gt                       (N : Node_Id);
   procedure Expand_N_Op_In                       (N : Node_Id);
   procedure Expand_N_Op_Le                       (N : Node_Id);
   procedure Expand_N_Op_Lt                       (N : Node_Id);
   procedure Expand_N_Op_Not                      (N : Node_Id);
   procedure Expand_N_Op_Not_In                   (N : Node_Id);
   procedure Expand_N_Op_Or                       (N : Node_Id);
   procedure Expand_N_Op_Xor                      (N : Node_Id);
   procedure Expand_N_Slice                       (N : Node_Id);
   procedure Expand_N_Type_Conversion             (N : Node_Id);

   procedure Expand_Class_Wide_Allocator (
     N                  : Node_Id;
     Acc_Type           : Entity_Id;
     Class_Wide_Subtype : Entity_Id);
   --  Uses Expand_Class_Wide_Subtype to expand a new class wide subtype then
   --  transforms "new T'Class'(Exp)" into:
   --      Acc_Type (new Equiv_T'(Equiv_T (Exp)))

   function Expand_Record_Equality (
     Loc : Source_Ptr;
     Typ : Entity_Id;
     Lhs : Node_Id;
     Rhs : Node_Id)
     return Node_Id;
   --  Expand a record equality into an expression that compares the fields
   --  individually to yield the required Boolean result. Loc is the location
   --  for the generated nodes. Typ is the type of the record, and Lhs, Rhs
   --  are the record expressions to be compared. Note that the case of
   --  variant records is not implemented yet ???.

end Exp_Ch4;
