------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                              G K R U N C H                               --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.3 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

--  This is a small utility program that incorporates the file krunching
--  algorithm used by the GNAT compiler (when the -gnatk switch is used)

--     gkrunch  filename  length

--  where length is a decimal value, outputs to standard output the krunched
--  name, followed by the original input file name. The file name has an
--  optional extension, which, if present, is copied unchanged to the output.

with Krunch;
with System.Environment; use System.Environment;
with Ada.Text_IO;        use Ada.Text_IO;

procedure Gkrunch is
   Fname         : Arg_Ptr;
   Length_String : Arg_Ptr;
   Maxlen        : Natural;
   Ptr           : Natural;
   Klen          : Natural;
   Ext           : Natural;

   package Int_Io is new Integer_Io (Integer);
   use Int_Io;

begin
   if Arg_Count /= 3 then
      Put_Line (Standard_Error,
        "Usage: gkrunch  filename[.extension]  krunch-count");

   else
      Fname := Arg_Value (1);
      Length_String := Arg_Value (2);

      Get (Length_String.all, Maxlen, Ptr);

      declare
         S : String (1 .. Fname'Length) := Fname.all;

      begin
         Klen := Fname'Length;
         Ext := Klen + 1;

         for J in 1 .. Fname'Length loop
            if Fname (J) = '.' then
               Klen := J - 1;
               Ext := J;
               exit;
            end if;
         end loop;

         Krunch (S, Klen, Maxlen, False);

         Put (S (1 .. Klen));
         Put (S (Ext .. Fname'Length));
         New_Line;
      end;
   end if;

end Gkrunch;
