/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                                  L D                                     */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                             $Revision: 1.1 $                             */
/*                                                                          */
/*                Copyright (c) 1994 NYU, All Rights Reserved               */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* The raison d'etre of this program is to get around the command line length
   limitation of the OS/2 linker (link386.exe).  This program basically echoes
   its arguments to a response file and invokes the linker using this response
   file.  */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <process.h>

int   link_arg_max = -1;
char  **link_args = NULL;
int   link_arg_index = -1;

static void
addarg (char *str)
{
  int i;

  if (++link_arg_index >= link_arg_max) {
    char **new_link_args
      = (char **) calloc (link_arg_max + 1000, sizeof (char *));
    for (i = 0; i <= link_arg_max; i++)
      new_link_args [i] = link_args [i];
    if (link_args) free (link_args);
    link_arg_max += 1000;
    link_args = new_link_args;
  }

  link_args [link_arg_index] = str;
}

main (int argc, char *argv [])
{
  int i;
  int arg_ends_in_comma, last_arg_ended_in_comma;
  int exit_code = 0;
  char *link386 = "link386";
  char *link_arg;
  char *filename;
  FILE *response_file;

  if ((filename = tmpnam (NULL)) == NULL) {
    perror (
      "Unable to create a suitable name to use for the linker response file");
    exit (1);
  }

  if ((response_file = fopen (filename, "w")) == NULL) {
    perror ("Unable to create the linker response file");
    exit (1);
  }

  /* Write the arguments to the linker response file.  */
  for (i = 1, last_arg_ended_in_comma = 0; i < argc; i++) {
    ++argv;
    if (arg_ends_in_comma = (*argv) [strlen (*argv) - 1] == ',')
      /* Remove the trailing comma.  */
      (*argv) [strlen (*argv) - 1] = '\0';
    if (arg_ends_in_comma && strlen (*argv) == 0) {
      if (last_arg_ended_in_comma) fprintf (response_file, "\n");
    }
    else if (i == 1 || (*argv) [0] == ';' && (*argv) [1] == '\0')
      fprintf (response_file, "%s", *argv);
    else if (last_arg_ended_in_comma)
      fprintf (response_file, "\n%s", *argv);
    else
      fprintf (response_file, " +\n%s", *argv);
    last_arg_ended_in_comma = arg_ends_in_comma;
  }
  fprintf (response_file, "\n");

  if (fclose (response_file)) {
    perror ("Unable to close the linker response file");
    exit (1);
  }

  addarg (link386);
  if ((link_arg = malloc (strlen (filename) + 2)) == NULL) {
    perror ("Out of memory");
    exit (1);
  }
  strcpy (link_arg, "@");
  addarg (strcat (link_arg, filename));
  addarg (NULL);

  if (spawnvp (P_WAIT, link386, link_args) != 0) {
    fprintf (stderr, "Error executing %s\n", link_args[0]);
    exit_code = 1;
  }

  if (remove (filename)) {
    perror ("Unable to delete the linker response file");
    exit (1);
  }

  exit (exit_code);

}
