/*
	Routine makes a command or console window.
	There should be only one such window.
	It sets first the default window option to `no features' and sets
	a flag to let wopen know this is going to be special.
	If the window is straight under the menu bar we set a variable
	that prevents future windows from being opened over our console.
	The window is opened and the necessary parameters are reset.
*/

#include "window.h"

WINDOW *
wopencon(drawproc)
void (*drawproc)();
{
	WINDOW	*new;
	w_def_opt = CON_OPT;
	w_from_con = 1;
	if ( y_def <= BAR_HEIGHT )
		w_min_v_pos = h_def + 2 - w_t_border - w_b_border;
	new = wopen("",drawproc);
	w_def_opt = DEF_OPT;
	w_from_con = 0;
	return (new);
}

