
#include "window.h"

void
wscroll(win, left, top, right, bottom, dh, dv)
WINDOW	*win;
int	left, top, right, bottom;
int	dh;
int	dv;
{
	int	src[4];
	int	diff[4][4];
	int	nr_diff;
	int	i;
	int	changed[4];

	if (win == NULL) return;

	rmcaret ();

	if ( left >= right || top >= bottom || (dh == 0 && dv == 0) ) return;

	if (getsrcdiff (win, left, top, right, bottom, dh, dv, src, diff, &nr_diff))
		scrollby (win, src[0], src[1], src[2], src[3], dh, dv);

	wgetchange (win, &changed[0], &changed[1], &changed[2], &changed[3]);
	if (intersect (src, changed))
		wchange (win, changed[0] + dh, changed[1] + dv,
				changed[2] + dh, changed[3] + dv);

	for (i = 0; i < nr_diff; i++) {
		wchange (win, diff[i][0] + dh, diff[i][1] + dv,
				diff[i][2] + dh, diff[i][3] + dv);
	}

	showcaret ();

	wupdate (win);
}

