/* 
Copyright (C) 1993 Free Software Foundation

This file is part of the GNU IO Library.  This library is free
software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the
Free Software Foundation; either version 2, or (at your option)
any later version.

This library is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with GNU CC; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

As a special exception, if you link this library with files
compiled with a GNU compiler to produce an executable, this does not cause
the resulting executable to be covered by the GNU General Public License.
This exception does not however invalidate any other reasons why
the executable file might be covered by the GNU General Public License. */

/* I/O OS-level primitives.
   Needs to be replaced if not using Unix.
   Also needs to be replaced if avoiding name-space pollution
   (in which case read would be defined in terms of _IO_read,
   rather than vice versa). */

#ifndef __linux__

#include "libioP.h"
#include <unistd.h>
#include <sys/types.h>
#include <sys/stat.h>

#ifdef TODO
/* Add open, isatty */
#endif

_IO_ssize_t
_IO_read (fildes, buf, nbyte)
     int fildes;
     void *buf;
     _IO_size_t nbyte;
{
  return read (fildes, buf, nbyte);
}

_IO_ssize_t
_IO_write (fildes, buf, nbyte)
     int fildes;
     const void *buf;
     _IO_size_t nbyte;
{
  return write (fildes, buf, nbyte);
}

_IO_off_t
_IO_lseek (fildes, offset, whence)
     int fildes;
     _IO_off_t offset;
     int whence;
{
  return lseek (fildes, offset, whence);
}

int
_IO_close (fildes)
     int fildes;
{
  return close (fildes);
}

int
_IO_fstat (fildes, buf)
     int fildes;
     struct stat *buf;
{
  return fstat (fildes, buf);
}

#endif
