
FOREIGN MODULE msIO;

(*
 *  I/O Library for Modula-2*
 *
 *  all output goes to "stdout", all input comes from "stdin"
 *
 *
 *  Modula-2* interface by Ernst A. Heinz
 *
 *  C/MPL implementation by Ernst A. Heinz
 *
 *  Last change: 15.10.1992
 *)

PROCEDURE WrB( b: BOOLEAN );
  (* write "T" or "F" *)
PROCEDURE WrC( n: LONGCARD; w: SHORTINT );
  (* write (long) cardinal value *)
PROCEDURE WrCh( ch: CHAR );
  (* write character *) 
PROCEDURE WrE( n: LONGREAL; w: SHORTINT; prec: SHORTCARD );
  (* write (long) real value in exponential format *)
PROCEDURE WrF( n: LONGREAL; w: SHORTINT; prec: SHORTCARD; exp: BOOLEAN );
  (* write (long) real value in fixed point or exponential format *)
PROCEDURE WrH( n: LONGCARD; w: SHORTINT );
  (* write hexadecimal representation of (long) cardinal value *)
PROCEDURE WrI( n: LONGINT; w: SHORTINT );
  (* write (long) integer value *)
PROCEDURE WrLn;
PROCEDURE WrNl;
  (* write newline *)
PROCEDURE WrO( n: LONGCARD; w: SHORTINT );
  (* write octal representation of (long) cardinal value *)
PROCEDURE WrR( n: LONGREAL; w: SHORTINT; prec: SHORTCARD );
  (* write (long) real value in fixed point format *)
PROCEDURE WrS( str: ARRAY OF CHAR );
  (* write string *)

PROCEDURE RdB() : BOOLEAN;
  (* read until input in ['f','F','t','T'], return true if input in ['t','T'] *)
PROCEDURE RdCh() : CHAR;
  (* read character *)
PROCEDURE RdC() : LONGCARD;
  (* read (long) cardinal *)
PROCEDURE RdH() : LONGCARD;
  (* read hexadecimal number and return its (long) cardinal value *)
PROCEDURE RdI() : LONGINT;
  (* read (long) integer *)
PROCEDURE RdLn; PROCEDURE RdNl;
  (* read until newline character is detected *)
PROCEDURE RdO() : LONGCARD;
  (* read octal number and return its (long) cardinal value *)
PROCEDURE RdR() : LONGREAL;
  (* read (long) real *)
PROCEDURE RdS( VAR str: ARRAY OF CHAR );
  (* read string *)

END msIO.