
FOREIGN MODULE msMath;

(* written by Ernst A. Heinz / 07.05.1992 *)

FROM SYSTEM IMPORT ADDRESS;

(* please look in the manpages for more details
 * the routines are similiar to their c-pendants
 *)

PROCEDURE finite( x: LONGREAL ) : SHORTINT;
PROCEDURE fabs( x: LONGREAL ) : LONGREAL;
PROCEDURE floor( x: LONGREAL ) : LONGREAL;
PROCEDURE ceil( x: LONGREAL ) : LONGREAL;
PROCEDURE rint( x: LONGREAL ) : LONGREAL;
PROCEDURE hypot( x, y: LONGREAL ) : LONGREAL;
PROCEDURE copysign( x, y: LONGREAL ) : LONGREAL;
PROCEDURE sqrt( x: LONGREAL ) : LONGREAL;
PROCEDURE modf( x: LONGREAL; y: ADDRESS ) : LONGREAL;
PROCEDURE fmod( x: LONGREAL; y: LONGREAL ) : LONGREAL;
PROCEDURE frexp( x: LONGREAL; y: ADDRESS ) : LONGREAL;
PROCEDURE asinh( x: LONGREAL ) : LONGREAL;
PROCEDURE acosh( x: LONGREAL ) : LONGREAL;
PROCEDURE atanh( x: LONGREAL ) : LONGREAL;
PROCEDURE erf( x: LONGREAL ) : LONGREAL;
PROCEDURE erfc( x: LONGREAL ) : LONGREAL;
PROCEDURE exp( x: LONGREAL ) : LONGREAL;
PROCEDURE expm1( x: LONGREAL ) : LONGREAL;
PROCEDURE log( x: LONGREAL ) : LONGREAL;
PROCEDURE log10( x: LONGREAL ) : LONGREAL;
PROCEDURE log1p( x: LONGREAL ) : LONGREAL;
PROCEDURE pow( x, y: LONGREAL ) : LONGREAL;
PROCEDURE j0( x: LONGREAL ) : LONGREAL;
PROCEDURE j1( x: LONGREAL ) : LONGREAL;
PROCEDURE jn( x: LONGREAL ) : LONGREAL;
PROCEDURE y0( x: LONGREAL ) : LONGREAL;
PROCEDURE y1( x: LONGREAL ) : LONGREAL;
PROCEDURE yn( x: LONGREAL ) : LONGREAL;
PROCEDURE sin( x: LONGREAL ) : LONGREAL;
PROCEDURE cos( x: LONGREAL ) : LONGREAL;
PROCEDURE tan( x: LONGREAL ) : LONGREAL;
PROCEDURE asin( x: LONGREAL ) : LONGREAL;
PROCEDURE acos( x: LONGREAL ) : LONGREAL;
PROCEDURE atan( x: LONGREAL ) : LONGREAL;
PROCEDURE atan2( x, y: LONGREAL ) : LONGREAL;
PROCEDURE sinh( x: LONGREAL ) : LONGREAL;
PROCEDURE cosh( x: LONGREAL ) : LONGREAL;
PROCEDURE tanh( x: LONGREAL ) : LONGREAL;
PROCEDURE cbrt( x: LONGREAL ) : LONGREAL;

PROCEDURE log2( x: LONGREAL ) : LONGREAL;
PROCEDURE exp10( x: LONGREAL ) : LONGREAL;
PROCEDURE exp2( x: LONGREAL ) : LONGREAL;

PROCEDURE nint( x: LONGREAL ) : SHORTINT;
PROCEDURE sincos( x: LONGREAL; VAR sine, cosine: LONGREAL );

(* these functions are not for all architectures available: *)
(* available for SUN3, SUN4: *)
PROCEDURE sinpi( x: LONGREAL ) : LONGREAL;
PROCEDURE cospi( x: LONGREAL ) : LONGREAL;
PROCEDURE aint( x: LONGREAL ) : LONGREAL;
PROCEDURE anint( x: LONGREAL ) : LONGREAL;
(* available for SUN3, SUN4, MIPS, KSRS: *)
PROCEDURE lgamma( x: LONGREAL ) : LONGREAL;

END msMath.


