/*
 * XDW		Headers for Simple X etc pp
 *
 * Stefan Haenssgen 10-Mar-92
 *
 * Updates:	08-Apr-92  Introduced colors
 * 		10-Apr-92  Introduced title string
 * 		13-Apr-92  Default colors (B&W)
 *			   Added GetMouseData() for user interaction
 *			   Added auto/manual positioning of window
 *		05-May-92  Added FastDrawMonoPixel()
 *		12-May-92  Added SetFont(), DrawString()
 *			   Modified parameters of OpenDW() [tlen]
 *			   Added DrawLine() and DrawRectangle()
 *		13-May-92  Added colors to Drawing routines
 *		16-May-92  Added Circle, Ellipse & Filling
 *		25-mar-93  Added FastDrawBWPixel for just B&W
 *
 */

/*
 * A note on colors:
 *
 * The colors the user wants to see are given in the array "colors"
 * that points to the single colors as follows:
 *
 * One single color has the type  "singleColor" which is a
 *     struct { unsigned short  red,green,blue; }
 *
 * 
 * singleColor *colors   ->   colors[0] (with colors[0].red, colors[0].green
 *                                       and colors[0].blue as RGB values)
 * 			      colors[1] = ...etc...
 *
 *
 * The user just fills in the values for red, green and blue, ranging
 * from 0 (nothing) to 65535 (full brightness of this color),
 * e.g. (0,0,65535) is perfect blue, (0,0,0) is black, (65535,65535,65535)
 * is white and (65535,65535,0) is yellow etc.
 *
 * If no colors are given, i.e. numcolors==0 or colors==NULL, then black
 * and white are used as the two default colors.
 */

/*
 *
 * Functions:
 * ---------
 *
 * OpenDisplayWindow(x,y,width,heigth,numcolors,colors,wtitle,tlen)
 *		Opens a display window of the given size at (x,y)
 *		If x or y are negative, the window is manually positioned
 *
 *		int         numcolors = number of wanted colors
 *		singleColor colors[]  = array with RGB values
 *				        (i.e. colors[0].red = red value
 *				         colors[0].green, colors[0].blue dito)
 *		char        *wtitle   = title of window
 *		unsigned long tlen    = length of title string
 *
 * DrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!)
 *
 * FastDrawPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *
 * FastDrawMonoPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *		*** for monochrome displays, use this function!!! ***
 *
 * FastDrawBWPixel(x,y,color)
 *		Draws a pixel of the given color internally (!), faster
 *		(like ..Mono.. but no color lookup, just 0 or !=0)
 *
 * SetFont(fontname)
 *		Sets the font to use with text outout, e.g. "fixed"
 *
 * DrawString(x,y,color,string,slen)
 *		Draws a text string of slen characters at (x,y)
 *
 * DrawLine(x1,y1,x2,y2,color)
 *		Draws a line between the given coordinates
 *
 * DrawRectangle(x,y,width,height,color,filled)
 *		Draws a rectangle (filled if True)
 *
 * DrawCircle(x,y,r,color,filled)
 *		Draws a circle (filled if True)
 *
 * DrawEllipse(x,y,r1,r2,color,filled)
 *		Draws an ellipse (filled if True)
 *
 * GetMouseData(&x,&y,&button)
 *		Get most recent mouse coordinates & button status:
 *		button = 1*left + 2*middle + 4*right  (if l/m/r button pressed)
 *		x = y = -1  if mouse not in window
 *
 * ClearDisplayWindow()
 *		Quickly clears the drawing area internally (!)
 *
 * UpdateDisplayWindow()
 *		Updates displayed window, makes recent changes visible
 *
 * CloseDisplayWindow()
 *		Destroys the window and closes the connection to X
 *
 *
 * WARNING: All Drawing Routines have SERIOUS OVERHEAD because of
 *	    conversion of different picture formats. Beware :-)
 *
 */


/* Functions in the X Interface */

extern int  OpenDisplayWindow(/* x,y,width,height,numcolors,colors,wtitle */);
extern void DrawPixel(/* x,y,color */);
extern void FastDrawPixel(/* x,y,color */);
extern void FastDrawMonoPixel(/* x,y,color */);
extern void FastDrawBWPixel(/* x,y,color */);
extern void SetDisplayWindowFont(/* fontname */);
extern void DrawString(/* x,y,color,string,slen */);
extern void DrawLine(/* x1,y1,x2,y2,color */);
extern void DrawRectangle(/* x,y,width,height,color,filled */);
extern void DrawCircle(/* x,y,r,color,filled */);
extern void DraEllipse(/* x,y,r1,r2,color,filled */);
extern void GetMouseData(/* &x,&y,&button */);
extern void WaitForMouseClick();
extern void UpdateDisplayWindow();
extern void CloseDisplayWindow();
extern void ClearScreen();


/* Used variables */

typedef struct {				/* Color type		   */
    unsigned short red,green,blue;
} singleColor;

typedef singleColor *colorPtr;

extern singleColor *colors;
extern char* pixelbuffer;			/* Pixel buffer, direct	   */
extern int width;				/* Size of window	   */
extern int height;
extern int maxcolors;				/* # of colors we got	   */
extern unsigned long foregrounds[];		/* Pixel values for colors */
extern unsigned long backgrounds[];
extern int mouseX, mouseY, mouseButton;		/* Mouse data		   */


/* Abbreviations (hello Ernst :-) */

#define ClearDW		ClearDisplayWindow
#define CloseDW		CloseDisplayWindow
#define Circle		DrawCircle
#define Draw		DrawPixel
#define Ellipse		DrawEllipse
#define Line		DrawLine
#define Mouse		GetMouseData
#define Rectangle	DrawRectangle
#define Text		DrawString
#define FDraw		FastDrawPixel
#define FDrawMono	FastDrawMonoPixel
#define OpenDW		OpenDisplayWindow
#define SetDWFont	SetDisplayWindowFont
#define UpdateDW	UpdateDisplayWindow
#define WaitClick	WaitForMouseClick
