/* VGAlib version 1.2 - (c) 1993 Tommy Frandsen 		   */
/*								   */
/* This library is free software; you can redistribute it and/or   */
/* modify it without any restrictions. This library is distributed */
/* in the hope that it will be useful, but without any warranty.   */

/* Multi-chipset support Copyright (c) 1993 Harm Hanemaayer */
/* partially copyrighted (C) 1993 by Hartmut Schirmer */

#ifndef _DRIVER_H
#define _DRIVER_H

#include <stdio.h>
#include "libvga.h"

#define MAX_REGS 200

extern int (*vga_chipsetfunctions[])();
extern int (*cirrus_chipsetfunctions[])();
extern int (*et4000_chipsetfunctions[])();
extern int (*tvga8900_chipsetfunctions[])();
extern int (*vga_chipsetfunctions[])();
extern int (*oak_chipsetfunctions[])();
extern int (*ega_chipsetfunctions[])();
extern int (*s3_chipsetfunctions[])();
extern int (*mach32_chipsetfunctions[])();
extern int (*et3000_chipsetfunctions[])();

extern int (**chipsetfunctions)();
extern int (**chipsetfunctionslist[])();

enum { 
	CHIPSET_SAVEREGS = 0, CHIPSET_SETREGS, CHIPSET_UNLOCK, CHIPSET_LOCK,
	CHIPSET_TEST, CHIPSET_INIT, CHIPSET_SETPAGE, CHIPSET_SETRDPAGE,
	CHIPSET_SETWRPAGE, CHIPSET_SETMODE,
	CHIPSET_MODEAVAILABLE, CHIPSET_SETDISPLAYSTART,
	CHIPSET_SETLOGICALWIDTH, CHIPSET_GETMODEINFO,
	CHIPSET_BITBLT, CHIPSET_IMAGEBLT, CHIPSET_FILLBLT,
	CHIPSET_HLINELISTBLT, CHIPSET_BLTWAIT
};

extern int CRT_I;
extern int CRT_D;
extern int IS1_R;
extern int __svgalib_driver_report;	/* driverreport */
extern int __svgalib_videomemoryused;	/* videomemoryused */
extern int __svgalib_critical;
extern int __svgalib_chipset;
extern int __svgalib_monitortype;
extern int __svgalib_modeinfo_linearset;
void __svgalib_read_options(char **commands, char *(*func)(int ind,int mode));

/* ----------------------------------------------------------------------
** A modetable holds a pair of values 
** for each mode :
**
**    <mode number> <pointer to registers>
**
** the last entry is marked by 
**  
**    <any number>  <NULL>
*/

typedef struct {
   unsigned short mode_number;
   const unsigned char  *regs;
} ModeTable;

#define DISABLE_MODE	  ((unsigned char *)1)
#define OneModeEntry(res) {G##res,g##res##_regs}
#define DisableEntry(res) {G##res,DISABLE_MODE}
#define END_OF_MODE_TABLE { 0, NULL }

extern const unsigned char *__vga_mode_in_table(const ModeTable *modes, int mode);
#define LOOKUPMODE __vga_mode_in_table

/* ---------------------------------------------------------------------- */

extern int __vga_hicolor(int dac_type, int mode);
/* Enters hicolor mode - 0 for no hi, 1 for 15 bit, 2 for 16, 3 for 24 */
/* For any modes it doesn't know about, etc, it attempts to turn hicolor off. */


#define STD_DAC		0
#define HI15_DAC	1
#define HI16_DAC	2
#define TC24_DAC	3

/* ----------------------------------------------------------------------
** regextr.h  -  extract graphics modes and register information
**               from C source file
*/

extern void __vga_readmodes(FILE *inp, ModeTable **modes, int *dac, unsigned *clocks);

#endif


