
#include <stdio.h>
/*
extern void dis_8086(FILE *, unsigned int, const unsigned char *,
		     const unsigned char *);
*/
#define EIP_MODE	1
#define CSIP_MODE	2
#define PROT_MODE	3

void dis_block (mode, address, cs, ip, size)
	int	mode;
	unsigned char * address;
	int	cs;
	int	ip;
	int	size;
{
	char outbuf[1024];
	unsigned char * eip;
	int numbytes;
	int i;

	eip = address;
	while (eip < address + size) {
		switch (mode) {
		    case CSIP_MODE:
			fprintf(stdout, "%4.4x:%4.4x ",cs,ip);
			numbytes = i386dis (mode, cs, ip, eip, outbuf);
			for(i=0; i<numbytes; i++)
				printf("%02x",*eip++);
			for(i=numbytes; i<5; i++)
				printf("  ");
			fprintf(stdout, "\t%s\n", outbuf);
			ip += numbytes;
			if (ip > 0xffff) {
				ip &= 0xffff;
				cs += 0x1000;
			}
			break;
		    case EIP_MODE:
		    case PROT_MODE:
		    default:
			fprintf(stdout, "%8.8x  ",ip);
			numbytes = i386dis (mode, cs, ip, eip, outbuf);
			for(i=0; i<numbytes; i++)
				printf("%02x",*eip++);
			for(i=numbytes; i<5; i++)
				printf("  ");
			fprintf(stdout, "\t%s\n", outbuf);
			ip += numbytes;
			break;
			
		}
	}
}

main(int argc, char *argv[])
{
  unsigned char buf[65536];
  int n, off;

  n = read(0, buf, sizeof buf);
  if (n == -1)
    {
      perror("read");
      return 2;
    }
  if (n == 0)
    return 0;

  off = (argc > 1) ? strtoul(argv[1], (char **)0, 16) : 0;
/*  dis_8086(stdout, off, buf + off, buf + n); */
  dis_block(CSIP_MODE,buf+off,0,off,n-off);
  return 0;
}
