#include <stdio.h>
#include <stdarg.h>
#include "file2.h"
#include "internal.h"

#include <trace.h>
/*************************************************************************
 *
 * Function:    fscanf
 *
 * Description:
 *     scan the input file for the input format.
 *
 * Input:
 *     fpStream   - Pointer to the input stream to be scanned.
 *     pszFormat  - Pointer to the input format
 *     args       - Various arguments for the scan operation.
 *
 * Output:
 *     The number of characters scanned or -1 to indicate an error or EOF.
 */

int fscanf (FILE *fpStream, const char *pszFormat, ...)
    {
    int     nAnswer;
    va_list vaArgs;
    FUNC_ENTRY ("fscanf");
/*
 *  Scan the argument list
 */
    va_start (vaArgs, pszformat);
    nAnswer = _input (fpStream, pszFormat, vaArgs);
    va_end (vaArgs);
/*
 *  Return the number of characters scanned to the caller.
 */
    FUNC_EXIT ("fscanf");
    return (nAnswer);
    }
