/* @(#)src/version.c	1.7 8/8/92 19:30:55 */

/*
 *    Copyright (C) 1987, 1988 Ronald S. Karr and Landon Curt Noll
 *    Copyright (C) 1992  Ronald S. Karr
 * 
 * See the file COPYING, distributed with smail, for restriction
 * and warranty information.
 */

/*
 * version:
 *	return the current smail version
 */
#include <stdio.h>
#include "defs.h"
#include "version.h"
#ifndef DEPEND
# include "extern.h"
#endif

/*
 * version - keep track of the smail version number
 *
 * The bat's eyes are intended to denote the origin of this source.  We
 * ask that you follow the convention below:
 *
 *	/\--/\	from namei.uucp, e-.uucp and their down stream feeds
 *	/\o-/\  half baked smail from amdahl.com (obsolete)
 *	/\=-/\	as sent to Alpha sites
 *	/\==/\  as sent to Beta sites
 *	/\../\  as released with UTS
 *	/\oo/\  as posted to Usenet
 *	/\$$/\  from the Free Software Foundation (assuming they take it)
 *	/\@@/\  with VHS routing
 *
 * The most likely case is that the bat's eyes in your version is correct.
 * We suggest that you leave them alone unless you know differently.
 *
 * external functions:
 *	version
 */
char *version_number = VERSION;
char *release_date = RELEASE_DATE;
char *patch_number = PATCH_NUMBER;
char *patch_date = PATCH_DATE;
char *bat = "/\\==/\\";			/* the proper bat for this release */

static char *our_version = NULL;	/* no version in the beginning */

char *
version()
{
    /*
     * form the version string for the first time if needed
     */
    if (our_version == NULL) {
	our_version = xmalloc(sizeof(" Smail #.dddddd") +
			      strlen(bat) +
			      strlen(version_number) +
			      strlen(patch_number));
	(void) sprintf(our_version,
		       "%s Smail%s #%s.%d",
		       bat,
		       version_number,
		       patch_number,
		       compile_num);
    }

    /*
     * return the version string
     */
    return our_version;
}
