/*
 ******************************************************************************
 *
 *	ParcPlace Systems, Inc.
 *	Copyright (c) 1990, ParcPlace Systems, Inc. USA   All rights reserved.
 *
 ****************************************************************************
 *
 *	File:	lmrc.H
 *
 *	Functions(s):
 *
 *	Description:
 *		OI_layout_row, OI_layout_column, OI_layout_row_aligned class header
 *
 *	RCSid = "$Id: lmrc.H,v 4.27.1.1 1993/06/01 22:55:15 mth Exp $"
 *
 ****************************************************************************
 */

#ifndef OI_lmrc_H
#define OI_lmrc_H

#ifndef OI_layout_H
#include <OI/layout.H>
#endif /* OI_layout_H */

		class	OI_d_tech ;
		class	OI_lm_row_col ;

		class	OI_lm_glue : public OI_layout_slot	{					/* slot for glue in row/col based layout */
		 protected:
			OI_number		nom ;							/* nominal size */
			OI_number		strtch ;						/* stretchability */
			OI_number		siz ;							/* actual size */
		 public:
						OI_lm_glue(OI_number n, OI_number st=0) ;
		virtual				~OI_lm_glue() ;
			OI_bool			configure(OI_number n, OI_number s) ;
		virtual	OI_bool			is_glue() const ;
			OI_number		nom_size() const				{ return(nom); }
		virtual	long			origin_x() const ;
		virtual	long			origin_y() const ;
			void			set_nominal_size(OI_number n)			{ nom=siz=n; }
			void			set_stretch(OI_number s)			{ strtch=s; }
			OI_number		size() const					{ return(siz); }
			OI_number		stretch() const					{ return(strtch); }
		} ;

		class	OI_lm_horz_glue : public OI_lm_glue	{
		 public:
						OI_lm_horz_glue(OI_number n, OI_number st=0) : OI_lm_glue(n,st)	{ }
		virtual				~OI_lm_horz_glue() ;
		virtual	void			minimum_size(OI_number*,OI_number*) const ;
		virtual	OI_number		minimum_size_x() const ;
		virtual	OI_number		minimum_size_y() const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	OI_number		nominal_size_x() const ;
		virtual	OI_number		nominal_size_y() const ;
		virtual	void			set_size(OI_number, OI_number) ;
		virtual	OI_number		size_x() const ;
		virtual	OI_number		size_y() const ;
		virtual	OI_number		stretch_x() const ;
		virtual	OI_number		stretch_y() const ;
		} ;

		class	OI_lm_vert_glue : public OI_lm_glue	{
		 public:
						OI_lm_vert_glue(OI_number n, OI_number st=0) : OI_lm_glue(n,st)	{ }
		virtual				~OI_lm_vert_glue() ;
		virtual	void			minimum_size(OI_number*,OI_number*) const ;
		virtual	OI_number		minimum_size_x() const ;
		virtual	OI_number		minimum_size_y() const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	OI_number		nominal_size_x() const ;
		virtual	OI_number		nominal_size_y() const ;
		virtual	void			set_size(OI_number, OI_number) ;
		virtual	OI_number		size_x() const ;
		virtual	OI_number		size_y() const ;
		virtual	OI_number		stretch_x() const ;
		virtual	OI_number		stretch_y() const ;
		} ;

		class	OI_lm_rc_box : public OI_lm_box	{						/* row or column container for any row-column based layout */
		 public:
						OI_lm_rc_box();
		virtual				~OI_lm_rc_box();
		virtual	OI_number		find_minor(long,OI_number) const ;			/* find minor insert position */
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
			OI_bool			is_last_row_column() const ;				/* OI_yes => last row/column in a series */
		virtual OI_bool			is_row_aligned_box() const ;
		virtual OI_bool			is_row_column_box() const ;
			OI_lm_rc_box		*major_container() const ;				/* row/col container (1st lvl under layout method) */
		virtual	void			new_default_space() ;					/* adjust for change in default spacing */
		} ;

		class	OI_lm_row_box : public OI_lm_rc_box	{					/* row container */
		 public:
						OI_lm_row_box() {}
		virtual				~OI_lm_row_box();
		virtual	OI_gravity		gravity() const ;
		virtual	void			insert_slot(OI_number,OI_lm_box*,OI_lm_glue* =NULL,OI_lm_glue* =NULL) ;
		virtual	void			minimum_size(OI_number*,OI_number*) const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	void			position_slots() ;					/* position slots within the layout */
		virtual	void			set_size(OI_number,OI_number) ;
		virtual	OI_number		stretch_x() const ;
		virtual	OI_number		stretch_y() const ;
		} ;

		class	OI_lm_col_box : public OI_lm_rc_box	{					/* column container */
		 public:
						OI_lm_col_box() {}
		virtual				~OI_lm_col_box();
		virtual	OI_gravity		gravity() const ;
		virtual	void			insert_slot(OI_number,OI_lm_box*,OI_lm_glue* =NULL,OI_lm_glue* =NULL) ;
		virtual	void			minimum_size(OI_number*,OI_number*) const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	void			position_slots() ;					/* position slots within the layout */
		virtual	void			set_size(OI_number,OI_number) ;
		virtual	OI_number		stretch_x() const ;
		virtual	OI_number		stretch_y() const ;
		} ;

		class	OI_lm_rc_obj_box : public OI_lm_obj_box {					/* obj_box for item in row/col type layout */
		 protected:
		virtual				~OI_lm_rc_obj_box();
		virtual	OI_bool			configure_major_leading_inslot_glue(OI_number,OI_number) ;
		virtual	OI_bool			configure_major_trailing_inslot_glue(OI_number,OI_number) ;
		virtual	OI_lm_glue		*major_leading_inslot_glue() const ;
		virtual	OI_number		major_leading_space() const ;
		virtual	OI_number		major_stretch() const = 0 ;
		virtual	OI_lm_glue		*major_trailing_inslot_glue() const ;
		virtual	OI_number		major_trailing_space() const ;
		virtual	OI_lm_glue		*minor_leading_inslot_glue() const ;
		virtual	OI_number		minor_leading_space() const = 0 ;
		virtual	OI_number		minor_stretch() const = 0 ;
		virtual	OI_lm_glue		*minor_trailing_inslot_glue() const ;
		virtual	OI_number		minor_trailing_space() const = 0 ;
		 public:
						OI_lm_rc_obj_box(OI_d_tech*, OI_lm_row_col*) ;
			OI_bool			adj_major_sizetrack(OI_bool*) ;				/* adjust stretch for maj size tracking */
			OI_bool			adj_major_leading_inslot_glue() ;			/* adjust in-slot glue before obj in maj dir */
			OI_bool			adj_major_trailing_inslot_glue() ;			/* adjust in-slot glue after obj in maj dir */
		virtual	OI_bool			adj_minor_leading_glue() ;				/* adjust stretch for minor size tracking */
			OI_bool			adj_minor_sizetrack(OI_bool*) ;				/* adjust stretch for minor size tracking */
		virtual	OI_bool			adj_minor_trailing_glue() ;				/* adjust stretch for minor size tracking */
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
		virtual	void			new_default_space() ;					/* adjust for change in default spacing */
		virtual	void			nominal_minor_leading_space(OI_bool*,OI_number*) const = 0 ;
		virtual	void			nominal_minor_trailing_space(OI_bool*,OI_number*) const = 0 ;
		virtual	void			set_major_stretch(OI_number) = 0 ;
		virtual	void			set_minor_stretch(OI_number) = 0 ;
		} ;

		class	OI_lm_row_obj_box : public OI_lm_rc_obj_box {					/* obj_box for item in row layout */
				// Note -- a normal glue object is not used for the in-slot glue to save space
				// This does not effect the code generality because the glue is always referenced via special member functions anyway
			OI_number		tp_glue_nom ;						/* nominal size for top glue */
			OI_number		tp_glue_siz ;						/* actual size for top glue */
			OI_number		tp_glue_strtch ;					/* stretch for top glue */
			OI_number		bt_glue_nom ;						/* nominal size for bottom glue */
			OI_number		bt_glue_siz ;						/* actual size for bottom glue */
			OI_number		bt_glue_strtch ;					/* stretch for bottom glue */
		 protected:
		virtual	OI_bool			configure_major_leading_inslot_glue(OI_number,OI_number) ;
		virtual	OI_bool			configure_major_trailing_inslot_glue(OI_number,OI_number) ;
		virtual	OI_number		major_leading_space() const ;
		virtual	OI_number		major_stretch() const ;
		virtual	OI_number		major_trailing_space() const ;
		virtual	OI_number		minor_leading_space() const ;
		virtual	OI_number		minor_stretch() const ;
		virtual	OI_number		minor_trailing_space() const ;
		 public:
						OI_lm_row_obj_box(OI_d_tech*,OI_lm_row_col*) ;
		virtual				~OI_lm_row_obj_box();
		virtual	OI_number		nominal_inslot_height() const ;
		virtual	void			nominal_minor_leading_space(OI_bool*,OI_number*) const ;
		virtual	void			nominal_minor_trailing_space(OI_bool*,OI_number*) const ;
		virtual	void			position_slots() ;
		virtual	OI_number		obj_offset_y() const ;
		virtual	void			set_major_stretch(OI_number) ;
		virtual	void			set_minor_stretch(OI_number) ;
		} ;

		class	OI_lm_col_obj_box : public OI_lm_rc_obj_box {					/* obj_box for item in column layout */
				// Note -- a normal glue object is not used for the in-slot glue to save space
				// This does not effect the code generality because the glue is always referenced via special member functions anyway
			OI_number		lf_glue_nom ;						/* nominal size for left glue */
			OI_number		lf_glue_siz ;						/* actual size for left glue */
			OI_number		lf_glue_strtch ;					/* stretch for left glue */
			OI_number		rt_glue_nom ;						/* nominal size for right glue */
			OI_number		rt_glue_siz ;						/* actual size for right glue */
			OI_number		rt_glue_strtch ;					/* stretch for right glue */
		 protected:
		virtual	OI_bool			configure_major_leading_inslot_glue(OI_number,OI_number) ;
		virtual	OI_bool			configure_major_trailing_inslot_glue(OI_number,OI_number) ;
		virtual	OI_number		major_leading_space() const ;
		virtual	OI_number		major_stretch() const ;
		virtual	OI_number		major_trailing_space() const ;
		virtual	OI_number		minor_leading_space() const ;
		virtual	OI_number		minor_stretch() const ;
		virtual	OI_number		minor_trailing_space() const ;
		 public:
						OI_lm_col_obj_box(OI_d_tech*,OI_lm_row_col*) ;
		virtual				~OI_lm_col_obj_box();
		virtual	OI_number		nominal_inslot_width() const ;
		virtual	void			nominal_minor_leading_space(OI_bool*,OI_number*) const ;
		virtual	void			nominal_minor_trailing_space(OI_bool*,OI_number*) const ;
		virtual	OI_number		obj_offset_x() const ;					/* offset of object from OI_lm_obj_box origin */
		virtual	void			position_slots() ;
		virtual	void			set_major_stretch(OI_number) ;
		virtual	void			set_minor_stretch(OI_number) ;
		} ;

		class	OI_lm_row_col : public OI_layout_method	{					/* row or column layout method */
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
		 protected:
		virtual	OI_bool			at_location(OI_lm_box*,OI_number,OI_number) const = 0 ;	/* chk if slot is at psn (col,row) */
		virtual	OI_number		column_psn(const OI_layout_slot*) const = 0 ;		/* find column a slot is in */
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
		virtual	void			move(OI_d_tech*,void*,void*) ;
		virtual	void			remove(OI_d_tech *) ;
		virtual	OI_number		row_psn(const OI_layout_slot*) const = 0 ;		/* find row a slot is in */
		virtual	void			slot_size_change(OI_d_tech*) ;
		virtual	void			space_change(OI_d_tech*) ;
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_row_col(OI_d_tech*) ;
		virtual				~OI_lm_row_col() ;
			void			distribute_space() ;					/* distribute extra space among slots */
			void			find_major_minor(long min, long maj, OI_number pct, OI_number *majp, OI_number *minp) const ;
			OI_lm_box		*find_major(OI_number) const ;				/* get ptr to maj item */
			OI_lm_box		*find_minor(OI_number, OI_number) const ;		/* get ptr to min item */
		virtual	OI_number		find_minor_in_new_major(long, OI_number, OI_number) ;
		virtual	void			find_row_column(long x, long y, OI_number pct, OI_number *cp, OI_number *rp) const = 0 ;
			OI_number		first_major() const ;
			OI_number		first_minor(OI_number) const ;
			OI_lm_rc_box		*get_rc(OI_number) ;					/* get ptr to row/column, allocate if not there */
		virtual	OI_bool			glue_between_major_boxes() const ;			/* OI_yes => glue between maj boxes; default = OI_no */
			OI_number		in_major(OI_number, long, OI_number) const ;		/* chk if posiiton is in a maj item */
			OI_number		in_minor(OI_number, long, OI_number, OI_number) const ;	/* chk if posiiton is in a minor item */
		virtual	OI_lm_rc_box		*major_box(OI_number) = 0 ;				/* get new box for maj item (row in row_major) */
		virtual	OI_lm_glue		*major_glue(OI_number, OI_number=0) const = 0 ;		/* get default glue for maj axis */
		virtual	OI_gravity		major_normal_gravity() const = 0 ;					
		virtual	OI_number		major_offset() const = 0 ;
		virtual	OI_gravity		major_opposite_gravity() const = 0 ;
		virtual	OI_number		major_size() const = 0 ;				/* size of this along maj dimension */
		virtual	long			major_slot_origin(OI_lm_box*) const = 0 ;		/* origin of sp along maj dimension */
		virtual	OI_number		major_slot_size(const OI_layout_slot*) const = 0 ;		/* size of sp along maj dimension */
		virtual	OI_number		major_slot_stretch(const OI_layout_slot*) const = 0 ;
		virtual	OI_size_track		major_track() const = 0 ;				/* maj size track direction */
		virtual	void			min_major_minor_slot_size(const OI_layout_slot*,OI_number*,OI_number*) const = 0 ;
		virtual	OI_gravity		minor_normal_gravity() const = 0 ;
		virtual	OI_number		minor_offset() const = 0 ;
		virtual	OI_gravity		minor_opposite_gravity() const = 0 ;
		virtual	OI_number		minor_size() const = 0 ;				/* size of this along minor dimension */
		virtual	long			minor_slot_origin(OI_lm_box*) const = 0 ;		/* origin of sp along minor dimension */
		virtual	OI_number		minor_slot_size(const OI_layout_slot*) const = 0 ;	/* size of dtp along minor dimension */
		virtual	OI_size_track		minor_track() const = 0 ;				/* minor size track direction */
			OI_number		next_major(OI_number) const ;				/* get number of next maj item */
			OI_number		next_minor(OI_number, OI_number) const ;		/* get number of next min item in given maj item */
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const = 0 ;
		virtual	OI_number		nominal_major_slot_size(const OI_layout_slot*) const = 0 ;
		virtual	OI_number		nominal_major_space() const = 0 ;			/* determine nominal maj spacing */
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const = 0 ;
		virtual	OI_number		nominal_minor_slot_size(const OI_layout_slot*) const = 0 ;
		virtual	OI_number		nominal_minor_space() const = 0 ;			/* determine nominal minor spacing */
			OI_number		prev_major(OI_number) const ;				/* get num of previous maj item */
			OI_number		prev_minor(OI_number, OI_number) const ;		/* get num of previous min item in maj item */
		virtual	void			set_major_minor(OI_number*,OI_number*,OI_number,OI_number) const = 0 ;
		virtual	void			set_slot_origin(OI_layout_slot*,long,long) = 0 ;	/* position object at (min,maj) */
		virtual	void			set_slot_size(OI_layout_slot*,OI_number,OI_number) = 0 ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const = 0 ;
		virtual	OI_lm_convert_geometry	*conversion_specifications(const OI_layout_method*) const ;
		virtual	void			convert_xy_to_geometry(OI_d_tech*,long,long,OI_number,void**,OI_bool*,void**,OI_bool*) const ;
		virtual	OI_bool			exact_conversion(OI_class*) const ;
		virtual	void			force_layout() ;
		virtual	OI_bool			geometry(OI_d_tech*,void**,OI_bool*,void**,OI_bool*) const ;
		virtual	OI_bool			geometry_match(OI_d_tech*,void*,void*) const ;
		virtual	char*			geometry_to_string(OI_d_tech*) const ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) const ;
		virtual	void			new_default_space() ;
		virtual	OI_d_tech		*next_object(OI_d_tech*) const ;
		virtual	OI_d_tech		*previous_object(OI_d_tech*) const ;
		virtual	void			re_layout() ;
		virtual	void			size_change() ;
		virtual	OI_bool			string_to_geometry(const char*,void**,OI_bool*,void**,OI_bool*) const ;	/* get slot layout geometry */
		virtual	OI_layout		type() const = 0 ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_number		first_column(OI_number=OI_undefined) const = 0 ;	// find first column
		virtual	OI_number		first_row(OI_number=OI_undefined) const = 0 ;		// find first row
			OI_number		column_position(OI_d_tech *op) const ;			// find col obj is in
		virtual	OI_number		in_column(OI_number,long,OI_number,OI_number) const = 0 ;	// chk if position is in a column
		virtual	OI_number		in_row(OI_number,long,OI_number,OI_number) const = 0 ;	// chk if position is in a row
		virtual	OI_number		last_row(OI_number=OI_undefined) const = 0 ;		// find last row
		virtual	OI_number		last_column(OI_number=OI_undefined) const = 0 ;		// find last column
		virtual	void			new_column(OI_number,OI_number=OI_undefined) = 0 ;	// open up for new column
		virtual	void			new_row(OI_number,OI_number=OI_undefined) = 0 ;		// open up for new row
		virtual	OI_number		next_column(OI_number,OI_number=OI_undefined) const = 0 ;	// find next column
		virtual	OI_number		next_row(OI_number,OI_number=OI_undefined) const = 0 ;	// find next row
		virtual	OI_number		prev_column(OI_number,OI_number=OI_undefined) const = 0 ;	// find previous column
		virtual	OI_number		prev_row(OI_number,OI_number=OI_undefined) const = 0 ;	// find previous row
			OI_number		row_position(OI_d_tech *op) const ;			// find row obj is in
		} ;

		class	OI_lm_row : public OI_lm_row_col	{					// row maj layout method
		 public:
		static	OI_class		*clsp ;							// ptr to class object for this layout method
		 private:
		 protected:
		virtual	OI_number		column_psn(const OI_layout_slot *sp) const ;
		virtual	OI_number		row_psn(const OI_layout_slot *sp) const ;
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_row(OI_d_tech *dtp) : OI_lm_row_col(dtp) { }
		virtual				~OI_lm_row() ;
		virtual	OI_bool			at_location(OI_lm_box*,OI_number,OI_number) const ;
		virtual	void			find_row_column(long,long,OI_number,OI_number*,OI_number*)const ;
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
		virtual	OI_lm_glue		*major_glue(OI_number, OI_number=0) const ;
		virtual	OI_gravity		major_normal_gravity() const ;					
		virtual	OI_number		major_offset() const ;
		virtual	OI_gravity		major_opposite_gravity() const ;
		virtual	OI_number		major_size() const ;
		virtual	long			major_slot_origin(OI_lm_box*) const ;
		virtual	OI_number		major_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		major_slot_stretch(const OI_layout_slot*) const ;
		virtual	OI_size_track		major_track() const ;
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		virtual	void			min_major_minor_slot_size(const OI_layout_slot*,OI_number*,OI_number*) const ;
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*,OI_d_tech*) ;				/* get new box for minor item */
		virtual	OI_gravity		minor_normal_gravity() const ;
		virtual	OI_number		minor_offset() const ;
		virtual	OI_gravity		minor_opposite_gravity() const ;
		virtual	OI_number		minor_size() const ;
		virtual	long			minor_slot_origin(OI_lm_box*) const ;
		virtual	OI_number		minor_slot_size(const OI_layout_slot*) const ;
		virtual	OI_size_track		minor_track() const ;
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_space() const ;
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_minor_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_minor_space() const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	void			position_slots() ;
		virtual	void			set_major_minor(OI_number*,OI_number*,OI_number,OI_number) const ;
		virtual	void			set_slot_origin(OI_layout_slot*,long,long) ;			/* position object at (minor,major) */
		virtual	void			set_slot_size(OI_layout_slot*,OI_number,OI_number) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual OI_number		bottom_space(OI_d_tech*) const ;
		virtual	OI_class		*class_object() const ;
		virtual	OI_number		first_row(OI_number= OI_undefined) const ;
		virtual	OI_number		first_column(OI_number) const ;
		virtual	OI_number		in_row(OI_number r, long p, OI_number, OI_number pct) const ;
		virtual	OI_number		in_column(OI_number c, long p, OI_number r, OI_number pct) const ;
		virtual	void			insert(OI_d_tech *, void*, void*) ;
		virtual	OI_number		last_row(OI_number) const ;
		virtual	OI_number		last_column(OI_number) const ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) const ;
		virtual	OI_number		next_row(OI_number r, OI_number= OI_undefined) const ;
		virtual	OI_number		next_column(OI_number c, OI_number r) const ;
		virtual	void			new_row(OI_number,OI_number= OI_undefined) ;
		virtual	void			new_column(OI_number,OI_number) ;
		virtual	OI_number		prev_row(OI_number,OI_number=OI_undefined) const ;
		virtual	OI_number		prev_column(OI_number,OI_number) const ;
		virtual OI_number		right_space(OI_d_tech*) const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		} ;

		class	OI_lm_row_aligned_obj_box : public OI_lm_row_obj_box {				/* obj_box for item in row aligned layout */
		 protected:
		virtual	OI_number		minor_leading_space() const ;
		 public:
						OI_lm_row_aligned_obj_box(OI_d_tech*,OI_lm_row_col*) ;
		virtual				~OI_lm_row_aligned_obj_box() ;
		virtual	OI_bool			gravity_space_sizetrack_adjust(OI_bool*,OI_bool*) ;
		} ;

		class	OI_lm_row_aligned_box : public OI_lm_row_box	{	/* maj item for any row-aligned layout */
		 public:
						OI_lm_row_aligned_box() {}
		virtual				~OI_lm_row_aligned_box() ;
			void			align(OI_number) ;		/* align object in first column of row */
		virtual	OI_bool			is_row_aligned_box() const ;
		} ;

		class	OI_lm_row_aligned : public OI_lm_row	{
			OI_number		mx_sp;
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
			OI_number		compute_max_left_space() ;
		 protected:
		virtual	void			space_change(OI_d_tech*) ;
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_row_aligned(OI_d_tech *dtp) : OI_lm_row(dtp) { mx_sp=0; }
		virtual				~OI_lm_row_aligned() ;
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
			OI_number		max_space() const		{ return(mx_sp); }
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*,OI_d_tech*) ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual	OI_class		*class_object() const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		};

		class	OI_lm_column : public OI_lm_row_col	{					/* row maj layout method */
		 public:
		static	OI_class		*clsp ;							/* ptr to class object for this layout method */
		 private:
		 protected:
		virtual	OI_number		column_psn(const OI_layout_slot *sp) const ;
		virtual	OI_number		row_psn(const OI_layout_slot *sp) const ;
		 public:
		//-------------------------------------------------------------------------------------------------		
		//		
		//	RESTRICTED MEMBER FUNCTIONS
		//		Functions in this section are not documented in the programmer's manual and are
		//		restricted to internal use by the toolkit.
		//		Functions not contained in user documentation are subject to change without notice
		//		and should never be used by toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
						OI_lm_column(OI_d_tech *dtp) : OI_lm_row_col(dtp) {}
		virtual				~OI_lm_column() ;
		virtual	OI_bool			at_location(OI_lm_box*,OI_number,OI_number) const ;
		virtual	void			find_row_column(long,long,OI_number,OI_number*,OI_number*)const ;
		virtual	OI_lm_rc_box		*major_box(OI_number) ;
		virtual	OI_lm_glue		*major_glue(OI_number, OI_number=0) const ;
		virtual	OI_gravity		major_normal_gravity() const ;
		virtual	OI_number		major_offset() const ;
		virtual	OI_gravity		major_opposite_gravity() const ;
		virtual	OI_number		major_size() const ;
		virtual	long			major_slot_origin(OI_lm_box*) const ;
		virtual	OI_number		major_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		major_slot_stretch(const OI_layout_slot*) const ;
		virtual	OI_size_track		major_track() const ;
		virtual	void			min_major_minor_slot_size(const OI_layout_slot*,OI_number*,OI_number*) const ;
		virtual	OI_lm_box		*minor_box(OI_lm_rc_box*, OI_d_tech*) ;
		virtual	OI_gravity		minor_normal_gravity() const ;
		virtual	OI_number		minor_offset() const ;
		virtual	OI_gravity		minor_opposite_gravity() const ;
		virtual	OI_number		minor_size() const ;
		virtual	long			minor_slot_origin(OI_lm_box*) const ;
		virtual	OI_number		minor_slot_size(const OI_layout_slot*) const ;
		virtual	OI_size_track		minor_track() const ;
		virtual	OI_number		nominal_major_leading_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_major_space() const ;
		virtual	OI_number		nominal_major_trailing_inslot_space(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_minor_slot_size(const OI_layout_slot*) const ;
		virtual	OI_number		nominal_minor_space() const ;
		virtual	void			nominal_size(OI_number*,OI_number*) const ;
		virtual	void			position_slots() ;
		virtual	void			set_major_minor(OI_number*,OI_number*,OI_number,OI_number) const ;
		virtual	void			set_slot_origin(OI_layout_slot*,long,long) ;
		virtual	void			set_slot_size(OI_layout_slot*,OI_number,OI_number) ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	OVERRIDES OF DOCUMENTED PARENT MEMBER FUNCTIONS	
		//		Functions in this section are documented in the programmer's manual under the
		//		parent(s) of this object and are also available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		virtual OI_number		bottom_space(OI_d_tech*)const ;
		virtual	OI_class		*class_object() const ;
		virtual	OI_number		first_row(OI_number) const ;
		virtual	OI_number		first_column(OI_number= OI_undefined) const ;
		virtual	OI_number		in_row(OI_number r, long p, OI_number, OI_number pct) const ;
		virtual	OI_number		in_column(OI_number c, long p, OI_number r, OI_number pct) const ;
		virtual	void			insert(OI_d_tech*,void*,void*) ;
		virtual	OI_number		last_row(OI_number) const ;
		virtual	OI_number		last_column(OI_number) const ;
		virtual	void			min_outside_size(OI_number,OI_number,OI_number*,OI_number*) const ;
		virtual	OI_number		next_row(OI_number r, OI_number) const ;
		virtual	OI_number		next_column(OI_number, OI_number= OI_undefined) const ;
		virtual	void			new_row(OI_number,OI_number) ;
		virtual	void			new_column(OI_number,OI_number= OI_undefined) ;
		virtual	OI_number		prev_row(OI_number,OI_number) const ;
		virtual	OI_number		prev_column(OI_number,OI_number) const ;
		virtual OI_number		right_space(OI_d_tech*)const ;
		virtual	OI_layout		type() const ;
		//-------------------------------------------------------------------------------------------------		
		//		
		//	DOCUMENTED MEMBER FUNCTIONS	
		//		Functions below this point are documented in the programmer's manual under this
		//		object and are available to the toolkit users.
		//		Please maintain alphabetical order to facilitate releases and documentation.
		//
		//-------------------------------------------------------------------------------------------------		
		static	OI_layout_method	*make_minimal(OI_d_tech*,OI_minimal_type) ;
		} ;

#endif /* OI_lmrc_H */
