'\"
'\" Copyright 1994 by AT&T Bell Laboratories.
'\"
'\" Permission to use, copy, modify, and distribute this software
'\" and its documentation for any purpose and without fee is hereby
'\" granted, provided that the above copyright notice appear in all
'\" copies and that both that the copyright notice and warranty
'\" disclaimer appear in supporting documentation, and that the
'\" names of AT&T Bell Laboratories any of their entities not be used
'\" in advertising or publicity pertaining to distribution of the
'\" software without specific, written prior permission.
'\"
'\" AT&T disclaims all warranties with regard to this software, including
'\" all implied warranties of merchantability and fitness.  In no event
'\" shall AT&T be liable for any special, indirect or consequential
'\" damages or any damages whatsoever resulting from loss of use, data
'\" or profits, whether in an action of contract, negligence or other
'\" tortuous action, arising out of or in connection with the use or
'\" performance of this software.
'\"
'\"
.so man.macros
.HS blt_watch cmds
.BS
.SH NAME
blt_watch \- call Tcl procedures before and after each command
.SH SYNOPSIS
\fBblt_watch create\fR \fIname\fR ?\fIoptions\fR?
.sp
\fBblt_watch activate\fR \fIname\fR
.sp
\fBblt_watch deactivate\fR \fIname\fR
.sp
\fBblt_watch delete\fR \fIname\fR
.sp
\fBblt_watch configure\fR \fIname\fR ?\fIoptions\fR
.sp
\fBblt_watch info\fR \fIname\fR
.sp
\fBblt_watch names\fR 
.BE
.SH DESCRIPTION
.PP
This command arranges for Tcl procedures to be called before 
and/or after each the execution of each Tcl command.  This command
may be useful in the logging, profiling, or tracing of Tcl code.
.SH "WATCH COMMANDS"
The following commands are available for the \fBblt_watch\fR:
.TP
\fBblt_watch activate \fIname\fR 
Activates the watch, causing Tcl commands the be traced to the
maximum depth selected.
.TP
\fBblt_watch create \fIname\fR ?\fIoptions\fR?...
Creates a new watch \fIname\fR. It's an error if another watch 
\fIname\fR already exists and an error message will be returned.
\fIOptions\fR may have any of the values accepted by the 
\fBblt_watch configure\fR command.
This command returns the empty string.  
.TP
\fBblt_watch configure \fIname\fR ?\fIoptions...\fR?
Queries or modifies the configuration options of the watch \fIname\fR.
\fIName\fR is the name of a watch.
\fIOptions\fR may have any of the following values:
.RS
.TP
\fB\-active \fIboolean\fR
Specifies if the watch is active.
By default, watches are active when created.
.TP
\fB\-postcmd \fIstring\fR
Specifies a Tcl procedure to be called after each
Tcl command.  \fIString\fR is name of a Tcl procedure and optionally
any extra arguments to be passed to it.  Five arguments are appended:
1) the current level 2) the command string 3) a list containing the
command after substitutions and split into words 4) the return code
of the previous Tcl command, and 5) the results of the previous command.
The return status of the postcmd procedure is always ignored.
.TP
\fB\-precmd \fIstring\fR
Specifies a Tcl procedure to be called before each
Tcl command.
\fIString\fR is name of a Tcl procedure and optionally
any extra arguments to be passed to it.  Three arguments are appended:
1) the current level 2) the command string, and  3) a list containing the
command after substitutions and split into words.
The return status of the precmd procedure is always ignored.
.TP
\fB\-maxlevel \fInumber\fR
Specifies the maximum evaluation depth to watch Tcl commands.
The default maximum level is 10000.
.TP
\fBblt_watch deactivate \fIname\fR 
Deactivates the watch, causing Tcl commands to be no longer traced.
.TP
\fBblt_watch info \fIname\fR 
Returns the configuration information associated with the 
watch \fIname\fR.  \fIName\fR is the name of a watch.
.TP
\fBblt_watch names\fR ?\fIhow\fR?
Lists the names of the watches for a given state.
\fIHow\fR may be one of the following: \fCactive\fR, \fCidle\fR, 
or \fCignore\fR.  If no \fIhow\fR argument is specified all, watches are
listed.
.RE
.PP
If no \fIlevel\fR argument is given, the current level is printed.
.SH EXAMPLE
The following example use \fBblt_watch\fR to trace Tcl commands 
(printing to standard error) both before and after they are executed. 
.DS 
\fC
proc preCmd { level command argv } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $command"
}

proc postCmd { level command argv retcode results } {
    set name [lindex $argv 0]
    puts stderr "$level $name => $argv\n<= ($retcode) $results"
}

blt_watch create trace \
	-postcmd postCmd -precmd preCmd
\fR
.DE
.SH KEYWORDS
debug
