'\" t
'\" $XFree86: mit/server/ddx/x386/XF86kbd.man,v 2.2 1994/02/27 05:17:26 dawes Exp $
'\"
.TH XFree86kbd 1 "Version 2.1"  "XFree86"
.SH NAME
XFree86kbd - Description of keymapping capabilities of XFree86 servers
.SH DESCRIPTION
.PP
The XFree86 servers, as well as the Xlib, support some special features for
multinational keyboard support.  These features make defining modifier
keys much simpler (alleviating the need for using
.I xmodmap(1)
in many cases).  They also make the generation of non-ASCII Latin-1
character much simpler.
.PP
This is accomplished by allowing several modifier keys to be redefined
in the server's
.I Xconfig
file.  The functions that can be assigned include:
.TP 12
.I Meta
Makes a key function as a Meta key.  The Meta modifier is interpreted
in a client-dependent fashion (e.g., xterm uses it to generate characters
characters with the high-order bit set).
.TP 12
.I Compose
Causes a <Multi_key> keysym to be sent.  In combination with the
changes to the X library, Compose followed by two other keysyms causes
non-ASCII Latin-1 keysyms to be sent to the client program.
.TP 12
.I "Mode Shift"
Makes a key function as a Mode_switch key.  This key behaves like a
"shift" key that causes causes the X library to use the 3rd and 4th
columns of the keymap (as opposed to the 1st and 2nd column).  This is
useful for multi-national keyboards.
.TP 12
.I "Mode Lock"
Works like a shift-lock for the Mode Shift functionality described above.
.SH "DEFINING MODIFIER KEYS"
.PP
The keys available to be redefined from the Xconfig file are the Left
and Right Alt keys (the Alt Graphics key is synonymous with the Right
Alt key), the Scroll Lock key, and the Right Control key.  The functions
that can be assigned are Meta, Compose, Mode Shift, Mode Lock, Scroll Lock,
and Compose.  The key definitions are put in the Xconfig file in the
Keyboard Configuration section (see
.IR Xconfig(4/5) ).
.PP
.ne 1.5i
The default definitions for the server are as follows:
.sp
.TS
center, tab(!);
lw(1.25i) l.
LeftAlt!Meta
RightAlt!Meta
ScrollLock!Compose
RightCtl!Control
.TE
.PP
This definition is useful for users of US keyboards, who have only occasional
need for non-ASCII characters.  The following definitions would likely be 
more useful in the international arena:
.sp
.TS
center, tab(!);
lw(1.25i) l.
LeftAlt!Meta
RightAlt!ModeShift
RightCtl!Compose
ScrollLock!ModeLock
.TE
.SH "COMPOSE KEY CHARACTER GENERATION"
.PP
The Compose key provides a simple way to generate non-ASCII Latin-1 keysyms
without having to actually redefine the keymap via
.I xmodmap(1).
This is done by using multiple keystokes to generate the actual keysym.
The Compose (actually, the keysym <Multi_key>) precedes the other
keysyms, and a modified Xlib generates the correct final keysym.  When
you press the Compose key, the Scroll Lock LED on the PC keyboard will
light, and it will go out when the full group of keystrokes is completed.  
You can abort a Compose sequence by pressing the Escape key at any time.
.TP 8
.B "NOTE:"
You
.B must
do
.I "stty -istrip"
and possibly also
.I "stty -parity"
in an xterm window for the extended characters to show up.  If you do not,
the high-order bit from the generated character will be stripped off, and it
will not be displayed properly.
.PP
The table at the end of the manual page shows each Compose group, and the 
final keysym generated.  The keysyms in each group can be sent in any order 
(note that keysym names are given as expected by 
.IR xmodmap(1) ).
.SH "SEE ALSO"
XFree86(1), Xconfig(4/5), xmodmap(1)
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
space!space!nobreakspace
!quotdbl!diaeresis
!asterisk!degree
 
exclam!exclam!exclamdown
!asciicircum!brokenbar
!S!section!s!section
!P!paragraph!p!paragraph
 
quotedbl!quotedbl!diaeresis
!A!Adiaeresis!a!adiaeresis
!E!Ediaeresis!e!ediaeresis
!I!Idiaeresis!i!idiaeresis
!O!Odiaeresis!o!odiaeresis
!U!Udiaeresis!u!udiaeresis
!!!y!ydiaeresis
 
apostrophe!apostrophe!acute
!A!Aacute!a!aacute
!E!Eacute!e!eacute
!I!Iacute!i!iacute
!O!Oacute!o!oacute
!U!Uacute!u!uacute
!Y!Yacute!y!yacute
 
parenleft!parenleft!bracketleft
!minus!braceleft
 
parenright!parenright!bracketright
!minus!braceright

asterisk!space!degree
!A!Aring!a!aring

plus!plus!numbersign
!minus!plusminus

comma!comma!cedilla
!C!Ccedilla!c!ccedilla
.TE
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
minus!parenleft!braceleft
!parenright!braceright
!minus!hyphen
!L!sterling!l!sterling
!Y!yen!y!yen
!comma!notsign
!asciicircum!macron
!plus!plusminus
!D!ETH!d!eth
!colon!division

period!asciicircum!periodcentered

slash!slash!backslash!less!backslash
!asciicircum!bar
!C!cent!c!cent
!U!mu!u!mu
!O!Ooblique!o!ooblique

0!X!currency!x!currency
!S!section!s!section
!C!copyright!c!copyright
!R!registered!r!registered
!asciicircum!degree

1!asciicircum!onesuperior
!4!onequarter
!2!onehalf

2!asciicircum!twosuperior

3!asciicircum!threesuperior
!4!threequarters

colon!minus!division

less!slash!backslash
!less!guillemotleft

equal!L!sterling!l!sterling
!Y!yen!y!yen

greater!greater!guillemotright

question!question!questiondown
.TE
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
A!A!at!a!at
!underscore!ordfeminine
!grave!Agrave
!apostrophe!Aacute
!asciicircum!Acircumflex
!asciitilde!Atilde
!quotedbl!Adiaeresis
!asterisk!Aring
!E!AE

C!slash!cent!bar!cent
!O!copyright!o!copyright
!comma!Ccedilla

D!minus!ETH

E!grave!Egrave
!apostrophe!Eacute
!asciicircum!Ecircumflex
!quotedbl!Ediaeresis

I!grave!Igrave
!apostrophe!Iacute
!asciicircum!Icirumflex
!quotedbl!Idiaeresis

L!minus!pound!equal!pound

N!asciitilde!Ntilde

O!X!currency!x!currency
!S!section!s!section
!C!copyright!c!copyright
!R!registered!r!registered
!underscore!masculine
!grave!Ograve
!apostrophe!Oacute
!asciicircum!Ocircumflex
!asciitilde!Otilde
!quotedbl!Odiaeresis
!slash!Ooblique

P!exclam!paragraph

R!0!registered
!O!registered!o!registered
.TE
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
S!exclam!section!0!section
!O!section!o!section
!S!ssharp

T!H!THORN

U!grave!Ugrave
!apostrophe!Uacute
!asciicircum!Ucircumflex
!quotedbl!Udiaeresis

X!0!currency
!O!currency!o!currency

Y!minus!yen!equal!yen
!apostrophe!Yacute

asciicircum!slash!bar
!exclam!brokenbar
!minus!macron
!underscore!macron
!0!degree
!1!onesuperior
!2!twosuperior
!3!threesuperior
!period!periodcentered
!A!Acircumflex!a!acircumflex
!E!Ecircumflex!e!ecircumflex
!I!Icircumflex!i!icircumflex
!O!Ocircumflex!o!ocircumflex
!u!Ucircumflex!u!ucircumflex

underscore!A!ordfeminine!a!ordfeminine
!asciicircum!macron
!O!masculine!o!masculine

grave!A!Agrave!a!agrave
!E!Egrave!e!egrave
!I!Igrave!i!igrave
!O!Ograve!o!ograve
!U!Ugrave!u!ugrave
.TE
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
a!A!at!a!at
!underscore!ordfeminine
!grave!agrave
!apostrophe!aacute
!asciicircum!acircumflex
!asciitilde!atilde
!quotedbl!adiaeresis
!asterisk!aring
!e!ae

c!slash!cent!bar!cent
!0!copyright
!O!copyright!o!copyright
!comma!ccedilla

d!minus!eth

e!grave!egrave
!apostrophe!eacute
!asciicircum!ecircumflex
!quotedbl!ediaeresis

i!grave!igrave
!apostrophe!iacute
!asciicircum!icircumflex
!quotedbl!idiaeresis

l!minus!pound!equal!pound

n!asciitilde!ntilde

o!X!currency!x!currency
!C!copyright!c!copyright
!R!registered!r!registered
!S!section!s!section
!underscore!masculine
!grave!ograve
!apostrophe!oacute
!asciicircum!ocircumflex
!asciitilde!otilde
!quotedbl!odieresis
!slash!oslash

p!exclam!paragraph

r!0!registered
!O!registered!o!registered
.TE
.bp
.TS
center, tab(!);
l l l | l l
l l l | l l
l l l | l l.
First!Second!Final!Second!Final
Keysym!Keysym!Keysym!Keysym!Keysym
_
s!exclam!section!0!section
!O!section!o!section
!s!ssharp

t!h!eth

u!grave!ugrave
!apostrophe!uacute
!asciicircum!ucircumflex
!quotedbl!udiaeresis

x!0!currency
!O!currency!o!currency
!x!multiply

y!minus!yen!equal!yen
!apostrophe!yacute
!quotedbl!ydiaeresis

bar!C!cent!c!cent
!bar!brokenbar

asciitilde!A!Atilde!a!atilde
!N!Ntilde!n!ntilde
!O!Otilde!o!otilde
.TE
