/*
 * Copyright (c) 1987, 1988, 1989, 1990, 1991 Stanford University
 * Copyright (c) 1991 Silicon Graphics, Inc.
 *
 * Permission to use, copy, modify, distribute, and sell this software and 
 * its documentation for any purpose is hereby granted without fee, provided
 * that (i) the above copyright notices and this permission notice appear in
 * all copies of the software and related documentation, and (ii) the names of
 * Stanford and Silicon Graphics may not be used in any advertising or
 * publicity relating to the software without the specific, prior written
 * permission of Stanford and Silicon Graphics.
 * 
 * THE SOFTWARE IS PROVIDED "AS-IS" AND WITHOUT WARRANTY OF ANY KIND, 
 * EXPRESS, IMPLIED OR OTHERWISE, INCLUDING WITHOUT LIMITATION, ANY 
 * WARRANTY OF MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE.  
 *
 * IN NO EVENT SHALL STANFORD OR SILICON GRAPHICS BE LIABLE FOR
 * ANY SPECIAL, INCIDENTAL, INDIRECT OR CONSEQUENTIAL DAMAGES OF ANY KIND,
 * OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR PROFITS,
 * WHETHER OR NOT ADVISED OF THE POSSIBILITY OF DAMAGE, AND ON ANY THEORY OF 
 * LIABILITY, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE 
 * OF THIS SOFTWARE.
 */

#ifdef __GNUG__
#pragma interface
#endif

/*
 * LRMarker - mark text region
 */

#ifndef iv_lrmarker_h
#define iv_lrmarker_h

#include <InterViews/monoglyph.h>

class Color;

class LRMarker : public MonoGlyph {
public:
    LRMarker(Glyph* body, const Color* overlay, const Color* underlay);
    virtual ~LRMarker();

    void bound(Coord left, Coord bottom, Coord right, Coord top);
    void mark(Coord x1, Coord y1, Coord h1, Coord x2, Coord y2, Coord h2);
    void unmark();

    virtual void allocate(Canvas*, const Allocation&, Extension&);
    virtual void draw(Canvas*, const Allocation&) const;
    virtual void undraw();
private:
    Canvas* canvas_;
    const Color* overlay_;
    const Color* underlay_;
    boolean marked_;
    boolean bounded_;
    Coord left_, right_, bottom_, top_;
    Coord x1_, y1_, h1_;
    Coord x2_, y2_, h2_;
};

#endif
