/*
 *
 * Definitions for mount interface. This describes the in the kernel build 
 * linkedlist with mounted filesystems.
 *
 * Authors: Marco van Wieringen <v892273@si.hhs.nl> <mvw@mercury.mcs.nl.mugnet.org>
 *          Edvard Tuinder <v892231@si.hhs.nl> <ed@delirium.nl.mugnet.org>
 *
 * Version: $Id: mount.h,v 1.1 1994/01/09 10:41:52 mvw Exp mvw $
 *
 */
#ifndef _LINUX_MOUNT_H
#define _LINUX_MOUNT_H

#define QF_OPENING  0x01
#define QF_CLOSING  0x02

struct vfsmount
{
   dev_t mnt_dev;                      /* Device this applies to */
   char *mnt_devname;                  /* Name of device e.g. /dev/dsk/hda1 */
   char *mnt_dirname;                  /* Name of directory mounted on */
   char  mnt_flags;                    /* Flags of this device see above */
   struct super_block *mnt_sb;         /* pointer to superblock */
   struct file *mnt_quotas[MAXQUOTAS]; /* fp's to quotafiles */
   time_t mnt_iexp[MAXQUOTAS];         /* expiretime for inodes */
   time_t mnt_bexp[MAXQUOTAS];         /* expiretime for blocks */
   struct vfsmount *mnt_next;          /* pointer to next in linkedlist */
};

struct vfsmount *lookup_vfsmnt(dev_t dev);

#endif /* _LINUX_MOUNT_H */
