/*
 * newman.c
 *
 * Copyright (C), 1994, Graeme W. Wilford. (Wilf.)
 *
 * You may distribute under the terms of the GNU General Public
 * License as specified in the file COPYING that comes with the man
 * distribution.
 *
 * These are either newly added routines or completely re-written pieces of
 * code inspired by routines in man.c
 *
 * Mon May  2 11:14:28 BST 1994 Wilf. (G.Wilford@ee.surrey.ac.uk)
 */

#define MAN_MAIN        /* to not define config_file */
#define MANPATH_MAIN    /* to not define *std_sections[] */

#include <dirent.h>
#include <unistd.h>
#include <sys/stat.h>

#include <string.h>
#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "mydbm.h"
#include "newman.h"
#include "gripes.h"
#include "util.h"
#include "statdir.h"
#include "dbver.h"

int man (char *name);

extern int debug;
extern char *prognam;
extern short db;
extern MYDBM_FILE dbf;
extern char *database;
extern short findall;

/*
 * Change a name of the form ...man/man1/name.1 to ...man/cat1/name.1
 * 
 * OR for FSSTND, change name of form 	/usr/.../man/man1/name.1 to 
 *				   	/var/catman/.../cat1/name.1[.Z]
 */

char *convert_name (char *name)
{
	char *to_name, *t1;
	char *t2 = NULL;
	size_t len;

#ifdef FSSTND
	char *newto_name;
	char *t3 = NULL;
#endif


#ifdef DO_COMPRESS
	len = strlen (name) + sizeof COMPRESS_EXT;
	to_name = (char *) malloc (len);
	if (to_name == NULL)
		gripe_alloc (len, "to_name");
	strcpy (to_name, name);
	strcat (to_name, COMPRESS_EXT);
#else
	to_name = strdup (name);
#endif

	if ( (t1 = strrchr (to_name, '/')) != NULL){

		*t1 = '\0';
		t2 = strrchr (to_name, '/');

		if (t2 == NULL)
			gripe_converting_name (name);

		/*  
		 * How to deal with -M arg and non-conforming paths 
		 * 
		 * Make sure that the manpath is FSSTND conformant, if not, 
		 * we can't be either - do the old thing instead.
		 */

#ifdef FSSTND
		if ( strncmp (to_name, MAN_ROOT, sizeof MAN_ROOT - 1) == 0){
		
			*t2 = '\0';
			t3 = strrchr (to_name, '/');
			*t2 = '/';
		}
#endif
		*t1 = '/';
	}

	*(t2 + 1) = 'c';
	*(t2 + 3) = 't';

#ifdef FSSTND

	if (t3 != NULL){
		newto_name = (char *) malloc (strlen(to_name) + 1 +
		  sizeof CAT_ROOT - sizeof MAN_ROOT "/man");
		strcpy (newto_name, CAT_ROOT);
		*t3 = '\0';
		strcat (newto_name, to_name + sizeof MAN_ROOT - 1);
		*t3 = '/';
		strcat (newto_name, t2);
	}
	else	
		/* again -- do the old thing */
		newto_name = strdup(to_name);
	
	free (to_name);

	if (debug)
		fprintf (stderr, "newto_name in convert_name () is %s\n", newto_name);

	return newto_name;
#else
	if (debug)
		fprintf (stderr, "to_name in convert_name () is %s\n", to_name);

	return to_name;
#endif
}

#ifdef FSSTND

char *catpath (char *path)
{
	/*  
	 * deal with -M . and other oddities where we don't want 
	 * to convert the name, i.e. non FSSTND conformant. 
	 */

	if (strncmp (path, MAN_ROOT, sizeof MAN_ROOT - 1) != 0)
		return path;
	else {
		char *newpath, *t1;
		
		newpath = (char *) malloc (strlen (path) + 1 + 
		  sizeof CAT_ROOT - sizeof MAN_ROOT "/man" );

		strcpy (newpath, CAT_ROOT);
		*(t1 = strrchr (path, '/')) = '\0';

		strcpy (newpath + sizeof CAT_ROOT - 1
		  , path + sizeof MAN_ROOT - 1);

		*t1 = '/';
	
	/*	if (debug)
			fprintf(stderr, "catpath: %s -> %s\n", path, newpath);
	 */		
		return newpath;
	}
}
#endif

/*
 * recursive function which finds the ultimate source file by following
 * any ".so filename" directives in the first line of the man pages.
 */
char *ult_src(char *name, char *path)
{
	/* static to save memory */
	static FILE *fp;
	static short val;
	static char *ult;

	/* must be static */
	static char basename[512];
	static short recurse;
	static size_t len;

	if ((fp = fopen (name, "r")) == NULL){
		fprintf(stderr,
		  "%s: ult_src:\n    Problem with ultimate src file: "
		  , prognam);
		perror(name); 
		return NULL;
	}

	if (recurse == 0){

		/* do some initialization */

		strcpy(basename, path);
		strcat(basename, "/");
		len = strlen(basename);
		if (debug)
			fprintf(stderr, "ult_src: File %s\n", name);
	}
	else if (recurse == 10){	
		fprintf(stderr, "%s: ult_src:\n    Problem with ultimate src file: "
		  " I guess that there is some .so recursion, check %s\n",
		  prognam, name);
		return NULL;
	}
		
	val = fscanf(fp, ".so %512s", basename + len);
	fclose(fp);

	if (val == 1){
	
		/* keep on looking... */

		if (debug)
			fprintf(stderr, "ult_src: points to %s\n", basename);

		recurse++;
		ult = ult_src(basename, path);
		recurse--;

		return ult;
	}
	else
		/* 
		 * we have it. 
		 * The file is either the src (val == 0) 
		 * or is zero in length (val == EOF)
		 * - in which case it is a stray cat place holder.
		 */
		
		return strdup(name);
}

/*
 * Handle the whatis or apropos option.  Cheat by using another program.
 */
void do_extern (char *prog, char *name)
{
	size_t len;
	char *command;

	len = strlen (prog) + strlen (name) + 2;

	if ((command = (char *) malloc (len)) == NULL)
		gripe_alloc (len, "command");

	sprintf (command, "%s %s", prog, name);

	(void) do_system_command (command);

	free (command);
}

short do_manual(char *nextarg)
{
	short status = 0;
	char *db_list;
	char *c1;

	/* 
	 * get a : list of possible user databases, not including the
	 * global db.
	 */
	 
	db_list = get_userdb_list();

	if (db_list != NULL){
		if (debug)
			fprintf(stderr, "\nuser database list - %s\n", db_list);
		if (setreuid(geteuid(), getuid()) == -1){
			fputs("Problems changing privs to match yours\n",
			  stderr);
			exit(1);
		}
		while( (c1 = strrchr(db_list, ':')) != NULL){
			*c1 = '\0';
			database = ++c1;
			status += find_manual_page(nextarg, 0);

			if (status && !findall)
				return status;
		}
		database = db_list;
		status += find_manual_page(nextarg, 0);
		free(--db_list); /* see get_db_list() */

		if (status && !findall)
			return status;
			
		if (setreuid(geteuid(), getuid()) == -1){
			fputs("Problems reverting to setuid privs.\n", stderr);
			exit(1);
		}
	} else 
		if (debug)
			fputs("no user database list\n", stderr);
	database = DB;
	status += find_manual_page(nextarg, 1);

	return status;
}

short find_manual_page(char *nextarg, short globalman)
{
	short status = 0;
	int ver;
	
	status += man (nextarg);
	db--;

	if (findall || !status ){

		short amount = 0;

		if (globalman) {
			if ( (dbf = MYDBM_RWOPEN(database)) == NULL){
				fprintf(stderr, "%s: find_manual_page: ", prognam);
				perror(database);
				exit(1);
			}

			dbver_rd(dbf);
			
		} else {
			if ( (dbf = MYDBM_CRWOPEN(database)) == NULL){
				fprintf(stderr, "%s: find_manual_page: ", prognam);
				perror(database);
				exit(1);
			}

			if ( (ver = dbver(dbf)) == 1) {
				MYDBM_CLOSE(dbf);
				if ( (dbf = MYDBM_OPEN(database)) == NULL){
					fprintf(stderr, "%s: find_manual_page: ", prognam);
					perror(database);
					exit(1);
				}
				dbver_wr(dbf);
			} else if (ver == -1) {
				dbver_wr(dbf);
			}

		}


		amount = check_mandirs(globalman);
		
		MYDBM_CLOSE(dbf);

		if (amount){
			status += man(nextarg);
			db--;
		}
	}
	return status;
}
