#ifndef _FTAPE_RW_H
#define _FTAPE_RW_H

/*
 * Copyright (C) 1993,1994 Bas Laarhoven.

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License as published by
the Free Software Foundation; either version 2, or (at your option)
any later version.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; see the file COPYING.  If not, write to
the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.

 *
 $Source: /usr/src/distr/ftape-0.9.10/RCS/ftape-rw.h,v $
 $Author: bas $
 *
 $Revision: 1.20 $
 $Date: 1994/02/20 15:26:55 $
 $State: Alpha $
 *
 *      This file contains the definitions for the read and write
 *      functions for the QIC-117 floppy-tape driver for Linux.
 *
 */

#include "fdc-io.h"
#include "kernel-interface.h"

#define EMPTY_SEGMENT   (0xffffffff)
#define FAKE_SEGMENT   (0xfffffffe)

#define GET2( address, offset) *(short*)(address + offset)
#define GET4( address, offset) *(long*)(address + offset)
#define PUT2( address, offset, value) *(short*)(address + offset) = value
#define PUT4( address, offset, value) *(long*)(address + offset) = value

enum runner_status_enum {
  idle = 0,
  running,
  do_abort,
  aborting,
  logical_eot, 
  end_of_tape,
  buffer_overrun,
  buffer_underrun,
};        

typedef struct {
  byte* address;
  volatile buffer_state_enum status;
  volatile byte* ptr;
  volatile unsigned bytes;
  volatile unsigned segment_id;
  volatile unsigned long crc_error_map;
  volatile unsigned long bad_sector_map;
  volatile unsigned retry;
  volatile unsigned int skip;
  volatile unsigned data_offset;
  volatile unsigned sector_offset;
  volatile unsigned sector_count;
  volatile unsigned remaining;
  volatile unsigned start_offset;
  volatile unsigned next_segment;
  volatile byte head;
  volatile byte cyl;
  volatile byte sect;
} buffer_struct;

typedef struct {
  int active;
  int error;
  int offset;
} ftape_fast_start_struct;

typedef struct {
  int id;
  int size;
  int free;
} ftape_last_segment_struct;

/*      ftape-rw.c defined global vars.
 */
extern int tracing;
extern byte trace_id;
extern buffer_struct buffer[ NR_FTAPE_BUFFERS];
extern int location_known;
extern int current_segment;
extern volatile ftape_fast_start_struct ftape_fast_start;
extern byte deblock_buffer[ (SECTORS_PER_SEGMENT - 3) * SECTOR_SIZE];
extern byte scratch_buffer[ (SECTORS_PER_SEGMENT - 3) * SECTOR_SIZE];
extern ftape_last_segment_struct ftape_last_segment;
extern int header_segment_1;
extern int header_segment_2;
extern unsigned long bad_sector_map[ 4200];

/*      ftape-rw.c defined global functions.
 */
extern int count_ones( unsigned long mask);
extern int valid_segment_no( unsigned segment);
extern int setup_new_segment( buffer_struct* buff, unsigned int segment_id,
                             int offset, unsigned int count);
extern int calc_next_cluster( buffer_struct* buff);
extern buffer_struct* next_buffer( volatile int* x);
extern int ftape_read_id( int* location);
extern void ftape_tape_parameters( byte drive_configuration);
extern int wait_segment( buffer_state_enum state);
extern void ftape_zap_buffers( void);
extern int ftape_smart_stop( int* location_known, int* location);
extern int ftape_start_tape( int segment_id);
extern void update_bad_sector_map( byte* buffer);

/*      fdc-io.c defined global functions.
 */
extern int setup_fdc_and_dma( buffer_struct* buff, byte operation);

#endif /* _FTAPE_RW_H */
