/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                             A - S N A M E S                              */
/*                                                                          */
/*                              C Header File                               */
/*                                                                          */
/*                            $Revision: 1.12 $                             */
/*                                                                          */
/*           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          */
/*                                                                          */
/* GNAT is free software;  you can  redistribute it  and/or modify it under */
/* terms of the  GNU General Public License as published  by the Free Soft- */
/* ware  Foundation;  either version 2,  or (at your option) any later ver- */
/* sion.  GNAT is distributed in the hope that it will be useful, but WITH- */
/* OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY */
/* or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License */
/* for  more details.  You should have  received  a copy of the GNU General */
/* Public License  distributed with GNAT;  see file COPYING.  If not, write */
/* to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. */
/*                                                                          */
/****************************************************************************/

/* This is the C file that corresponds to the Ada package specification
   Snames. It was created manually from the file snames.ads.

/* Name_Id values */

#define Name_uParent (First_Name_Id + 256 + 000)
#define Name_uTag    (First_Name_Id + 256 + 001)

/* Define the function to return one of the numeric values below.  Note
   that it actually returns a char since an enumeration value of less
   than 256 entries is represented that way in Ada.  The operand is a Chars
   field value.  */

#define Get_Attribute_Id snames__get_attribute_id
extern char Get_Attribute_Id PROTO ((int));

/* Define the numeric values for the attributes.  */

#define  Attr_Abort_Signal                  0
#define  Attr_Access                        1
#define  Attr_Address                       2
#define  Attr_Address_Size                  3
#define  Attr_Adjacent                      4
#define  Attr_Aft                           5
#define  Attr_Alignment                     6
#define  Attr_Bit_Order                     7
#define  Attr_Body_Version                  8
#define  Attr_Callable                      9
#define  Attr_Caller                        10
#define  Attr_Ceiling                       11
#define  Attr_Component_Size                12
#define  Attr_Compose                       13
#define  Attr_Constrained                   14
#define  Attr_Copy_Sign                     15
#define  Attr_Count                         16
#define  Attr_Definite                      17
#define  Attr_Delta                         18
#define  Attr_Denorm                        19
#define  Attr_Digits                        20
#define  Attr_Emax                          21
#define  Attr_Enum_Rep                      22
#define  Attr_Epsilon                       23
#define  Attr_Exponent                      24
#define  Attr_External_Tag                  25
#define  Attr_First                         26
#define  Attr_First_Bit                     27
#define  Attr_Floor                         28
#define  Attr_Fore                          29
#define  Attr_Fraction                      30
#define  Attr_Identity                      31
#define  Attr_Image                         32
#define  Attr_Img                           33
#define  Attr_Input                         34
#define  Attr_Large                         35
#define  Attr_Last                          36
#define  Attr_Last_Bit                      37
#define  Attr_Leading_Part                  38
#define  Attr_Length                        39
#define  Attr_Machine                       40
#define  Attr_Machine_Emax                  41
#define  Attr_Machine_Emin                  42
#define  Attr_Machine_Mantissa              43
#define  Attr_Machine_Overflows             44
#define  Attr_Machine_Radix                 45
#define  Attr_Machine_Rounds                46
#define  Attr_Mantissa                      47
#define  Attr_Max                           48
#define  Attr_Max_Interrupt_Priority        49
#define  Attr_Max_Priority                  50
#define  Attr_Max_Size_In_Storage_Elements  51
#define  Attr_Min                           52
#define  Attr_Model                         53
#define  Attr_Model_Emin                    54
#define  Attr_Model_Epsilon                 55
#define  Attr_Model_Mantissa                56
#define  Attr_Model_Small                   57
#define  Attr_Modulus                       58
#define  Attr_Output                        59
#define  Attr_Partition_Id                  60
#define  Attr_Passed_By_Reference           61
#define  Attr_Pos                           62
#define  Attr_Position                      63
#define  Attr_Pred                          64
#define  Attr_Range                         65
#define  Attr_Read                          66
#define  Attr_Remainder                     67
#define  Attr_Round                         68
#define  Attr_Rounding                      69
#define  Attr_Safe_Emax                     70
#define  Attr_Safe_First                    71
#define  Attr_Safe_Large                    72
#define  Attr_Safe_Last                     73
#define  Attr_Safe_Small                    74
#define  Attr_Scale                         75
#define  Attr_Scaling                       76
#define  Attr_Signed_Zeros                  77
#define  Attr_Size                          78
#define  Attr_Small                         79
#define  Attr_Storage_Size                  80
#define  Attr_Storage_Unit                  81
#define  Attr_Succ                          82
#define  Attr_Tag                           83
#define  Attr_Terminated                    84
#define  Attr_Tick                          85
#define  Attr_Truncation                    86
#define  Attr_Unbiased_Rounding             87
#define  Attr_Unchecked_Access              88
#define  Attr_Universal_Literal_String      89
#define  Attr_Unrestricted_Access           90
#define  Attr_Val                           91
#define  Attr_Valid                         92
#define  Attr_Value                         93
#define  Attr_Version                       94
#define  Attr_Wide_Image                    95
#define  Attr_Wide_Value                    96
#define  Attr_Width                         97
#define  Attr_Word_Size                     98
#define  Attr_Write                         99
#define  Attr_Storage_Pool                 100
#define  Attr_Base                         101
#define  Attr_Class                        102
#define  Attr_Huge_Integer                 103

/* End of a-snames.h (C version of Snames package spec) */

#if 0
----------------------
-- REVISION HISTORY --
----------------------

----------------------------
revision 1.10
date: Sat Jun 18 15:31:21 1994;  author: dewar
Add entry for Attr_Modulus
Add entry for Attr_Partition_Id
----------------------------
revision 1.11
date: Fri Jul 22 14:57:24 1994;  author: dewar
Add entry for Standard Huge_Integer
----------------------------
revision 1.12
date: Tue Aug  9 07:29:21 1994;  author: dewar
Add entry for Img attribute
----------------------------
** New changes after this line and before endif. **
#endif
