------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               E X P A N D                                --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.66 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Atree;     use Atree;
with Debug_A;   use Debug_A;
with Exp_Attr;  use Exp_Attr;
with Exp_Ch2;   use Exp_Ch2;
with Exp_Ch3;   use Exp_Ch3;
with Exp_Ch4;   use Exp_Ch4;
with Exp_Ch5;   use Exp_Ch5;
with Exp_Ch6;   use Exp_Ch6;
with Exp_Ch7;   use Exp_Ch7;
with Exp_Ch9;   use Exp_Ch9;
with Exp_Ch11;  use Exp_Ch11;
with Exp_Ch13;  use Exp_Ch13;
with Exp_Prag;  use Exp_Prag;
with Exp_Util;  use Exp_Util;
with Sinfo;     use Sinfo;

procedure Expand (N : Node_Id) is
begin
   --  If expander is not active, all we have to do is to set N as Analyzed

   if not Expander_Active then
      Set_Analyzed (N, True);
      return;

   else
      --  If expander is active, first step is to check for the need to wrap
      --  a transient scope around the node. This insertion happens before
      --  the expansion of the node to ensure that it wraps not only the node
      --  itself but also any nodes that are inserted as a result of expansion.

      if Scope_Is_Transient
        and then N = Node_To_Be_Wrapped
      then
         if Nkind (N) in N_Statement
           or else Nkind (N) = N_Procedure_Call_Statement
           or else Nkind (N) = N_Entry_Call_Statement
         then
            Wrap_Transient_Statement (N);
         elsif Nkind (N) = N_Object_Declaration then
            Wrap_Transient_Declaration (N);
         else
            Wrap_Transient_Expression (N);
         end if;

         --  The node has been expanded as part of the wrap process because it
         --  has to be done before leaving the transient scope. So now we are
         --  finished (i.e. the Wrap routine made the Expand call in this case)

         return;
      end if;

      Debug_A_Entry ("expanding  ", N);

      --  Processing depends on node kind. For full details on the expansion
      --  activity required in each case, see bodies of corresponding routines

      case Nkind (N) is

         when N_Abort_Statement =>
            Expand_N_Abort_Statement (N);

         when N_Accept_Statement =>
            Expand_N_Accept_Statement (N);

         when N_Allocator =>
            Expand_N_Allocator (N);

         when N_Assignment_Statement =>
            Expand_N_Assignment_Statement (N);

         when N_Asynchronous_Select =>
            Expand_N_Asynchronous_Select (N);

         when N_Attribute_Definition_Clause =>
            Expand_N_Attribute_Definition_Clause (N);

         when N_Attribute_Reference =>
            Expand_N_Attribute_Reference (N);

         when N_Case_Statement =>
            Expand_N_Case_Statement (N);

         when N_Concat_Multiple =>
            Expand_N_Concat_Multiple (N);

         when N_Conditional_Entry_Call =>
            Expand_N_Conditional_Entry_Call (N);

         when N_Delay_Relative_Statement =>
            Expand_N_Delay_Relative_Statement (N);

         when N_Entry_Call_Statement =>
            Expand_N_Entry_Call_Statement (N);

         when N_Entry_Declaration =>
            Expand_N_Entry_Declaration (N);

         when N_Expanded_Name =>
            Expand_N_Expanded_Name (N);

         when N_Freeze_Entity =>
            Expand_N_Freeze_Entity (N);

         when N_Full_Type_Declaration =>
            Expand_N_Full_Type_Declaration (N);

         when N_Function_Call =>
            Expand_N_Function_Call (N);

         when N_Handled_Sequence_Of_Statements =>
            Expand_N_Handled_Sequence_Of_Statements (N);

         when N_Identifier =>
            Expand_N_Identifier (N);

         when N_Object_Declaration =>
            Expand_N_Object_Declaration (N);

         when N_Op_Add =>
            Expand_N_Op_Add (N);

         when N_Op_Abs =>
            Expand_N_Op_Abs (N);

         when N_Op_And =>
            Expand_N_Op_And (N);

         when N_Op_Concat =>
            Expand_N_Op_Concat (N);

         when N_Op_Divide =>
            Expand_N_Op_Divide (N);

         when N_Op_Eq =>
            Expand_N_Op_Eq (N);

         when N_Op_Expon =>
            Expand_N_Op_Expon (N);

         when N_Op_Ge =>
            Expand_N_Op_Ge (N);

         when N_Op_Gt =>
            Expand_N_Op_Gt (N);

         when N_Op_In =>
            Expand_N_Op_In (N);

         when N_Op_Le =>
            Expand_N_Op_Le (N);

         when N_Op_Lt =>
            Expand_N_Op_Lt (N);

         when N_Op_Minus =>
            Expand_N_Op_Minus (N);

         when N_Op_Mod =>
            Expand_N_Op_Mod (N);

         when N_Op_Multiply =>
            Expand_N_Op_Multiply (N);

         when N_Op_Not =>
            Expand_N_Op_Not (N);

         when N_Op_Not_In =>
            Expand_N_Op_Not_In (N);

         when N_Op_Or =>
            Expand_N_Op_Or (N);

         when N_Op_Rem =>
            Expand_N_Op_Rem (N);

         when N_Op_Subtract =>
            Expand_N_Op_Subtract (N);

         when N_Op_Xor =>
            Expand_N_Op_Xor (N);

         when N_Package_Body =>
            Expand_N_Package_Body (N);

         when N_Package_Declaration =>
            Expand_N_Package_Declaration (N);

         when N_Pragma =>
            Expand_N_Pragma (N);

         when N_Procedure_Call_Statement =>
            Expand_N_Procedure_Call_Statement (N);

         when N_Protected_Type_Declaration =>
            Expand_N_Protected_Type_Declaration (N);

         when N_Protected_Body =>
            Expand_N_Protected_Body (N);

         when N_Selective_Accept =>
            Expand_N_Selective_Accept (N);

         when N_Slice =>
            Expand_N_Slice (N);

         when N_Subprogram_Body =>
            Expand_N_Subprogram_Body (N);

         when N_Single_Task_Declaration =>
            Expand_N_Single_Task_Declaration (N);

         when N_Task_Body =>
            Expand_N_Task_Body (N);

         when N_Task_Type_Declaration =>
            Expand_N_Task_Type_Declaration (N);

         when N_Timed_Entry_Call =>
            Expand_N_Timed_Entry_Call (N);

         when N_Type_Conversion =>
            Expand_N_Type_Conversion (N);

         when N_Variant_Part =>
            Expand_N_Variant_Part (N);

         --  For all other node kinds, no expansion activity is required

         when others => null;

      end case;

      --  Set result as analyzed and then do a possible transient wrap. The
      --  transient wrap must be done after the Analyzed flag is set on, so
      --  that we do not get a recursive attempt to expand the node N.

      Set_Analyzed (N);
      Debug_A_Exit ("expanding  ", N, "  (done)");
   end if;
end Expand;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.64
--  date: Fri Aug  5 18:48:20 1994;  author: giering
--  (Expand): Called Expand_N_Delay_Relative.
--  ----------------------------
--  revision 1.65
--  date: Tue Aug 30 13:48:39 1994;  author: schonber
--  (Expand): add call to Expand_N_Timed_Entry_Call.
--  ----------------------------
--  revision 1.66
--  date: Wed Aug 31 10:41:17 1994;  author: giering
--  (Expand): Add call to Expand_N_Asynchronous_Select.
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
