------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--                               U S A G E                                  --
--                                                                          --
--                                B o d y                                   --
--                                                                          --
--                            $Revision: 1.41 $                             --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. --
--                                                                          --
------------------------------------------------------------------------------

with Osint;  use Osint;
with Output; use Output;

procedure Usage is

   procedure Write_Switch_Char;
   --  Output two spaces followed by default switch character

   procedure Write_Switch_Char is
   begin
      Write_Str ("  ");
      Write_Char (Switch_Character);
   end Write_Switch_Char;

--  Start of processing for Usage

begin
   --  Usage line

   Write_Str ("Usage: ");
   Write_Program_Name;
   Write_Char (' ');
   Write_Str ("switches sfile");
   Write_Eol;
   Write_Eol;

   --  Line for -a switch

   Write_Switch_Char;
   Write_Str ("a      Assertions enabled. Pragma Ass");
   Write_Str ("ert and pragma Debug to be activated");
   Write_Eol;

   --  Line for -b switch

   Write_Switch_Char;
   Write_Str ("b      Generate brief messages to std");
   Write_Str ("err even if verbose mode set");
   Write_Eol;

   --  Line for -c switch

   Write_Switch_Char;
   Write_Str ("c      Check syntax and semantics onl");
   Write_Str ("y (no code generation attempted)");
   Write_Eol;

   --  Line for -e switch

   Write_Switch_Char;
   Write_Str ("e      Error messages generated immed");
   Write_Str ("iately, not saved up till end");
   Write_Eol;

   --  Line for -f switch

   Write_Switch_Char;
   Write_Str ("f      Full errors. Multiple errors/l");
   Write_Str ("ine, all undefined references");
   Write_Eol;

   --  Line for -g switch

   Write_Switch_Char;
   Write_Str ("g      GNAT style checks enabled");
   Write_Eol;

   --  Line for -i switch

   Write_Switch_Char;
   Write_Str ("i?     Identifier char set (?=1/2/3/4/p");
   Write_Str ("/f/n/w) default = ");

   pragma Assert (Default_Identifier_Character_Set = 'p'
                    or else Default_Identifier_Character_Set = '1');
   if Default_Identifier_Character_Set = 'p' then
      Write_Str ("p (IBM/PC)");
   elsif Default_Identifier_Character_Set = '1' then
      Write_Str ("1 (Latin-1)");
   end if;

   Write_Eol;

   --  Line for -k switch

   Write_Switch_Char;
   Write_Str ("knnn   Limit file names to nnn characters (k = krunch)");
   Write_Eol;

   --  Line for -l switch

   Write_Switch_Char;
   Write_Str ("l      Output full source listing wi");
   Write_Str ("th embedded error messages");
   Write_Eol;

   --  Line for -m switch

   Write_Switch_Char;
   Write_Str ("mnnn   Limit number of detected error");
   Write_Str ("s to nnn (1-999)");
   Write_Eol;

   --  Line for -n switch

   Write_Switch_Char;
   Write_Str ("n      No inlining of subprograms (");
   Write_Str ("ignore pragma Inline)");
   Write_Eol;

   --  Line for -o switch

   Write_Switch_Char;
   Write_Str ("o      Enable integer overflow chec");
   Write_Str ("king using range checks");
   Write_Eol;

   --  Line for -p switch

   Write_Switch_Char;
   Write_Str ("p      Suppress all checks");
   Write_Eol;

   --  Line for -r switch

   Write_Switch_Char;
   Write_Str ("r      Reference manual column layout");
   Write_Str (" required");
   Write_Eol;

   --  Lines for -s switch

   Write_Switch_Char;
   Write_Str ("s      Syntax check only");
   Write_Eol;

   --  Lines for -t switch

   Write_Switch_Char;
   Write_Str ("t      Try semantics, even if parse errors");
   Write_Eol;

   --  Line for -u switch

   Write_Switch_Char;
   Write_Str ("u      List units for this compilation");
   Write_Eol;

   --  Line for -v switch

   Write_Switch_Char;
   Write_Str ("v      Verbose mode. Full error outp");
   Write_Str ("ut with source lines to stdout");
   Write_Eol;

   --  Lines for -w switch

   Write_Switch_Char;
   Write_Str ("w?     Warning mode. (?=s/e for supp");
   Write_Str ("ress/treat as error)");
   Write_Eol;

   --  Lines for -x switch

   Write_Switch_Char;
   Write_Str ("x?     Cross-reference level and switches");
   Write_Str (" (?=1/2/3/4/5/9/b/s)");
   Write_Eol;

   --  Line for -83 switch

   Write_Switch_Char;
   Write_Str ("83     Enforce Ada 83 restrictions");
   Write_Eol;

   --  Line for sfile

   Write_Str ("  sfile   Source file names");

--  ??? Wild cards don't work under OS/2 at present.
--  if not OS_2 then
--     Write_Str (" (wild cards allowed for multiple files)");
--  end if;

   Write_Eol;

end Usage;


----------------------
-- REVISION HISTORY --
----------------------

--  ----------------------------
--  revision 1.39
--  date: Fri Jul  8 10:18:07 1994;  author: dewar
--  Include mention of -x9 switch
--  ----------------------------
--  revision 1.40
--  date: Mon Jul 11 11:40:20 1994;  author: dewar
--  Include mention of -x5 switch
--  ----------------------------
--  revision 1.41
--  date: Fri Jul 22 11:45:03 1994;  author: dewar
--  Change to text of full errors line
--  ----------------------------
--  New changes after this line.  Each line starts with: "--  "
