# Descrip.MMS for perl5 on VMS
# Last revised 12-Oct-1994 by Charles Bailey  bailey@genetics.upenn.edu
#
#: This file uses MMS syntax, and can be processed using DEC's MMS product,
#: or the free MMK clone (available by ftp at ftp.spc.edu).  If you want to
#: a Unix-style MAKE tool, run this file through mms2make.pl, which should
#: be found in the same directory as this file.  (There should be a pre-made
#: copy of Makefile for VAXC in this directory to allow you to build perl.)
#:
#: Lines beginning with "#:" will be removed by mms2make.pl when converting
#: this file to MAKE syntax.
#:
#:	Usage:
#: Building with VAX C, on system without DEC C installed or with VAX C default:
#:	$ MMS
#: Building with VAX C, on system with DEC C installed as default C compiler:
#:	$ MMS /MACRO=("cc=CC/VAXC")
#: Building with DEC C, on system without VAX C installed or with DEC C default:
#:	$ MMS /MACRO=("decc=1")
#: Building with DEC C, on system with VAX C installed as default C compiler:
#:	$ MMS /MACRO=("decc=1","cc=CC/DECC")
#: Building with GNU C, on system with GCC command installed in DCLTABLES:
#:	$ MMS /MACRO=("gnuc=1")
#: Building with GNU C, on system without GCC command installed in DCLTABLES:
#:	$ MMS /MACRO=("gnuc=1") gcc_cld_setup,all
#:	note: `gcc_cld_setup' target must explicitly precede `all' or `[mini]perl'
#:
#: To each of the above, add /Macro="__AXP__=1" if building on an AXP,
#:                           /Macro="__DEBUG__=1" to build a debug version
#:                           (i.e. VMS debugger, not perl -D), and
#:                           /Macro="SOCKET=1" to include socket support.
#
#	tidy      -- purge files generated by executing this file
#	clean     -- remove all files generated by executing this file
#	cleansrc  -- `clean' + purge *.c,*.h,descrip.mms
#	gcc_cld_setup -- GCC initialization; see above
#	crtl.opt  -- compiler-specific linker options file (made automatically)
#

#### Start of system configuration section. ####

.ifdef AXE
# File type to use for object files
O = .abj
# File type to use for executable images
E = .axe
.else
# File type to use for object files
O = .obj
# File type to use for executable images
E = .exe
.endif

# used to incorporate 'custom' malloc routines
mallocsrc =
mallocobj =

#: Process hardware architecture macros
.ifdef __AXP__
SYMOPT =
DECC = 1
.else
# We need separate MACRO files declaring global symbols
SYMOPT = ,perlshr_gbl.opt/Option
.endif

#: Process compiler selection macros
.ifdef GNUC
.first
	@ If F$TrnLnm("Sys").eqs."" Then Define/NoLog SYS GNU_CC_Include:[VMS]
CC = gcc
XTRACCFLAGS = /Obj=$(MMS$TARGET_NAME)$(O)
DBGSPECFLAGS =
XTRADEF = ,GNUC_ATTRIBUTE_CHECK
XTRAOBJS =
LIBS1 = GNU_CC:[000000]GCCLIB.OLB/Library
LIBS2 = Sys$Share:VAXCRTL.Exe/Shareable
.else
.first
	@ If F$TrnLnm("Sys").eqs."" Then Define/NoLog SYS Sys$Library
XTRAOBJS = 
LIBS1 = $(XTRAOBJS)
DBGSPECFLAGS = /Show=(Source,Include,Expansion)
.ifdef decc
LIBS2 = 
XTRACCFLAGS = /Standard=VAXC/Include=[]/Prefix=All/Obj=$(MMS$TARGET_NAME)$(O)
XTRADEF =
.else # VAXC
XTRACCFLAGS = /Include=[]/Object=$(O)
XTRADEF =
LIBS2 = Sys$Share:VAXCRTL.Exe/Shareable
.endif
.endif

.ifdef __DEBUG__
DBGCCFLAGS = /List/Debug/NoOpt$(DBGSPECFLAGS)
DBGLINKFLAGS = /Debug/Map/Full/Cross
DBG = DBG
.else
DBGCCFLAGS = /NoList
DBGLINKFLAGS = /NoMap
DBG = 
.endif

# Process option macros
.ifdef SOCKET
SOCKDEF = ,VMS_DO_SOCKETS
SOCKLIB = SocketShr/Share
# N.B. the targets for $(SOCKC) and $(SOCKH) assume that the permanent
# copies live in [.vms], and the `clean' target will delete copies of
# these files in the current default directory.
SOCKC = sockadapt.c
SOCKH = sockadapt.h
SOCKCLIS = ,$(SOCKC)
SOCKHLIS = ,$(SOCKH)
SOCKOBJ = ,sockadapt$(O)
.else
SOCKDEF =
SOCKLIB =
SOCKC =
SOCKH =
SOCKCLIS =
SOCKHLIS =
SOCKOBJ =
.endif

# DEBUGGING ==> perl -D, not the VMS debugger
CFLAGS = /Define=(DEBUGGING$(SOCKDEF)$(XTRADEF))$(XTRACCFLAGS)$(DBGCCFLAGS)
LINKFLAGS = $(DBGLINKFLAGS)

MAKEFILE = [.VMS]Descrip.MMS   # this file
NOOP = continue

XSUBPP = MCR Sys$Disk:[]Miniperl$(E) [.ext]xsubpp -typemap [-]typemap
# List of extensions to build into perlmain; enclose each in quotes and
# separate by spaces.
EXT = "DynaLoader"
# Source and object files for these extensions; leading comma is required
# These must be built separately, or you must add rules below to build them
extobj = , [.ext.dynaloader]dl_vms$(O)

#### End of system configuration section. ####


h1 = EXTERN.h, INTERN.h, XSUB.h, av.h, config.h, cop.h, cv.h
h2 = embed.h, form.h, gv.h, handy.h, hv.h, keywords.h, mg.h, op.h
h3 = opcode.h, patchlevel.h, perl.h, perly.h, pp.h, proto.h, regcomp.h
h4 = regexp.h, scope.h, sv.h, vmsish.h, util.h
h = $(h1), $(h2), $(h3), $(h4) $(SOCKHLIS)

c1 = av.c, scope.c, op.c, doop.c, doio.c, dump.c, hv.c $(mallocsrc)
c2 = mg.c, perly.c, pp.c, pp_ctl.c, pp_hot.c, pp_sys.c, regcomp.c, regexec.c
c3 = gv.c, sv.c, taint.c, toke.c, util.c, deb.c, run.c, vms.c $(SOCKCLIS)

c = $(c1), $(c2), $(c3), perl.c, miniperlmain.c, perlmain.c

obj1 = av$(O), scope$(O), op$(O), doop$(O), doio$(O), dump$(O), hv$(O) $(mallocobj)
obj2 = mg$(O), perly$(O), pp$(O), pp_ctl$(O), pp_hot$(O), pp_sys$(O), regcomp$(O), regexec$(O)
obj3 = gv$(O), sv$(O), taint$(O), toke$(O), util$(O), deb$(O), run$(O), vms$(O) $(SOCKOBJ)

obj = $(obj1), $(obj2), $(obj3)

CRTL = []crtl.opt
CRTLOPTS =,$(CRTL)/Options

.SUFFIXES
.SUFFIXES $(O) .c

.c$(O) :
	$(CC) $(CFLAGS) $(MMS$SOURCE)

all : base extras
	@ $(NOOP)
base : $(DBG)miniperl$(E) perl$(E) [.lib]Config.pm 
	@ $(NOOP)
extras : [.lib]DynaLoader.pm
	@ $(NOOP)

miniperl_objs = miniperlmain$(O), perl$(O), $(obj)
miniperl$(E) :  $(miniperl_objs) , coreobjs.opt $(CRTL)
	Link $(LINKFLAGS)/NoDebug/Exe=$(MMS$TARGET) miniperlmain$(O), perl$(O), coreobjs.opt/Option $(CRTLOPTS)
.ifdef DBG
$(DBG)miniperl$(E) :  $(miniperl_objs) , coreobjs.opt $(CRTL)
	Link $(LINKFLAGS)/Exe=$(MMS$TARGET) miniperlmain$(O), perl$(O), coreobjs.opt/Option $(CRTLOPTS)
.endif

# Use an options file to list object files since some Makes don't feed
# long lines to DCL properly
coreobjs.opt : $(MAKEFILE)
	@ @[.vms]genopt "$(MMS$TARGET)/Write" "|" "$(obj1)"
	@ @[.vms]genopt "$(MMS$TARGET)/Append" "|" "$(obj2)"
	@ @[.vms]genopt "$(MMS$TARGET)/Append" "|" "$(obj3)"

perlmain.c : miniperlmain.c miniperl$(E)
	MCR Sys$Disk:[]Miniperl$(E) [.VMS]Writemain.pl $(EXT)

perl$(E) : perlmain$(O) $(extobj), perlshr$(E), perlshr_attr.opt $(CRTL)
	@ @[.vms]genopt "PerlShr.Opt/Write" "|" "''F$Environment("Default")'$(DBG)PerlShr$(E)/Share"
	Link $(LINKFLAGS)/Exe=$(DBG)$(MMS$TARGET) perlmain$(O) $(extobj),[]perlshr.opt/Option,perlshr_attr.opt/Option
shr_objs = perlshr$(O) ,perl$(O), $(obj)
perlshr$(E) : $(shr_objs) ,perlshr_xtras.ts  ,coreobjs.opt ,$(CRTL)
	Link $(LINKFLAGS)/Share/Exe=$(DBG)$(MMS$TARGET) perlshr$(O), perl$(O), coreobjs.opt/Option  $(SYMOPT) , perlshr_attr.opt/Option, perlshr_sym.opt/Option $(CRTLOPTS)
perlshr$(O) : [.vms]perlshr.c
	$(CC) $(CFLAGS)/NoOptimize/Object=$(MMS$TARGET) $(MMS$SOURCE)
# The following files are built in one go by gen_shrfls.pl:
#  perlshr_attr.opt, perlshr_sym.opt - VAX and AXP
#  perlshr_gbl*.mar, perlshr_gbl*$(O), perlshr_gbl.opt - VAX only
.ifdef DECC_PIPES_BROKEN
# This is a backup target used only with older versions of the DECCRTL which
# can't deal with pipes properly.  See ReadMe.VMS for details.
perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl miniperl$(E) $(MAKEFILE)
	$(CC) $(CFLAGS)/NoObject/NoList/PreProcess=perl.i perl.h
	MCR Sys$Disk:[]Miniperl$(E) [.vms]gen_shrfls.pl "~~NOCC~~perl.i" $(O)
	@ Delete/NoLog/NoConfirm perl.i;
	@ Copy NLA0: perlshr_xtras.ts
	@ Purge/NoLog/NoConfirm perlshr_xtras.ts
.else
perlshr_xtras.ts : perl.h config.h vmsish.h proto.h [.vms]gen_shrfls.pl miniperl$(E) $(MAKEFILE)
	MCR Sys$Disk:[]Miniperl$(E) [.vms]gen_shrfls.pl "$(CC)$(CFLAGS)" $(O)
	@ Copy NLA0: perlshr_xtras.ts
	@ Purge/NoLog/NoConfirm perlshr_xtras.ts
.endif

[.lib]config.pm : [.vms]config.vms [.vms]genconfig.pl miniperl$(E)
	MCR Sys$Disk:[]Miniperl$(E) [.VMS]GenConfig.Pl
	MCR Sys$Disk:[]Miniperl$(E) ConfigPM.

[.ext.dynaloader]dl_vms.c : [.ext.dynaloader]dl_vms.xs miniperl$(E)
	$(XSUBPP) $(MMS$SOURCE) >$(MMS$TARGET)

[.ext.dynaloader]dl_vms$(O) : [.ext.dynaloader]dl_vms.c
	$(CC) $(CFLAGS) /Object=$(MMS$TARGET) $(MMS$SOURCE)

preplibrary : miniperl$(E) [.lib]Config.pm
	@ Create/Directory [.lib.auto]
	MCR Sys$Disk:[]Miniperl$(E) "-Ilib" -e "use AutoSplit; autosplit_lib_modules(@ARGV)" [.lib]*.pm [.lib.*]*.pm

[.lib]DynaLoader.pm : [.ext.dynaloader]dynaloader.pm preplibrary
	Copy/Log/NoConfirm [.ext.dynaloader]dynaloader.pm [.lib]DynaLoader.pm
	MCR Sys$Disk:[]Miniperl$(E) autosplit DynaLoader

.ifdef SOCKET
$(SOCKOBJ) : $(SOCKC) $(SOCKH)

vmsish.h : $(SOCKH)

$(SOCKC) : [.vms]$(SOCKC)
	Copy/Log/NoConfirm [.vms]$(SOCKC) []$(SOCKC)

$(SOCKH) : [.vms]$(SOCKH)
	Copy/Log/NoConfirm [.vms]$(SOCKH) []$(SOCKH)
.endif

#opcode.h : opcode.pl
#	MCR Sys$Disk:[]Miniperl$(E) opcode.pl

perly.h : perly.c                   # Quick and dirty 'touch'
	Copy/Log/NoConfirm perly.h; ;
	Delete/Log/NoConfirm perly.h;-1

# I now supply perly.c with the kits, so the following section is
# commented out if you don't have byacc.

# perly.c:
# 	@ echo 'Expect' 80 shift/reduce and 62 reduce/reduce conflicts
# 	\$(BYACC) -d perly.y
# 	sh \$(shellflags) ./perly.fixer y.tab.c perly.c
# 	mv y.tab.h perly.h
# 	echo 'extern YYSTYPE yylval;' >>perly.h

perly$(O) : perly.c, perly.h, $(h)
	$(CC) $(CFLAGS) $(MMS$SOURCE)

test : perl$(E)
	- @[.VMS]Test.Com

# AUTOMATICALLY GENERATED MAKE DEPENDENCIES--PUT NOTHING BELOW THIS LINE
# If this runs make out of memory, delete /usr/include lines.
av$(O) : EXTERN.h
av$(O) : av.c
av$(O) : av.h
av$(O) : config.h
av$(O) : cop.h
av$(O) : cv.h
av$(O) : embed.h
av$(O) : form.h
av$(O) : gv.h
av$(O) : handy.h
av$(O) : hv.h
av$(O) : mg.h
av$(O) : op.h
av$(O) : opcode.h
av$(O) : perl.h
av$(O) : pp.h
av$(O) : proto.h
av$(O) : regexp.h
av$(O) : scope.h
av$(O) : sv.h
av$(O) : vmsish.h
av$(O) : util.h
scope$(O) : EXTERN.h
scope$(O) : av.h
scope$(O) : config.h
scope$(O) : cop.h
scope$(O) : cv.h
scope$(O) : embed.h
scope$(O) : form.h
scope$(O) : gv.h
scope$(O) : handy.h
scope$(O) : hv.h
scope$(O) : mg.h
scope$(O) : op.h
scope$(O) : opcode.h
scope$(O) : perl.h
scope$(O) : pp.h
scope$(O) : proto.h
scope$(O) : regexp.h
scope$(O) : scope.c
scope$(O) : scope.h
scope$(O) : sv.h
scope$(O) : vmsish.h
scope$(O) : util.h
op$(O) : EXTERN.h
op$(O) : av.h
op$(O) : config.h
op$(O) : cop.h
op$(O) : cv.h
op$(O) : embed.h
op$(O) : form.h
op$(O) : gv.h
op$(O) : handy.h
op$(O) : hv.h
op$(O) : mg.h
op$(O) : op.c
op$(O) : op.h
op$(O) : opcode.h
op$(O) : perl.h
op$(O) : pp.h
op$(O) : proto.h
op$(O) : regexp.h
op$(O) : scope.h
op$(O) : sv.h
op$(O) : vmsish.h
op$(O) : util.h
doop$(O) : EXTERN.h
doop$(O) : av.h
doop$(O) : config.h
doop$(O) : cop.h
doop$(O) : cv.h
doop$(O) : doop.c
doop$(O) : embed.h
doop$(O) : form.h
doop$(O) : gv.h
doop$(O) : handy.h
doop$(O) : hv.h
doop$(O) : mg.h
doop$(O) : op.h
doop$(O) : opcode.h
doop$(O) : perl.h
doop$(O) : pp.h
doop$(O) : proto.h
doop$(O) : regexp.h
doop$(O) : scope.h
doop$(O) : sv.h
doop$(O) : vmsish.h
doop$(O) : util.h
doio$(O) : EXTERN.h
doio$(O) : av.h
doio$(O) : config.h
doio$(O) : cop.h
doio$(O) : cv.h
doio$(O) : doio.c
doio$(O) : embed.h
doio$(O) : form.h
doio$(O) : gv.h
doio$(O) : handy.h
doio$(O) : hv.h
doio$(O) : mg.h
doio$(O) : op.h
doio$(O) : opcode.h
doio$(O) : perl.h
doio$(O) : pp.h
doio$(O) : proto.h
doio$(O) : regexp.h
doio$(O) : scope.h
doio$(O) : sv.h
doio$(O) : vmsish.h
doio$(O) : util.h
dump$(O) : EXTERN.h
dump$(O) : av.h
dump$(O) : config.h
dump$(O) : cop.h
dump$(O) : cv.h
dump$(O) : dump.c
dump$(O) : embed.h
dump$(O) : form.h
dump$(O) : gv.h
dump$(O) : handy.h
dump$(O) : hv.h
dump$(O) : mg.h
dump$(O) : op.h
dump$(O) : opcode.h
dump$(O) : perl.h
dump$(O) : pp.h
dump$(O) : proto.h
dump$(O) : regexp.h
dump$(O) : scope.h
dump$(O) : sv.h
dump$(O) : vmsish.h
dump$(O) : util.h
hv$(O) : EXTERN.h
hv$(O) : av.h
hv$(O) : config.h
hv$(O) : cop.h
hv$(O) : cv.h
hv$(O) : embed.h
hv$(O) : form.h
hv$(O) : gv.h
hv$(O) : handy.h
hv$(O) : hv.c
hv$(O) : hv.h
hv$(O) : mg.h
hv$(O) : op.h
hv$(O) : opcode.h
hv$(O) : perl.h
hv$(O) : pp.h
hv$(O) : proto.h
hv$(O) : regexp.h
hv$(O) : scope.h
hv$(O) : sv.h
hv$(O) : vmsish.h
hv$(O) : util.h
malloc$(O) : EXTERN.h
malloc$(O) : av.h
malloc$(O) : config.h
malloc$(O) : cop.h
malloc$(O) : cv.h
malloc$(O) : embed.h
malloc$(O) : form.h
malloc$(O) : gv.h
malloc$(O) : handy.h
malloc$(O) : hv.h
malloc$(O) : malloc.c
malloc$(O) : mg.h
malloc$(O) : op.h
malloc$(O) : opcode.h
malloc$(O) : perl.h
malloc$(O) : pp.h
malloc$(O) : proto.h
malloc$(O) : regexp.h
malloc$(O) : scope.h
malloc$(O) : sv.h
malloc$(O) : vmsish.h
malloc$(O) : util.h
mg$(O) : EXTERN.h
mg$(O) : av.h
mg$(O) : config.h
mg$(O) : cop.h
mg$(O) : cv.h
mg$(O) : embed.h
mg$(O) : form.h
mg$(O) : gv.h
mg$(O) : handy.h
mg$(O) : hv.h
mg$(O) : mg.c
mg$(O) : mg.h
mg$(O) : op.h
mg$(O) : opcode.h
mg$(O) : perl.h
mg$(O) : pp.h
mg$(O) : proto.h
mg$(O) : regexp.h
mg$(O) : scope.h
mg$(O) : sv.h
mg$(O) : vmsish.h
mg$(O) : util.h
perly$(O) : EXTERN.h
perly$(O) : av.h
perly$(O) : config.h
perly$(O) : cop.h
perly$(O) : cv.h
perly$(O) : embed.h
perly$(O) : form.h
perly$(O) : gv.h
perly$(O) : handy.h
perly$(O) : hv.h
perly$(O) : mg.h
perly$(O) : op.h
perly$(O) : opcode.h
perly$(O) : perl.h
perly$(O) : perly.c
perly$(O) : pp.h
perly$(O) : proto.h
perly$(O) : regexp.h
perly$(O) : scope.h
perly$(O) : sv.h
perly$(O) : vmsish.h
perly$(O) : util.h
pp$(O) : EXTERN.h
pp$(O) : av.h
pp$(O) : config.h
pp$(O) : cop.h
pp$(O) : cv.h
pp$(O) : embed.h
pp$(O) : form.h
pp$(O) : gv.h
pp$(O) : handy.h
pp$(O) : hv.h
pp$(O) : mg.h
pp$(O) : op.h
pp$(O) : opcode.h
pp$(O) : perl.h
pp$(O) : pp.c
pp$(O) : pp.h
pp$(O) : proto.h
pp$(O) : regexp.h
pp$(O) : scope.h
pp$(O) : sv.h
pp$(O) : vmsish.h
pp$(O) : util.h
regcomp$(O) : EXTERN.h
regcomp$(O) : INTERN.h
regcomp$(O) : av.h
regcomp$(O) : config.h
regcomp$(O) : cop.h
regcomp$(O) : cv.h
regcomp$(O) : embed.h
regcomp$(O) : form.h
regcomp$(O) : gv.h
regcomp$(O) : handy.h
regcomp$(O) : hv.h
regcomp$(O) : mg.h
regcomp$(O) : op.h
regcomp$(O) : opcode.h
regcomp$(O) : perl.h
regcomp$(O) : pp.h
regcomp$(O) : proto.h
regcomp$(O) : regcomp.c
regcomp$(O) : regcomp.h
regcomp$(O) : regexp.h
regcomp$(O) : scope.h
regcomp$(O) : sv.h
regcomp$(O) : vmsish.h
regcomp$(O) : util.h
regexec$(O) : EXTERN.h
regexec$(O) : av.h
regexec$(O) : config.h
regexec$(O) : cop.h
regexec$(O) : cv.h
regexec$(O) : embed.h
regexec$(O) : form.h
regexec$(O) : gv.h
regexec$(O) : handy.h
regexec$(O) : hv.h
regexec$(O) : mg.h
regexec$(O) : op.h
regexec$(O) : opcode.h
regexec$(O) : perl.h
regexec$(O) : pp.h
regexec$(O) : proto.h
regexec$(O) : regcomp.h
regexec$(O) : regexec.c
regexec$(O) : regexp.h
regexec$(O) : scope.h
regexec$(O) : sv.h
regexec$(O) : vmsish.h
regexec$(O) : util.h
gv$(O) : EXTERN.h
gv$(O) : av.h
gv$(O) : config.h
gv$(O) : cop.h
gv$(O) : cv.h
gv$(O) : embed.h
gv$(O) : form.h
gv$(O) : gv.c
gv$(O) : gv.h
gv$(O) : handy.h
gv$(O) : hv.h
gv$(O) : mg.h
gv$(O) : op.h
gv$(O) : opcode.h
gv$(O) : perl.h
gv$(O) : pp.h
gv$(O) : proto.h
gv$(O) : regexp.h
gv$(O) : scope.h
gv$(O) : sv.h
gv$(O) : vmsish.h
gv$(O) : util.h
sv$(O) : EXTERN.h
sv$(O) : av.h
sv$(O) : config.h
sv$(O) : cop.h
sv$(O) : cv.h
sv$(O) : embed.h
sv$(O) : form.h
sv$(O) : gv.h
sv$(O) : handy.h
sv$(O) : hv.h
sv$(O) : mg.h
sv$(O) : op.h
sv$(O) : opcode.h
sv$(O) : perl.h
sv$(O) : perly.h
sv$(O) : pp.h
sv$(O) : proto.h
sv$(O) : regexp.h
sv$(O) : scope.h
sv$(O) : sv.c
sv$(O) : sv.h
sv$(O) : vmsish.h
sv$(O) : util.h
taint$(O) : EXTERN.h
taint$(O) : av.h
taint$(O) : config.h
taint$(O) : cop.h
taint$(O) : cv.h
taint$(O) : embed.h
taint$(O) : form.h
taint$(O) : gv.h
taint$(O) : handy.h
taint$(O) : hv.h
taint$(O) : mg.h
taint$(O) : op.h
taint$(O) : opcode.h
taint$(O) : perl.h
taint$(O) : pp.h
taint$(O) : proto.h
taint$(O) : regexp.h
taint$(O) : scope.h
taint$(O) : sv.h
taint$(O) : taint.c
taint$(O) : vmsish.h
taint$(O) : util.h
toke$(O) : EXTERN.h
toke$(O) : av.h
toke$(O) : config.h
toke$(O) : cop.h
toke$(O) : cv.h
toke$(O) : embed.h
toke$(O) : form.h
toke$(O) : gv.h
toke$(O) : handy.h
toke$(O) : hv.h
toke$(O) : keywords.h
toke$(O) : mg.h
toke$(O) : op.h
toke$(O) : opcode.h
toke$(O) : perl.h
toke$(O) : perly.h
toke$(O) : pp.h
toke$(O) : proto.h
toke$(O) : regexp.h
toke$(O) : scope.h
toke$(O) : sv.h
toke$(O) : toke.c
toke$(O) : vmsish.h
toke$(O) : util.h
util$(O) : EXTERN.h
util$(O) : av.h
util$(O) : config.h
util$(O) : cop.h
util$(O) : cv.h
util$(O) : embed.h
util$(O) : form.h
util$(O) : gv.h
util$(O) : handy.h
util$(O) : hv.h
util$(O) : mg.h
util$(O) : op.h
util$(O) : opcode.h
util$(O) : perl.h
util$(O) : pp.h
util$(O) : proto.h
util$(O) : regexp.h
util$(O) : scope.h
util$(O) : sv.h
util$(O) : vmsish.h
util$(O) : util.c
util$(O) : util.h
deb$(O) : EXTERN.h
deb$(O) : av.h
deb$(O) : config.h
deb$(O) : cop.h
deb$(O) : cv.h
deb$(O) : deb.c
deb$(O) : embed.h
deb$(O) : form.h
deb$(O) : gv.h
deb$(O) : handy.h
deb$(O) : hv.h
deb$(O) : mg.h
deb$(O) : op.h
deb$(O) : opcode.h
deb$(O) : perl.h
deb$(O) : pp.h
deb$(O) : proto.h
deb$(O) : regexp.h
deb$(O) : scope.h
deb$(O) : sv.h
deb$(O) : vmsish.h
deb$(O) : util.h
run$(O) : EXTERN.h
run$(O) : av.h
run$(O) : config.h
run$(O) : cop.h
run$(O) : cv.h
run$(O) : embed.h
run$(O) : form.h
run$(O) : gv.h
run$(O) : handy.h
run$(O) : hv.h
run$(O) : mg.h
run$(O) : op.h
run$(O) : opcode.h
run$(O) : perl.h
run$(O) : pp.h
run$(O) : proto.h
run$(O) : regexp.h
run$(O) : run.c
run$(O) : scope.h
run$(O) : sv.h
run$(O) : vmsish.h
run$(O) : util.h
vms$(O) : EXTERN.h
vms$(O) : av.h
vms$(O) : config.h
vms$(O) : cop.h
vms$(O) : cv.h
vms$(O) : embed.h
vms$(O) : form.h
vms$(O) : gv.h
vms$(O) : handy.h
vms$(O) : hv.h
vms$(O) : mg.h
vms$(O) : op.h
vms$(O) : opcode.h
vms$(O) : perl.h
vms$(O) : pp.h
vms$(O) : proto.h
vms$(O) : regexp.h
vms$(O) : vms.c
vms$(O) : scope.h
vms$(O) : sv.h
vms$(O) : vmsish.h
vms$(O) : util.h
miniperlmain$(O) : INTERN.h
miniperlmain$(O) : av.h
miniperlmain$(O) : config.h
miniperlmain$(O) : cop.h
miniperlmain$(O) : cv.h
miniperlmain$(O) : embed.h
miniperlmain$(O) : form.h
miniperlmain$(O) : gv.h
miniperlmain$(O) : handy.h
miniperlmain$(O) : hv.h
miniperlmain$(O) : mg.h
miniperlmain$(O) : miniperlmain.c
miniperlmain$(O) : op.h
miniperlmain$(O) : opcode.h
miniperlmain$(O) : perl.h
miniperlmain$(O) : pp.h
miniperlmain$(O) : proto.h
miniperlmain$(O) : regexp.h
miniperlmain$(O) : scope.h
miniperlmain$(O) : sv.h
miniperlmain$(O) : vmsish.h
miniperlmain$(O) : util.h
perlmain$(O) : INTERN.h
perlmain$(O) : av.h
perlmain$(O) : config.h
perlmain$(O) : cop.h
perlmain$(O) : cv.h
perlmain$(O) : embed.h
perlmain$(O) : form.h
perlmain$(O) : gv.h
perlmain$(O) : handy.h
perlmain$(O) : hv.h
perlmain$(O) : mg.h
perlmain$(O) : op.h
perlmain$(O) : opcode.h
perlmain$(O) : perl.h
perlmain$(O) : perlmain.c
perlmain$(O) : pp.h
perlmain$(O) : proto.h
perlmain$(O) : regexp.h
perlmain$(O) : scope.h
perlmain$(O) : sv.h
perlmain$(O) : vmsish.h
perlmain$(O) : util.h

config.h : [.vms]config.vms
	Copy/Log/NoConfirm [.vms]config.vms []config.h

vmsish.h : [.vms]vmsish.h
	Copy/Log/NoConfirm [.vms]vmsish.h []vmsish.h

vms.c : [.vms]vms.c
	Copy/Log/Noconfirm [.vms]vms.c []

$(CRTL) : $(MAKEFILE)
	@ @[.vms]genopt "$(CRTL)/Write" "|" "$(LIBS1)|$(LIBS2)|$(SOCKLIB)"


cleanlis :
	- If F$Search("*.Lis").nes."" Then Delete/NoConfirm/Log *.Lis;*
	- If F$Search("*.Map").nes."" Then Delete/NoConfirm/Log *.Map;*

tidy : cleanlis
	- If F$Search("*.Opt;-1").nes."" Then Purge/NoConfirm/Log *.Opt
	- If F$Search("*$(O);-1").nes."" Then Purge/NoConfirm/Log *$(O)
	- If F$Search("*$(E);-1").nes."" Then Purge/NoConfirm/Log *$(E)
	- If F$Search("Config.H;-1").nes."" Then Purge/NoConfirm/Log Config.H
	- If F$Search("Config.SH;-1").nes."" Then Purge/NoConfirm/Log Config.SH
	- If F$Search("VMSish.H;-1").nes."" Then Purge/NoConfirm/Log VMSish.H
	- If F$Search("VMS.C;-1")   .nes."" Then Purge/NoConfirm/Log VMS.C
	- If F$Search("Perlmain.C;-1")   .nes."" Then Purge/NoConfirm/Log Perlmain.C
	- If F$Search("Perlshr_Gbl*.Mar;-1")   .nes."" Then Purge/NoConfirm/Log Perlshr_Gbl*.Mar
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O);-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O)
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C;-1").nes."" Then Purge/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C
	- If F$Search("[.Lib.Auto...]*.al;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]*.al
	- If F$Search("[.Lib.Auto...]autosplit.ts;-1").nes."" Then Purge/NoConfirm/Log [.Lib.Auto...]autosplit.ts

clean : tidy
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*/Exclude=PerlShr_Attr.Opt
	- If F$Search("*$(O);*") .nes."" Then Delete/NoConfirm/Log *$(O);*
	- If F$Search("Config.H").nes."" Then Delete/NoConfirm/Log Config.H;*
	- If F$Search("Config.SH").nes."" Then Delete/NoConfirm/Log Config.SH;*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKH)")).nes."" Then Delete/NoConfirm/Log $(SOCKH);*
	- If F$Search(F$Parse("Sys$Disk:[]","$(SOCKC)")).nes."" Then Delete/NoConfirm/Log $(SOCKC);*
	- If F$Search("VMSish.H").nes."" Then Delete/NoConfirm/Log VMSish.H;*
	- If F$Search("VMS.C")   .nes."" Then Delete/NoConfirm/Log VMS.C;*
	- If F$Search("Perlmain.C")   .nes."" Then Delete/NoConfirm/Log Perlmain.C;*
	- If F$Search("Perlshr_Gbl*.Mar")   .nes."" Then Delete/NoConfirm/Log Perlshr_Gbl*.Mar;*
	- If F$Search("*.TS").nes."" Then Delete/NoConfirm/Log *.TS;*
	- If F$Search("[.Ext.DynaLoader]DL_VMS$(O)").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS$(O);*
	- If F$Search("[.Ext.DynaLoader]DL_VMS.C").nes."" Then Delete/NoConfirm/Log [.Ext.DynaLoader]DL_VMS.C;*

realclean : clean
	- If F$Search("*$(E)").nes."" Then Delete/NoConfirm/Log *$(E);*
	- If F$Search("*.Opt").nes."" Then Delete/NoConfirm/Log *.Opt;*
	- If F$Search("[.Lib.Auto...]*.al;-1").nes."" Then Delete/NoConfirm/Log [.Lib.Auto...]*.al;*
	- If F$Search("[.Lib.Auto...]autosplit.ts;-1").nes."" Then Delete/NoConfirm/Log [.Lib.Auto...]autosplit.ts;*

cleansrc : clean
	- If F$Search("*$(E)").nes."" Then Delete/NoConfirm/Log *$(E);*
	- If F$Search("*.C;-1").nes."" Then Purge/NoConfirm/Log *.C
	- If F$Search("*.H;-1").nes."" Then Purge/NoConfirm/Log *.H
	- If F$Search("*.VMS;-1").nes."" Then Purge/NoConfirm/Log *.VMS
	- If F$Search("$(MAKEFILE);-1").nes."" Then Purge/NoConfirm/Log $(MAKEFILE)
	- If F$Search("[.VMS]$(MAKEFILE);-1").nes."" Then Purge/NoConfirm/Log [.VMS]$(MAKEFILE)
	- If F$Search("[.VMS]*.C;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.C
	- If F$Search("[.VMS]*.H;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.H
	- If F$Search("[.VMS]*.Pl;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.Pl
	- If F$Search("[.VMS]*.VMS;-1").nes."" Then Purge/NoConfirm/Log [.VMS]*.VMS
	- If F$Search("[.Lib.Auto...]*.al").nes."" Then Delete/NoConfirm/Log [.Lib.Auto...]*.al;*
	- If F$Search("[.Lib.Auto...]autosplit.ts;").nes."" Then Delete/NoConfirm/Log [.Lib.Auto...]autosplit.ts;*
	- If F$Search("[.Lib]Config.pm;").nes."" Then Delete/NoConfirm/Log [.Lib]Config.pm;*
