/* TERMCAP STDWIN -- INTERNAL HEADER FILE */

/* BEWARE: CONFUSED COORDINATE CONVENTIONS.
   The VTRM package, used here for terminal output,
   puts the y coordinate first.
   The stdwin package itself puts the x coordinate first
   (but instead of (x, y), it uses (h, v)).
   Also, when VTRM specifies a range of lines, the second number
   is the last line included.  In stdwin, the second number is
   the first position NOT included. */

#include "stdwdefi.h"
#ifdef BOTH_X11_ALFA
#include "only_alfa.h"
#endif
#include "stdwin.h"
#include "menu.h"
#include "vtrm.h"

struct _window {
        short tag;              /* Window tag, usable as document id */
        short open;             /* Set if this struct window is in use */
        char *title;            /* Title string */
        void (*drawproc)();     /* Draw procedure */
        short top;              /* Top line on screen */
        short bottom;           /* Bottom line on screen + 1 */
        int offset;             /* Diff. between doc. and screen line no's */
        int curh, curv;         /* Text cursor position (doc. coord.) */
        TEXTATTR attr;          /* Text attributes */
        struct menubar mbar;    /* Collection of local menus */
        long timer;             /* Absolute timer value (see timer.c) */
        short resized;          /* Nonzero when resize event pending */
};

/* Note on the meaning of the 'offset' field:
   to convert from screen coordinates to document coordinates: add offset;
   from document coordinates to screen coordinates: subtract offset. */

/* Data structures describing windows. */

#define MAXWINDOWS      20
#define MAXLINES        120

extern WINDOW winlist[MAXWINDOWS];
extern char uptodate[MAXLINES];
extern WINDOW *wasfront, *front, *syswin;
extern int lines, columns;
extern TEXTATTR wattr;

/* KEY MAPPING. */

/* The primary key map is a 256-entry array indexed by the first
   character received.  Secondary key maps are lists terminated with a
   type field containing SENTINEL.
   The maps use the same data structure so they can be processed
   by the same routine. */

struct keymap {
        unsigned char key;      /* Character for which this entry holds */
        unsigned char type;     /* Entry type */
        unsigned char id;       /* Id and item of menu shortcut */
        unsigned char item;     /* Also parameter for other types */
};

/* Entry types: */
#define ORDINARY        0       /* Report char as itself */
#define SECONDARY       1       /* Proceed to secondary keymap [id] */
#define SHORTCUT        2       /* Menu shortcut */
#define SENTINEL        127     /* End of secondary key map */

extern struct keymap _wprimap[256];
extern struct keymap **_wsecmap;

#define SECMAPSIZE 128

/* The system menu (menu id 0) has a few entries for window manipulation,
   followed by entries corresponding to WE_COMMAND subcodes.
   WC_CLOSE happens to be the first of those, and corresponds
   with CLOSE_WIN. */

/* Item numbers in system menu: */
#define PREV_WIN        0
#define NEXT_WIN        1
#define CLOSE_WIN       2

/* Offsets between WE_COMMAND subcodes and item numbers in system menu: */
#define FIRST_CMD       (CLOSE_WIN - WC_CLOSE)
#define LAST_CMD        99

/* There are also some codes that have a shortcut and a special interpretation
   but no entry in the system menu: */
#define SUSPEND_PROC    100
#define REDRAW_SCREEN   101
#define MOUSE_DOWN      102
#define MOUSE_UP        104
#define LITERAL_NEXT    105

#define MENU_CALL       127     /* Start interactive menu selection */

/* bind.c */
extern void getttykeydefs _ARGS((int fd));
extern void gettckeydefs _ARGS((void));
extern void wsetmetakey _ARGS((int id, int item, int key));
extern void getbindings _ARGS((char *buf, int id, int item));
/* draw.c */
extern void _wnewtitle _ARGS((WINDOW *win));
extern void wdrawtitle _ARGS((WINDOW *win));
extern bool wgetchange _ARGS((WINDOW *win, int *pleft, int *ptop, int *pright, int *pbottom));
/* event.c */
extern bool wsysevent _ARGS((EVENT *ep, bool blocking));
extern void wgoto _ARGS((EVENT *ep, int type));
extern void wsyscommand _ARGS((EVENT *ep));
extern void _wlitnext _ARGS((EVENT *ep));
/* menu.c */
extern void _winitmenus _ARGS((void));
extern void initmenubar _ARGS((struct menubar *mb));
extern void killmenubar _ARGS((struct menubar *mb));
extern void drawmenubar _ARGS((void));
extern void menuselect _ARGS((EVENT *ep));
/* stdwin.c */
extern void _wreshuffle _ARGS((void));
extern void _wselnext _ARGS((void));
extern void _wselprev _ARGS((void));
extern void _wredraw _ARGS((void));
extern void _wsuspend _ARGS((void));
/* syswin.c */
extern void initsyswin _ARGS((void));
extern void wsysdraw _ARGS((WINDOW *win, int left, int top, int right, int bottom));
extern void menubarchanged _ARGS((void));
/* timer.c */
extern bool _w_checktimer _ARGS((EVENT *ep, bool mayblock));

/* extern void wmenuselect _ARGS(()); */
/* extern void wnewshortcuts _ARGS(()); */
/* extern void drawlocalmenubar _ARGS(()); */

