#include <aesbind.h>
#include <vdibind.h>
#include <gemdefs.h>
#include <obdefs.h>

#define WINDOW  struct window

#include "stdwdefi.h"
#include "stdwin.h"
#include "menu.h"

#define msec    unsigned long

struct window {
        int     tag ;           /* 16 bit 'tag' for the user                  */
        int     handle ;        /* handle to the physical GEM window          */
        char    *title ;        /* text in title bar of window                */
        void    (*drawproc)() ; /* pointer to draw procedure                  */
        int     fulled ;        /* flag indicating zoomed window or not       */
        TEXTATTR        attr ;  /* local text attributes of window            */
        int     h, v ;          /* position of window upper left corner in scr*/
        int     width ;         /* width of window                            */
        int     height ;        /* height of window                           */
        int     orgh, orgv ;    /* position of window upper left corner in doc*/
        int     doc_width ;     /* width of document                          */
        int     doc_height ;    /* height of document                         */
        bool    needupdate ;    /* document needs an update                   */
        int     left, top ;     /* first coordinate of changed rectangle      */
        int     right, bottom ; /* second    "      "      "       "          */
        msec    alarm ;         /*
                                ** alarm time in milliseconds relative to last
                                ** time booted.
                                */
        struct menubar  mbar ;  /* local menus of window                      */
        bool    careton ;       /* show or remove text caret                  */
        int     caret_h ;       /* horizontal position of caret               */
        int     caret_v ;       /* vertical       "    "    "                 */
} ;

#define TRUE    1
#define FALSE   0

#define DOCTOSCR(win,doc_h,doc_v,scr_h,scr_v) { \
                        scr_h = (doc_h) + (win->h - win->orgh) ; \
                        scr_v = (doc_v) + (win->v - win->orgv) ; \
/*wdebug ("  doc win org scr|h %3d %3d %3d %3d|v %3d %3d %3d %3d", \
        doc_h, win->h, win->orgh, scr_h, doc_v, win->v, win->orgv, scr_v) ; \
*/                      }
#define SCRTODOC(win,scr_h,scr_v,doc_h,doc_v) { \
                        doc_h = (scr_h) - (win->h - win->orgh) ; \
                        doc_v = (scr_v) - (win->v - win->orgv) ; \
/*wdebug ("  scr win org doc|h %3d %3d %3d %3d|v %3d %3d %3d %3d", \
        scr_h, win->h, win->orgh, doc_h, scr_v, win->v, win->orgv, doc_v) ; \
*/                      }

#define BAR_HEIGHT      (wlineheight () + 2)

#define DEF_OPT 0xfef

#define RECT    left, top, right, bottom
#define LEFT    0
#define TOP     1
#define RIGHT   2
#define BOTTOM  3

#define MSTIME()        (clock () * (1000 / CLK_TCK))

WINDOW  *getwin () ;

extern int      tborder ;
extern int      lborder ;
