/* save_lispmug.c -- Save FACE as a MIT Lispm Mugshot. */

/* Copyright (C) 1988, 1990, 1992 Free Software Foundation, Inc.

   This file is part of GNU Finger.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.  */


#include <config.h>
#include <sys/types.h>
#include <sys/file.h>

#include <bitmap.h>
#include <general.h>

#ifdef HAVE_FCNTL_H
#include <fcntl.h>
#endif

extern int errno;

#ifndef L_SET
#define L_SET SEEK_SET
#define L_INCR SEEK_CUR
#endif /* !L_SET */

struct lispmug {
  short width;
  short height;
};

int
save_lispmug (user, face)
     char *user;
     BITMAP *face;
{
  char *mugshot_filename (), *filename;
  struct lispmug header;
  int file, size, i;
  byte *bits;

  filename = mugshot_filename (user);
  file = open (filename, O_WRONLY | O_CREAT | O_TRUNC, 0666);
  free (filename);

  if (!file)
    return (errno);

  header.width = face->width;
  header.height = face->height;

  BYTESWAP (header.width);
  BYTESWAP (header.height);

  pad_face (face, 4);
  size = face->rowlen * face->height;
  bits = (byte *)xmalloc (size);
  bcopy (face->bits, bits, size);
  pad_face (face, 1);

  for (i = 0; i < size; i++)
    bits[i] = ~(bits[i]);

  write (file, &header, sizeof (header));
  write (file, bits, size);

  close (file);
  return (0);
}
