/*
 * Copyright 1989 by Georgia Tech Research Corporation, Atlanta, GA.
 * Copyright 1988, 1989 by Robert Viduya.
 * Copyright 1990 Jeff Sparkes.
 * Copyright 1993 Paul Mattes.
 *
 *                         All Rights Reserved
 */

/*
 *	3270_enc.h
 *
 *		Header file for x3270.  Contains the character encoding
 *		of the 3270 fonts.
 */

#define CG_NULLBLANK	0x00
#define CG_OVERBAR1	0x01
#define CG_OVERBAR2	0x02
#define CG_OVERBAR3	0x03
#define CG_OVERBAR4	0x04
#define CG_OVERBAR5	0x05
#define CG_OVERBAR6	0x06
#define CG_OVERBAR7	0x07
#define CG_GREATER	0x08
#define CG_LESS		0x09
#define CG_LBRACKET	0x0A
#define CG_RBRACKET	0x0B
#define CG_RPAREN	0x0C
#define CG_LPAREN	0x0D
#define CG_RBRACE	0x0E
#define CG_LBRACE	0x0F
#define CG_BLANK	0x10
#define CG_EQUAL	0x11
#define CG_SQUOTE	0x12
#define CG_DQUOTE	0x13
#define CG_FSLASH	0x14
#define CG_BSLASH	0x15
#define CG_SOLIDBAR	0x16
#define CG_BROKENBAR	0x17
#define CG_QUESTION	0x18
#define CG_EXCLAMATION	0x19
#define CG_DOLLAR	0x1A
#define CG_CENT		0x1B
#define CG_POUND	0x1C
#define CG_YEN		0x1D
#define CG_PT		0x1E
#define CG_CURRENCY	0x1F
#define CG_ZERO		0x20
#define CG_ONE		0x21
#define CG_TWO		0x22
#define CG_FOUR		0x24
#define CG_FIVE		0x25
#define CG_SIX		0x26
#define CG_NINE		0x29
#define CG_THREE	0x23
#define CG_SEVEN	0x27
#define CG_EIGHT	0x28
#define CG_SHARPS	0x2A
#define CG_SECTION	0x2B
#define CG_NUMBER	0x2C
#define CG_AT		0x2D
#define CG_PERCENT	0x2E
#define CG_UNDERSCORE	0x2F
#define CG_AMPERSAND	0x30
#define CG_MINUS	0x31
#define CG_PERIOD	0x32
#define CG_COMMA	0x33
#define CG_COLON	0x34
#define CG_PLUS		0x35
#define CG_NOT		0x36
#define CG_OVERSCORE	0x37
#define CG_DEGREE	0x38
#define CG_BREVE	0x39
#define CG_CIRCUMFLEX	0x3A
#define CG_TILDE	0x3B
#define CG_DIAERESIS	0x3C
#define CG_GRAVE	0x3D
#define CG_ACUTE	0x3E
#define CG_CEDILLA	0x3F
#define CG_LAGRAVE	0x40
#define CG_LEGRAVE	0x41
#define CG_LIGRAVE	0x42
#define CG_LOGRAVE	0x43
#define CG_LUGRAVE	0x44
#define CG_LATILDE	0x45
#define CG_LOTILDE	0x46
#define CG_LYDIAERESIS	0x47
#define CG_LAGRAVE2	0x48
#define CG_LEGRAVE2	0x49
#define CG_LEACUTE	0x4A
#define CG_LIGRAVE2	0x4B
#define CG_LOGRAVE2	0x4C
#define CG_LUGRAVE2	0x4D
#define CG_LUDIAERESIS	0x4E
#define CG_LCCEDILLA	0x4F
#define CG_LADIAERESIS	0x50
#define CG_LEDIAERESIS	0x51
#define CG_LIDIAERESIS	0x52
#define CG_LODIAERESIS	0x53
#define CG_LUDIAERESIS2	0x54
#define CG_LACIRCUMFLEX	0x55
#define CG_LECIRCUMFLEX	0x56
#define CG_LICIRCUMFLEX	0x57
#define CG_LOCIRCUMFLEX	0x58
#define CG_LUCIRCUMFLEX	0x59
#define CG_LAACUTE	0x5A
#define CG_LEACUTE2	0x5B
#define CG_LIACUTE	0x5C
#define CG_LOACUTE	0x5D
#define CG_LUACUTE	0x5E
#define CG_LNTILDE	0x5F
#define CG_CAGRAVE	0x60
#define CG_CEGRAVE	0x61
#define CG_CIGRAVE	0x62
#define CG_COGRAVE	0x63
#define CG_CUGRAVE	0x64
#define CG_CATILDE	0x65
#define CG_COTILDE	0x66
#define CG_CY2		0x67
#define CG_CA2		0x68
#define CG_CE2		0x69
#define CG_CE3		0x6A
#define CG_CI2		0x6B
#define CG_CO2		0x6C
#define CG_CU2		0x6D
#define CG_CY3		0x6E
#define CG_CC2		0x6F
#define CG_CADIAERESIS	0x70
#define CG_CEDIAERESIS	0x71
#define CG_CIDIAERESIS	0x72
#define CG_CODIAERESIS	0x73
#define CG_CUDIAERESIS	0x74
#define CG_CACIRCUMFLEX	0x75
#define CG_CECIRCUMFLEX	0x76
#define CG_CICIRCUMFLEX	0x77
#define CG_COCIRCUMFLEX	0x78
#define CG_CUCIRCUMFLEX	0x79
#define CG_CAACUTE	0x7A
#define CG_CEACUTE	0x7B
#define CG_CIACUTE	0x7C
#define CG_COACUTE	0x7D
#define CG_CUACUTE	0x7E
#define CG_CNTILDE	0x7F
#define CG_LA		0x80
#define CG_LB		0x81
#define CG_LC		0x82
#define CG_LD		0x83
#define CG_LE		0x84
#define CG_LF		0x85
#define CG_LG		0x86
#define CG_LH		0x87
#define CG_LI		0x88
#define CG_LJ		0x89
#define CG_LK		0x8A
#define CG_LL		0x8B
#define CG_LM		0x8C
#define CG_LN		0x8D
#define CG_LO		0x8E
#define CG_LP		0x8F
#define CG_LQ		0x90
#define CG_LR		0x91
#define CG_LS		0x92
#define CG_LT		0x93
#define CG_LU		0x94
#define CG_LV		0x95
#define CG_LW		0x96
#define CG_LX		0x97
#define CG_LY		0x98
#define CG_LZ		0x99
#define CG_LAE		0x9A
#define CG_LOSLASH	0x9B
#define CG_SSLASH0	CG_LOSLASH
#define CG_LADOT	0x9C
#define CG_LCCEDILLA2	0x9D
#define CG_FM		0x9E
#define CG_DUP		0x9F
#define CG_CA		0xA0
#define CG_CB		0xA1
#define CG_CC		0xA2
#define CG_CD		0xA3
#define CG_CE		0xA4
#define CG_CF		0xA5
#define CG_CG		0xA6
#define CG_CH		0xA7
#define CG_CI		0xA8
#define CG_CJ		0xA9
#define CG_CK		0xAA
#define CG_CL		0xAB
#define CG_CM		0xAC
#define CG_CN		0xAD
#define CG_CO		0xAE
#define CG_CP		0xAF
#define CG_CQ		0xB0
#define CG_CR		0xB1
#define CG_CS		0xB2
#define CG_CT		0xB3
#define CG_CU		0xB4
#define CG_CV		0xB5
#define CG_CW		0xB6
#define CG_CX		0xB7
#define CG_CY		0xB8
#define CG_CZ		0xB9
#define CG_CAE		0xBA
#define CG_COSLASH	0xBB
#define CG_BSLASH0	CG_COSLASH
#define CG_CADOT	0xBC
#define CG_CCCEDILLA	0xBD
#define CG_SEMICOLON	0xBE
#define CG_ASTERISK	0xBF
#define CG_0xC0		0xC0
#define CG_0xC1		0xC1
#define CG_0xC2		0xC2
#define CG_0xC3		0xC3
#define CG_0xC4		0xC4
#define CG_0xC5		0xC5
#define CG_0xC6		0xC6
#define CG_0xC7		0xC7
#define CG_0xC8		0xC8
#define CG_0xC9		0xC9
#define CG_0xCA		0xCA
#define CG_0xCB		0xCB
#define CG_0xCC		0xCC
#define CG_0xCD		0xCD
#define CG_0xCE		0xCE
#define CG_0xCF		0xCF
#define CG_PSP		0xD0
#define CG_PSS		0xD1
#define CG_BLOCKA	0xD2
#define CG_INSERT	0xD3
#define CG_BLOCKB	0xD4
#define CG_BOX6		0xD5
#define CG_RIGHTTRI	0xD6
#define CG_STATION	0xD7
#define CG_RIGHTARROW	0xD8
#define CG_BADSTATION	0xD9
#define CG_UPSHIFT	0xDA
#define CG_HUMAN	0xDB
#define CG_UNDERB	0xDC
#define CG_DOWNSHIFT	0xDD
#define CG_BOXQUESTION	0xDE
#define CG_BOXSOLID	0xDF
#define CG_0xE0		0xE0
#define CG_0xE1		0xE1
#define CG_0xE2		0xE2
#define CG_0xE3		0xE3
#define CG_0xE4		0xE4
#define CG_0xE5		0xE5
#define CG_0xE6		0xE6
#define CG_0xE7		0xE7
#define CG_0xE8		0xE8
#define CG_0xE9		0xE9
#define CG_0xEA		0xEA
#define CG_0xEB		0xEB
#define CG_0xEC		0xEC
#define CG_0xED		0xED
#define CG_0xEE		0xEE
#define CG_0xEF		0xEF
#define CG_LOCK		0xF6
#define CG_BOX4		0xFC
#define CG_BADCOMMHI	0xF0
#define CG_COMMHI	0xF1
#define CG_COMMJAG	0xF2
#define CG_COMMLO	0xF3
#define CG_CLOCKLEFT	0xF4
#define CG_CLOCKRIGHT	0xF5
#define CG_BUSYSTATION	0xF7
#define CG_LEFTARROW	0xF8
#define CG_BADBUSYSTATION	0xF9
#define CG_KEYLEFT	0xFA
#define CG_KEYRIGHT	0xFB
#define CG_UNDERA	0xFD
#define CG_MAGCARD	0xFE
#define CG_BOXHUMAN	0xFF
