.\" $Revision: 6.21 $
.TH PPNAME\ #REVISION#\  1
.SH NAME
ppname \- prepare pname files
.SH SYNOPSIS
.B ppname
[
.I -fLkrSPv
]
[
.I -s cell
]
[
.I -R n
]
[
.I -C n
]
[
.I -n n
]
[
.I -d c
]

.SH DESCRIPTION
.I Ppname
is used to prepare data for input to the spread sheet calculator
.I pname(1).
It accepts normal ascii data on standard input.  Standard output
is a
.I pname
file.
With no options, 
.I ppname
starts the spread sheet in cell A0.  Strings are right justified.
All data on a line is entered on the same row; new input lines
cause the output row number to increment by one.  The default delimiters
are tab and space.  The column formats are set to one larger
than the number of columns required to hold the largest value
in the column.

Options:

.IP "\-f"
Omit column width calculations.  This option is for preparing
data to be merged with an existing spreadsheet.  If the option is not
specified, the column widths calculated for the data read by
.I ppname
will override those already set in the existing spreadsheet.

.IP "\-L"
Left justify strings.

.IP "\-k"
Keep all delimiters.  This option causes the output cell to change on
each new delimiter encountered in the input stream.   The default
action is to condense multiple delimters to one, so that the cell only
changes once per input data item.

.IP "\-r"
Output the data by row first then column.  For input consisting of a single
column, this
option will result in output of one row with multiple columns
instead of a single
column spread sheet.

.IP "\-s cell"
Start the top left corner of the spread sheet in 
.I cell.
For example, 
.I "-s B33"
will arrange the output data so that the
spread sheet starts in column B, row 33.

.IP "\-R n"
Increment by
.I n 
on each new output row.

.IP "\-C n"
Increment by
.I n 
on each new output column.

.IP "\-n n"
Output 
.I n
rows before advancing to the next column.  This option is used when
the input is arranged in a single column and the spread sheet is to
have multiple columns, each of which is to be length
.I n.

.IP "\-d c"
Use the single character
.I c
as the delimiter between input fields.

.IP "\-P"
Plain numbers only.
A field is a number only when there is no imbeded [-+eE].

.IP "\-S"
All numbers are strings.

.IP "\-v"
Print the version of
ppname

.SH SEE ALSO
pname(1)

.SH AUTHOR

Robert Bond
