/*****************************************************************************
 *
 *  xdbx - X Window System interface to the dbx debugger
 *
 *  Copyright 1989 The University of Texas at Austin
 *  Copyright 1990 Microelectronics and Computer Technology Corporation
 *
 *  Permission to use, copy, modify, and distribute this software and its
 *  documentation for any purpose and without fee is hereby granted,
 *  provided that the above copyright notice appear in all copies and that
 *  both that copyright notice and this permission notice appear in
 *  supporting documentation, and that the name of The University of Texas
 *  and Microelectronics and Computer Technology Corporation (MCC) not be 
 *  used in advertising or publicity pertaining to distribution of
 *  the software without specific, written prior permission.  The
 *  University of Texas and MCC makes no representations about the 
 *  suitability of this software for any purpose.  It is provided "as is" 
 *  without express or implied warranty.
 *
 *  THE UNIVERSITY OF TEXAS AND MCC DISCLAIMS ALL WARRANTIES WITH REGARD TO
 *  THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABILITY AND
 *  FITNESS, IN NO EVENT SHALL THE UNIVERSITY OF TEXAS OR MCC BE LIABLE FOR
 *  ANY SPECIAL, INDIRECT OR CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER
 *  RESULTING FROM LOSS OF USE, DATA OR PROFITS, WHETHER IN AN ACTION OF
 *  CONTRACT, NEGLIGENCE OR OTHER TORTIOUS ACTION, ARISING OUT OF OR IN
 *  CONNECTION WITH THE USE OR PERFORMANCE OF THIS SOFTWARE.
 *
 *  Author:  	Po Cheung
 *  Created:   	April 9, 1990
 *
 *****************************************************************************/

/*  bitmaps.h
 *
 *    Contain bitmap data for a 48x48 and a 64x64 xdbx icon, and the 
 *	stop sign, execution arrow, up-down arrow, and bomb sign used 
 *	in the source window.
 */

/* bitmap data for 48x48 xdbx icon */

#define xdbx48_width 48
#define xdbx48_height 48
static char xdbx48_bits[] = {
   0xff, 0x0f, 0x00, 0x00, 0x00, 0xf0, 0xfe, 0x1f, 0x00, 0x00, 0x00, 0xf0,
   0xfc, 0x3f, 0x00, 0x00, 0x00, 0x78, 0xfc, 0x3f, 0x00, 0x00, 0x00, 0x3c,
   0xf8, 0x7f, 0x00, 0x02, 0x00, 0x3c, 0xf0, 0xff, 0x00, 0x02, 0x00, 0x1e,
   0xe0, 0xff, 0x01, 0x04, 0x00, 0x0f, 0xe0, 0xff, 0x01, 0x04, 0x80, 0x07,
   0xc0, 0xff, 0xe3, 0xff, 0xc0, 0x03, 0x80, 0xff, 0x1f, 0x01, 0xc7, 0x03,
   0x00, 0xff, 0x27, 0x01, 0xf8, 0x01, 0x00, 0xff, 0xcf, 0x60, 0xf0, 0x10,
   0x00, 0xfe, 0x1f, 0x90, 0xf8, 0x10, 0x00, 0xfc, 0x3f, 0x90, 0xbc, 0x08,
   0x00, 0xfc, 0x7f, 0x60, 0x3c, 0x07, 0x00, 0xfe, 0xff, 0x03, 0x1e, 0x02,
   0x00, 0xfe, 0xff, 0x04, 0x0f, 0x02, 0x00, 0xff, 0xff, 0x85, 0x07, 0x04,
   0x80, 0xff, 0xff, 0xc3, 0xc3, 0x04, 0x80, 0xdf, 0xff, 0xe7, 0x23, 0x05,
   0x84, 0x9f, 0xff, 0xef, 0x25, 0x09, 0xc8, 0x19, 0xff, 0xf7, 0xc4, 0x08,
   0xf0, 0x18, 0xfe, 0x7b, 0x03, 0x08, 0xc0, 0x1f, 0xfc, 0x3d, 0x00, 0x08,
   0xc0, 0xff, 0xff, 0xff, 0xff, 0x0f, 0xc0, 0x1f, 0x78, 0x7f, 0x00, 0x08,
   0xf0, 0x98, 0xbd, 0xff, 0x00, 0x08, 0xc8, 0x59, 0xde, 0xff, 0x61, 0x08,
   0x84, 0x5f, 0xef, 0xff, 0x91, 0x04, 0x80, 0x9f, 0xc7, 0xff, 0x93, 0x04,
   0x80, 0x9f, 0x87, 0xff, 0x67, 0x04, 0x00, 0xdf, 0x03, 0xff, 0x0f, 0x02,
   0x00, 0xfe, 0x19, 0xfe, 0x1f, 0x02, 0x00, 0xfe, 0x24, 0xfe, 0x1f, 0x07,
   0x00, 0x7c, 0x24, 0xfc, 0xff, 0x08, 0x00, 0x78, 0x18, 0xfa, 0x7f, 0x10,
   0x00, 0x3c, 0x00, 0xf2, 0xff, 0x10, 0x00, 0xde, 0x00, 0xfc, 0xff, 0x00,
   0x00, 0x8f, 0x0f, 0xe0, 0xff, 0x01, 0x80, 0x87, 0xf0, 0xff, 0xff, 0x03,
   0x80, 0x87, 0x00, 0x84, 0xff, 0x07, 0xc0, 0x43, 0x00, 0x84, 0xff, 0x07,
   0xe0, 0x21, 0x00, 0x02, 0xff, 0x0f, 0xf0, 0x00, 0x00, 0x02, 0xfe, 0x1f,
   0x78, 0x00, 0x00, 0x00, 0xfc, 0x3f, 0x78, 0x00, 0x00, 0x00, 0xfc, 0x3f,
   0x3c, 0x00, 0x00, 0x00, 0xf8, 0x7f, 0x1e, 0x00, 0x00, 0x00, 0xf0, 0xff};


/* bitmap data for 64x64 xdbx icon */

#define xdbx64_width 64
#define xdbx64_height 64
static char xdbx64_bits[] = {
   0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0xf8, 0xfe, 0xff, 0x01, 0x00,
   0x00, 0x00, 0x00, 0xf8, 0xfc, 0xff, 0x03, 0x00, 0x00, 0x00, 0x00, 0x7c,
   0xf8, 0xff, 0x07, 0x00, 0x00, 0x00, 0x00, 0x3e, 0xf8, 0xff, 0x07, 0x00,
   0x00, 0x00, 0x00, 0x1f, 0xf0, 0xff, 0x0f, 0x00, 0x00, 0x00, 0x80, 0x0f,
   0xe0, 0xff, 0x1f, 0x00, 0x00, 0x00, 0x80, 0x0f, 0xc0, 0xff, 0x3f, 0x00,
   0x00, 0x00, 0xc0, 0x07, 0xc0, 0xff, 0x3f, 0x00, 0x01, 0x00, 0xe0, 0x03,
   0x80, 0xff, 0x7f, 0x00, 0x02, 0x00, 0xf0, 0x01, 0x00, 0xff, 0xff, 0x00,
   0x04, 0x00, 0xf8, 0x00, 0x00, 0xfe, 0xff, 0x01, 0x04, 0x00, 0xf8, 0x00,
   0x00, 0xfe, 0xff, 0x01, 0x04, 0x00, 0x7c, 0x00, 0x00, 0xfc, 0xff, 0xff,
   0xff, 0x01, 0x3e, 0x04, 0x00, 0xf8, 0xff, 0x07, 0x00, 0x1e, 0x1f, 0x04,
   0x00, 0xf0, 0xff, 0x0f, 0x00, 0xe0, 0x0f, 0x04, 0x00, 0xf0, 0xff, 0x0f,
   0x80, 0x81, 0x07, 0x02, 0x00, 0xe0, 0xff, 0x1f, 0x40, 0xc2, 0x07, 0x01,
   0x00, 0xc0, 0xff, 0xbf, 0x41, 0xe2, 0x8b, 0x01, 0x00, 0xc0, 0xff, 0x7f,
   0x82, 0xf1, 0xd1, 0x00, 0x00, 0xe0, 0xff, 0xff, 0x02, 0xf8, 0x60, 0x00,
   0x00, 0xf0, 0xff, 0xff, 0x01, 0x7c, 0x40, 0x00, 0x00, 0xf8, 0xfe, 0xff,
   0x01, 0x7c, 0x80, 0x00, 0x00, 0xfc, 0xfc, 0xff, 0x03, 0x3e, 0x80, 0x00,
   0x00, 0xfc, 0xfc, 0xff, 0x03, 0x1f, 0x00, 0x01, 0x00, 0xfe, 0xf8, 0xff,
   0x87, 0x0f, 0x03, 0x01, 0x00, 0xff, 0xf0, 0xff, 0xcf, 0x87, 0x04, 0x02,
   0x08, 0xff, 0xe0, 0xff, 0xcf, 0x87, 0x04, 0x02, 0x10, 0xe7, 0xe0, 0xff,
   0xe7, 0x03, 0x03, 0x02, 0xe0, 0xe3, 0xc0, 0xff, 0xf3, 0x01, 0x00, 0x04,
   0x80, 0xff, 0x80, 0xff, 0xf9, 0x00, 0x00, 0x04, 0x80, 0xff, 0x00, 0xff,
   0xfc, 0x00, 0x00, 0x04, 0x80, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x07,
   0x80, 0xff, 0x00, 0x7e, 0xfe, 0x01, 0x00, 0x04, 0x80, 0xff, 0x00, 0x3e,
   0xff, 0x1b, 0x00, 0x04, 0xe0, 0xe3, 0x00, 0x9f, 0xff, 0x27, 0x00, 0x04,
   0x10, 0xe7, 0xb0, 0xcf, 0xff, 0x2f, 0x30, 0x02, 0x08, 0xff, 0xc8, 0xe7,
   0xff, 0x1f, 0x48, 0x02, 0x00, 0xff, 0xe8, 0xe7, 0xff, 0x1f, 0x48, 0x02,
   0x00, 0xfe, 0xf0, 0xc3, 0xff, 0x3f, 0x30, 0x01, 0x00, 0xfc, 0xf0, 0xc1,
   0xff, 0x3f, 0x00, 0x01, 0x00, 0xfc, 0xf8, 0x80, 0xff, 0x7f, 0x80, 0x00,
   0x00, 0xf8, 0x7c, 0x00, 0xff, 0xff, 0x80, 0x00, 0x00, 0xf0, 0x7c, 0x18,
   0xfe, 0xff, 0xc1, 0x00, 0x00, 0xe0, 0x3e, 0x24, 0xfe, 0xff, 0x61, 0x00,
   0x00, 0xc0, 0x1f, 0x24, 0xfc, 0xff, 0xd3, 0x00, 0x00, 0x80, 0x0f, 0x18,
   0xf8, 0xff, 0x8f, 0x01, 0x00, 0xc0, 0x07, 0x00, 0xf4, 0xff, 0x0f, 0x01,
   0x00, 0xe0, 0x0f, 0x00, 0xe4, 0xff, 0x1f, 0x02, 0x00, 0xf0, 0x39, 0x00,
   0xf8, 0xff, 0x1f, 0x04, 0x00, 0xf0, 0xc9, 0x03, 0xc0, 0xff, 0x3f, 0x04,
   0x00, 0xf8, 0x08, 0xfc, 0xff, 0xff, 0x7f, 0x04, 0x00, 0x7c, 0x04, 0x00,
   0x01, 0xff, 0x7f, 0x00, 0x00, 0x3e, 0x02, 0x00, 0x01, 0xff, 0xff, 0x00,
   0x00, 0x3e, 0x00, 0x00, 0x01, 0xfe, 0xff, 0x01, 0x00, 0x1f, 0x00, 0x80,
   0x00, 0xfc, 0xff, 0x03, 0x80, 0x0f, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x03,
   0xc0, 0x07, 0x00, 0x00, 0x00, 0xf8, 0xff, 0x07, 0xe0, 0x03, 0x00, 0x00,
   0x00, 0xf0, 0xff, 0x0f, 0xe0, 0x03, 0x00, 0x00, 0x00, 0xe0, 0xff, 0x1f,
   0xf0, 0x01, 0x00, 0x00, 0x00, 0xc0, 0xff, 0x1f, 0xf8, 0x00, 0x00, 0x00,
   0x00, 0xc0, 0xff, 0x3f, 0x7c, 0x00, 0x00, 0x00, 0x00, 0x80, 0xff, 0x7f,
   0x3e, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff};


/* bitmap data for stop sign */

#define stop_width 16
#define stop_height 16
#define stop_x_hot -1
#define stop_y_hot -1
static char stop_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x70, 0x00, 0xd0, 0x01, 0x5c, 0x07,
   0x54, 0x05, 0x54, 0x05, 0x14, 0x04, 0x0c, 0x04, 0x08, 0x04, 0x18, 0x06,
   0xf0, 0x03, 0xf0, 0x03, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for arrow sign */

#define arrow_width 16
#define arrow_height 16
#define arrow_x_hot -1
#define arrow_y_hot -1
static char arrow_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x07, 0xff, 0x0f, 0xff, 0x0f, 0xff, 0x07, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for up-down (outlined arrow) sign */

#define updown_width 16
#define updown_height 16
#define updown_x_hot -1
#define updown_y_hot -1
static char updown_bits[] = {
   0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x80, 0x00, 0x80, 0x01, 0x80, 0x03,
   0xff, 0x06, 0x01, 0x0c, 0x01, 0x0c, 0xff, 0x06, 0x80, 0x03, 0x80, 0x01,
   0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00};


/* bitmap data for bomb sign */

#define bomb_width 16
#define bomb_height 16
static char bomb_bits[] = {
   0x00, 0x00, 0x69, 0x00, 0x94, 0x00, 0x8a, 0x00, 0xc0, 0x01, 0xc5, 0x01,
   0xf0, 0x07, 0xf0, 0x07, 0xf8, 0x0f, 0xf8, 0x0d, 0xf8, 0x0d, 0xf8, 0x0d,
   0xf0, 0x06, 0xf0, 0x07, 0xc0, 0x01, 0x00, 0x00};
