/****************************************************************************/
/*                                                                          */
/*                         GNAT COMPILER COMPONENTS                         */
/*                                                                          */
/*                              A - R A I S E                               */
/*                                                                          */
/*                          C Implementation File                           */
/*                                                                          */
/*                            $Revision: 1.5 $                              */
/*                                                                          */
/*        Copyright (c) 1992,1993,1994.1995 NYU, All Rights Reserved        */
/*                                                                          */
/* The GNAT library is free software; you can redistribute it and/or modify */
/* it under terms of the GNU Library General Public License as published by */
/* the Free Software  Foundation; either version 2, or (at your option) any */
/* later version.  The GNAT library is distributed in the hope that it will */
/* be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty */
/* of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU */
/* Library  General  Public  License for  more  details.  You  should  have */
/* received  a copy of the GNU  Library  General Public License  along with */
/* the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free */
/* Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        */
/*                                                                          */
/****************************************************************************/

/* Routines to support runtime exception handling */


/* ??? We need this to define malloc on those machines that need it, but
   this is the wrong file when this is built for libgnat.a.  */
#include "config.h"

/* predefined exceptions */
char constraint_error = 0;
char numeric_error    = 0;
char program_error    = 0;
char storage_error    = 0;
char tasking_error    = 0;
char _abort_signal    = 1;

extern void (*system__tasking_soft_links__abort_defer) ();  
extern char *system__task_specific_data__get_gnat_exception ();
extern int *system__task_specific_data__get_jmpbuf_address ();
extern char debug__get_debug_flag_k (); 

void
__gnat_unhandled_exception (except, ptr)
     char *except;
     int  *ptr;
{
  if (except == &constraint_error) 
    puts ("\nraised Constraint_Error\n"); 
  else if (except == &numeric_error) 
    puts ("\nraised Numeric_Error\n"); 
  else if (except == &program_error) 
    puts ("\nraised Program_Error\n"); 
  else if (except == &storage_error)
    puts ("\nraised Storage_Error\n");
  else if (except == &tasking_error)
    puts ("\nraised Tasking_Error\n");
  else if (!ptr)
    puts ("\nraised unhandled exception\n");
}

void
__gnat_raise_nodefer (except)
     char *except;
{
  int *ptr = system__task_specific_data__get_jmpbuf_address ();

  system__task_specific_data__set_gnat_exception (except);
  if (ptr)
    longjmp (ptr, 1);

  else 
    {
      __gnat_unhandled_exception (except, ptr);
      exit (1);

    }
}

void 
__gnat_raise (except)
     char *except;
{
  (*system__tasking_soft_links__abort_defer) ();
  __gnat_raise_nodefer (except);
}

void
__gnat_reraise (flag)
     int flag;
{
  char *except = system__task_specific_data__get_gnat_exception ();

  if (flag)
    __gnat_raise (except);
  else
    __gnat_raise_nodefer (except);
}

void
__gnat_raise_constraint_error ()
{
  __gnat_raise (&constraint_error);
}

void *
__gnat_malloc (size)
     __SIZE_TYPE__ size;
{
  void *result = (char *) malloc (size);

  if (result == 0)
    __gnat_raise (&storage_error);

  return result;
}
