------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--              A D A . T E X T _ I O . M O D U L A R _ A U X               --
--                                                                          --
--                                 S p e c                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--        Copyright (c) 1992,1993,1994,1995 NYU, All Rights Reserved        --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

--  This package contains the routines for Ada.Text_IO.Modular_IO that are
--  shared among separate instantiations of this package. The routines in
--  this package are identical semantically to those in Modular_IO itself,
--  except that the generic parameter Num has been replaced by Unsigned or
--  Long_Long_Unsigned, and the default parameters have been removed because
--  they are supplied explicitly by the calls from within the generic template.

with System.Unsigned_Types; use System.Unsigned_Types;

private package Ada.Text_IO.Modular_Aux is

   procedure Get_Uns
     (File  : in File_Type;
      Item  : out Unsigned;
      Width : in Field);

   procedure Get_LLU
     (File  : in File_Type;
      Item  : out Long_Long_Unsigned;
      Width : in Field);

   procedure Put_Uns
     (File  : in File_Type;
      Item  : in Unsigned;
      Width : in Field;
      Base  : in Number_Base);

   procedure Put_LLU
     (File  : in File_Type;
      Item  : in Long_Long_Unsigned;
      Width : in Field;
      Base  : in Number_Base);

   procedure Gets_Uns
     (From : in String;
      Item : out Unsigned;
      Last : out Positive);

   procedure Gets_LLU
     (From : in String;
      Item : out Long_Long_Unsigned;
      Last : out Positive);

   procedure Puts_Uns
     (To   : out String;
      Item : in Unsigned;
      Base : in Number_Base);

   procedure Puts_LLU
     (To   : out String;
      Item : in Long_Long_Unsigned;
      Base : in Number_Base);

end Ada.Text_IO.Modular_Aux;
