------------------------------------------------------------------------------
--                                                                          --
--                         GNAT RUNTIME COMPONENTS                          --
--                                                                          --
--                          S Y S T E M . F O R E                           --
--                                                                          --
--                                 B o d y                                  --
--                                                                          --
--                            $Revision: 1.2 $                              --
--                                                                          --
--           Copyright (c) 1992,1993,1994 NYU, All Rights Reserved          --
--                                                                          --
-- The GNAT library is free software; you can redistribute it and/or modify --
-- it under terms of the GNU Library General Public License as published by --
-- the Free Software  Foundation; either version 2, or (at your option) any --
-- later version.  The GNAT library is distributed in the hope that it will --
-- be useful, but WITHOUT ANY WARRANTY;  without even  the implied warranty --
-- of MERCHANTABILITY  or  FITNESS FOR  A PARTICULAR PURPOSE.  See the  GNU --
-- Library  General  Public  License for  more  details.  You  should  have --
-- received  a copy of the GNU  Library  General Public License  along with --
-- the GNAT library;  see the file  COPYING.LIB.  If not, write to the Free --
-- Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.        --
--                                                                          --
------------------------------------------------------------------------------

package body System.Fore is

   ----------
   -- Fore --
   ----------

   function Fore (Lo, Hi : Long_Long_Float) return Natural is
      T : Long_Long_Float := Long_Long_Float'Max (abs Lo, abs Hi);
      R : Natural;

   begin
      --  Initial value of 2 allows for sign and mandatory single digit

      R := 2;

      --  Loop to increase Fore as needed to include full range of values

      while T >= 10.0 loop
         T := T / 10.0;
         R := R + 1;
      end loop;

      return R;
   end Fore;
end System.Fore;
