/*
 *  printera.c
 *
 *
 *  Paintjet tables for printer.c, in here so that we can link them
 *  as part of the printer.c overlay and not waste far space.
 *
 *  The tables were copied from Lee Crocker's PGIF program, with
 *  the 8 undithered colors moved to the first 8 table slots.
 *
 *  This file contains various lookup tables used by PJGIF.  Patterns contains
 *  unsigned values representing each of the 330 HP PaintJet colors.  Each color
 *  at 90 DPI is composed of four dots in 8 colors.  Each hex digit of these
 *  unsigned values represents one of the four dots.  Although the PaintJet will
 *  produce these patterns automatically in 90 DPI mode, it is much faster to do
 *  it in software with the PaintJet in 8-color 180 DPI mode.
 *
 *  920501 Hans Wolfgang Schulze converted from printera.asm for xfractint.
 *	   (hans@garfield.metal2.polymtl.ca)
 */

#include "port.h"

unsigned int far pj_patterns [] = {
      0x7777,0x0000,0x1111,0x2222,0x3333,0x4444,0x5555,0x6666,
             0x0001,0x0002,0x0003,0x0004,0x0005,0x0006,0x0007,
      0x0110,0x0120,0x0130,0x0140,0x0150,0x0160,0x0170,0x0220,
      0x0230,0x0240,0x0250,0x0260,0x0270,0x0330,0x0340,0x0350,
      0x0360,0x0370,0x0440,0x0450,0x0460,0x0470,0x0550,0x0560,
      0x0570,0x0660,0x0670,0x0770,0x0111,0x0112,0x0113,0x0114,
      0x0115,0x0116,0x0117,0x2012,0x0123,0x0124,0x0125,0x0126,
      0x0127,0x3013,0x0134,0x0135,0x0136,0x0137,0x4014,0x0145,
      0x0146,0x0147,0x5015,0x0156,0x0157,0x6016,0x0167,0x7017,
      0x0222,0x0223,0x0224,0x0225,0x0226,0x0227,0x3023,0x0234,
      0x0235,0x0236,0x0237,0x4024,0x0245,0x0246,0x0247,0x5025,
      0x0256,0x0257,0x6026,0x0267,0x7027,0x0333,0x0334,0x0335,
      0x0336,0x0337,0x4034,0x0345,0x0346,0x0347,0x5035,0x0356,
      0x0357,0x6036,0x0367,0x7037,0x0444,0x0445,0x0446,0x0447,
      0x5045,0x0456,0x0457,0x6046,0x0467,0x7047,0x0555,0x0556,
      0x0557,0x6056,0x0567,0x7057,0x0666,0x0667,0x7067,0x0777,
             0x1112,0x1113,0x1114,0x1115,0x1116,0x1117,0x2112,
      0x1123,0x2114,0x2115,0x2116,0x2117,0x3113,0x3114,0x3115,
      0x3116,0x3117,0x4114,0x4115,0x4116,0x4117,0x5115,0x5116,
      0x5117,0x6116,0x6117,0x7117,0x1222,0x1223,0x1224,0x1225,
      0x1226,0x1227,0x3123,0x1234,0x1235,0x1236,0x1237,0x4124,
      0x1245,0x1246,0x1247,0x5125,0x1256,0x1257,0x6126,0x1267,
      0x7127,0x1333,0x1334,0x1335,0x1336,0x1337,0x4134,0x1345,
      0x1346,0x1347,0x5135,0x1356,0x1357,0x6136,0x1367,0x7137,
      0x1444,0x1445,0x1446,0x1447,0x5145,0x1456,0x1457,0x6146,
      0x1467,0x7147,0x1555,0x1556,0x1557,0x6156,0x1567,0x7157,
      0x1666,0x1667,0x7167,0x1777,       0x2223,0x2224,0x2225,
      0x2226,0x2227,0x3223,0x3224,0x3225,0x3226,0x3227,0x4224,
      0x4225,0x4226,0x4227,0x5225,0x5226,0x5227,0x6226,0x6227,
      0x7227,0x2333,0x2334,0x2335,0x2336,0x2337,0x4234,0x2345,
      0x2346,0x2347,0x5235,0x2356,0x2357,0x6236,0x2367,0x7237,
      0x2444,0x2445,0x2446,0x2447,0x5245,0x2456,0x2457,0x6246,
      0x2467,0x7247,0x2555,0x2556,0x2557,0x6256,0x2567,0x7257,
      0x2666,0x2667,0x7267,0x2777,       0x3334,0x3335,0x3336,
      0x3337,0x4334,0x4335,0x4336,0x4337,0x5335,0x5336,0x5337,
      0x6336,0x6337,0x7337,0x3444,0x3445,0x3446,0x3447,0x5345,
      0x3456,0x3457,0x6346,0x3467,0x7347,0x3555,0x3556,0x3557,
      0x6356,0x3567,0x7357,0x3666,0x3667,0x7367,0x3777,
      0x4445,0x4446,0x4447,0x5445,0x5446,0x5447,0x6446,0x6447,
      0x7447,0x4555,0x4556,0x4557,0x6456,0x4567,0x7457,0x4666,
      0x4667,0x7467,0x4777,       0x5556,0x5557,0x6556,0x6557,
      0x7557,0x5666,0x5667,0x7567,0x5777,       0x6667,0x7667,
      0x6777};

/*
 * The 3 tables below contain the red, green, and blue values (on a scale of
 *  0..255) of each of the 330 PaintJet colors.  These values are based on data
 *  generously provided by HP customer service.
 *       11 <- changed black's value from this, seemed wrong
 *         135 <- changed red's value from this
 *           11 <- changed blue's value from this
 */
unsigned char far pj_reds[] = {
        229,  2,145,  7,227,  9,136, 5,
             17, 10, 17, 10, 16, 10, 16, 29, 16, 32, 15, 30, 15, 31,  9,
	 15, 10, 15,  9, 13, 37, 15, 32, 16, 36, 10, 15,  9, 13, 30, 15,
	 31,  8, 13, 38, 62, 26, 68, 26, 63, 26, 68, 16, 35, 16, 33, 16,
	 33, 77, 26, 69, 29, 77, 16, 31, 16, 31, 64, 27, 71, 16, 36, 81,
	  9, 15, 10, 15,  8, 13, 37, 15, 31, 15, 33, 10, 15,  9, 13, 29,
	 15, 28,  8, 12, 28, 98, 28, 79, 32, 94, 16, 34, 17, 35, 73, 30,
	 82, 17, 43,101, 11, 15, 10, 13, 29, 15, 27,  9, 13, 25, 65, 27,
	 71, 16, 35, 88,  7, 12, 39,110,     54,146, 53,136, 58,144, 29,
	 57, 28, 53, 29, 56,159, 54,144, 61,160, 27, 51, 28, 52,135, 55,
	144, 30, 60,159, 14, 23, 15, 22, 14, 21, 64, 30, 58, 32, 64, 15,
	 22, 15, 21, 54, 31, 56, 14, 22, 64,185, 59,160, 69,185, 29, 57,
	 31, 60,145, 63,162, 33, 71,186, 15, 22, 16, 21, 50, 30, 52, 15,
	 21, 54,134, 58,145, 30, 60,161, 15, 22, 69,187,     13,  9, 14,
	  6, 11, 31, 14, 27, 12, 27, 10, 14,  9, 12, 24,  9, 23,  6,  9,
	 22, 76, 23, 61, 25, 74, 15, 29, 14, 28, 55, 23, 62, 12, 30, 73,
         11, 15, 10, 12, 25, 14, 23,  8, 11, 20, 50, 22, 53, 13, 26, 61,
          5,  8, 21, 71,     71,189, 87,227, 30, 63, 32, 69,164, 76,190,
         37, 89,227, 15, 22, 14, 20, 54, 31, 57, 14, 21, 63,147, 67,163,
         33, 72,191, 13, 24, 94,228,     15, 10, 13, 26, 14, 23, 10, 13,
         20, 50, 23, 50, 15, 26, 52,  8, 11, 23, 65,     60,147, 32, 67,
        166, 14, 24, 77,194,      8, 32, 97};

/*
 *                   11 <- changed black's value from this, seemed wrong
 *                           65 <- changed green from this
 */

unsigned char far pj_greens[] = {
        224,  2, 20, 72,211, 10, 11, 55,
             12, 15, 19, 11, 11, 14, 17, 14, 18, 22, 12, 13, 16, 19, 24,
         29, 16, 17, 23, 27, 41, 17, 22, 29, 39, 11, 10, 14, 14, 11, 14,
         17, 21, 25, 40, 16, 21, 28, 14, 16, 19, 25, 28, 37, 18, 20, 26,
         33, 48, 20, 26, 33, 46, 13, 12, 16, 18, 14, 18, 22, 24, 30, 42,
         40, 49, 25, 27, 39, 50, 69, 27, 33, 48, 66, 17, 17, 24, 27, 19,
         28, 35, 38, 48, 68,100, 32, 46, 65, 98, 18, 22, 29, 36, 27, 39,
         54, 49, 71,105, 11, 10, 14, 12, 10, 14, 13, 20, 20, 25, 11, 15,
         18, 22, 29, 49, 36, 46, 69,111,     23, 31, 16, 19, 22, 28, 30,
         37, 20, 22, 28, 34, 54, 22, 29, 36, 53, 14, 15, 17, 19, 17, 19,
         26, 25, 32, 46, 43, 50, 27, 28, 41, 49, 68, 29, 37, 51, 68, 19,
         19, 25, 28, 22, 30, 36, 40, 47, 66,104, 35, 51, 68,105, 20, 24,
         31, 37, 30, 38, 56, 50, 69,103, 13, 12, 15, 14, 13, 15, 16, 21,
         21, 26, 14, 16, 22, 23, 28, 44, 35, 42, 62,102,     78, 40, 44,
         65, 78, 98, 43, 53, 76, 99, 26, 27, 36, 40, 29, 43, 50, 63, 75,
         99,136, 49, 69, 98,142, 28, 32, 42, 51, 39, 52, 73, 77,103,145,
         17, 17, 21, 21, 18, 22, 24, 34, 37, 43, 19, 23, 30, 40, 48, 69,
         62, 76,101,147,     72,113,145,218, 33, 42, 52, 71, 61, 77,116,
        105,148,221, 18, 17, 21, 23, 21, 26, 30, 37, 43, 64, 30, 35, 48,
         50, 69,115, 77, 99,149,224,     10, 13, 11, 10, 12, 11, 17, 16,
         15,  9, 11, 12, 17, 17, 22, 26, 27, 36, 61,     14, 18, 21, 26,
         48, 34, 41, 68,115,     69, 99,149};

/*                    15 <- changed black's value from this, seemed wrong
 *                           56 <- changed green from this
 *                                          163 <- changed cyan from this
 */
unsigned char far pj_blues[] = {
        216,  2, 34, 48, 33, 73, 64,168,
             18, 19, 18, 20, 19, 22, 21, 22, 24, 22, 26, 24, 27, 24, 27,
         24, 29, 27, 31, 29, 22, 27, 25, 30, 28, 31, 29, 33, 33, 28, 32,
         32, 41, 40, 46, 28, 32, 28, 34, 30, 36, 31, 35, 32, 38, 34, 41,
         35, 27, 35, 31, 39, 34, 40, 37, 44, 40, 34, 42, 37, 49, 47, 45,
         40, 36, 43, 40, 47, 43, 33, 40, 36, 45, 41, 44, 41, 49, 46, 40,
         49, 45, 58, 56, 58, 30, 38, 34, 44, 40, 42, 39, 49, 46, 38, 49,
         46, 59, 62, 67, 49, 46, 55, 52, 44, 55, 52, 64, 64, 66, 43, 55,
         53, 66, 70, 78, 87, 91,101,115,     39, 34, 42, 37, 43, 36, 45,
         38, 47, 42, 49, 43, 34, 41, 36, 44, 38, 49, 45, 52, 46, 40, 47,
         42, 56, 51, 45, 49, 45, 52, 48, 56, 50, 40, 47, 44, 52, 47, 54,
         51, 59, 55, 47, 58, 50, 66, 60, 56, 34, 44, 38, 48, 42, 52, 47,
         56, 50, 42, 51, 46, 64, 59, 57, 60, 56, 64, 61, 52, 61, 57, 72,
         67, 64, 48, 58, 53, 69, 65, 65, 87, 83, 87, 94,     53, 59, 55,
         64, 60, 46, 53, 49, 59, 54, 60, 56, 65, 62, 53, 62, 58, 76, 71,
         68, 41, 50, 45, 56, 51, 58, 53, 63, 59, 49, 60, 56, 74, 71, 71,
         66, 63, 73, 70, 60, 69, 67, 84, 81, 79, 55, 67, 64, 84, 81, 83,
        104,104,106,116,     32, 40, 53, 48, 54, 50, 61, 57, 46, 59, 56,
         76, 75, 80, 64, 59, 70, 67, 57, 69, 65, 83, 81, 85, 54, 68, 66,
         86, 88, 96,110,114,125,137,     71, 81, 78, 68, 77, 76, 93, 92,
         90, 65, 77, 75, 92, 93, 96,117,119,126,138,     78, 79, 98,102,
        110,124,131,143,157,    173,185,200};
