------------------------------------------------------------------------------
--                                                                          --
--                         GNAT COMPILER COMPONENTS                         --
--                                                                          --
--     A D A . F I N A L I Z A T I O N . L I S T _ C O N T R O L L E R      --
--                                                                          --
--                                B o d y                                   --
--                                                                          --
--                            $Revision: 1.4 $                              --
--                                                                          --
--   Copyright (C) 1992,1993,1994,1995,1996 Free Software Foundation, Inc.  --
--                                                                          --
-- GNAT is free software;  you can  redistribute it  and/or modify it under --
-- terms of the  GNU General Public License as published  by the Free Soft- --
-- ware  Foundation;  either version 2,  or (at your option) any later ver- --
-- sion.  GNAT is distributed in the hope that it will be useful, but WITH- --
-- OUT ANY WARRANTY;  without even the  implied warranty of MERCHANTABILITY --
-- or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU General Public License --
-- for  more details.  You should have  received  a copy of the GNU General --
-- Public License  distributed with GNAT;  see file COPYING.  If not, write --
-- to  the Free Software Foundation,  59 Temple Place - Suite 330,  Boston, --
-- MA 02111-1307, USA.                                                      --
--                                                                          --
-- As a special exception,  if other files  instantiate  generics from this --
-- unit, or you link  this unit with other files  to produce an executable, --
-- this  unit  does not  by itself cause  the resulting  executable  to  be --
-- covered  by the  GNU  General  Public  License.  This exception does not --
-- however invalidate  any other reasons why  the executable file  might be --
-- covered by the  GNU Public License.                                      --
--                                                                          --
-- GNAT was originally developed  by the GNAT team at  New York University. --
-- It is now maintained by Ada Core Technologies Inc (http://www.gnat.com). --
--                                                                          --
------------------------------------------------------------------------------

with System.Finalization_Root;
package Ada.Finalization.List_Controller is

   package SFR renames System.Finalization_Root;

   type Mark is new SFR.Root_Controlled with null record;
   procedure Initialize (M : in out Mark);
   procedure Finalize   (M : in out Mark);
   --  For marking empty list_controller and making the detachement from a
   --  list completely dynamic.

   ---------------------
   -- List Controller --
   ---------------------

   type List_Controller is new Limited_Controlled with record
      F : SFR.Finalizable_Ptr;
      M : aliased Mark;
   end record;
   --  Controls the chains of dynamically allocated controlled
   --  objects makes sure that they get finalized upon exit of the
   --  access type that defined them

   procedure Initialize (Object : in out List_Controller);
   procedure Finalize   (Object : in out List_Controller);

   function Is_List_Controller (L : SFR.Finalizable_Ptr) return Boolean;
   --  True is L is a pointer to a List_Controller

   function Is_Empty_List_Controller (L : SFR.Finalizable_Ptr) return Boolean;
   --  True is L is a pointer to a List_Controller that has still
   --  F pointing to itelf

   procedure Update_List_Controller (L, Obj_Ref : SFR.Finalizable_Ptr);
   --  L must be a List_Controller. Update the object pointed by L.F to be
   --   Obj_Ref

   pragma Inline (Is_Empty_List_Controller);
   pragma Inline (Is_List_Controller);
   pragma Inline (Update_List_Controller);

end Ada.Finalization.List_Controller;
